/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.layout.seo.model.impl;

import com.liferay.layout.seo.model.LayoutSEOSite;
import com.liferay.layout.seo.service.LayoutSEOSiteLocalServiceUtil;

/**
 * The extended model base implementation for the LayoutSEOSite service. Represents a row in the &quot;LayoutSEOSite&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link LayoutSEOSiteImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see LayoutSEOSiteImpl
 * @see LayoutSEOSite
 * @generated
 */
public abstract class LayoutSEOSiteBaseImpl
	extends LayoutSEOSiteModelImpl implements LayoutSEOSite {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a layout seo site model instance should use the <code>LayoutSEOSite</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			LayoutSEOSiteLocalServiceUtil.addLayoutSEOSite(this);
		}
		else {
			LayoutSEOSiteLocalServiceUtil.updateLayoutSEOSite(this);
		}
	}

}