/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.layout.seo.model.impl;

import com.liferay.layout.seo.model.LayoutSEOEntry;
import com.liferay.layout.seo.service.LayoutSEOEntryLocalServiceUtil;

/**
 * The extended model base implementation for the LayoutSEOEntry service. Represents a row in the &quot;LayoutSEOEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link LayoutSEOEntryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see LayoutSEOEntryImpl
 * @see LayoutSEOEntry
 * @generated
 */
public abstract class LayoutSEOEntryBaseImpl
	extends LayoutSEOEntryModelImpl implements LayoutSEOEntry {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a layout seo entry model instance should use the <code>LayoutSEOEntry</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			LayoutSEOEntryLocalServiceUtil.addLayoutSEOEntry(this);
		}
		else {
			LayoutSEOEntryLocalServiceUtil.updateLayoutSEOEntry(this);
		}
	}

}