/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.layout.seo.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.layout.seo.model.LayoutSEOEntryCustomMetaTag;
import com.liferay.layout.seo.model.LayoutSEOEntryCustomMetaTagModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the LayoutSEOEntryCustomMetaTag service. Represents a row in the &quot;LayoutSEOEntryCustomMetaTag&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>LayoutSEOEntryCustomMetaTagModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link LayoutSEOEntryCustomMetaTagImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see LayoutSEOEntryCustomMetaTagImpl
 * @generated
 */
public class LayoutSEOEntryCustomMetaTagModelImpl
	extends BaseModelImpl<LayoutSEOEntryCustomMetaTag>
	implements LayoutSEOEntryCustomMetaTagModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a layout seo entry custom meta tag model instance should use the <code>LayoutSEOEntryCustomMetaTag</code> interface instead.
	 */
	public static final String TABLE_NAME = "LayoutSEOEntryCustomMetaTag";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"layoutSEOEntryCustomMetaTagId", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"layoutSEOEntryId", Types.BIGINT}, {"content", Types.VARCHAR},
		{"property", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("layoutSEOEntryCustomMetaTagId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("layoutSEOEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("content", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("property", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table LayoutSEOEntryCustomMetaTag (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,layoutSEOEntryCustomMetaTagId LONG not null,groupId LONG,companyId LONG,layoutSEOEntryId LONG,content STRING null,property VARCHAR(75) null,primary key (layoutSEOEntryCustomMetaTagId, ctCollectionId))";

	public static final String TABLE_SQL_DROP =
		"drop table LayoutSEOEntryCustomMetaTag";

	public static final String ORDER_BY_JPQL =
		" ORDER BY layoutSEOEntryCustomMetaTag.layoutSEOEntryCustomMetaTagId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY LayoutSEOEntryCustomMetaTag.layoutSEOEntryCustomMetaTagId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long LAYOUTSEOENTRYID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long LAYOUTSEOENTRYCUSTOMMETATAGID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public LayoutSEOEntryCustomMetaTagModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _layoutSEOEntryCustomMetaTagId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setLayoutSEOEntryCustomMetaTagId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _layoutSEOEntryCustomMetaTagId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return LayoutSEOEntryCustomMetaTag.class;
	}

	@Override
	public String getModelClassName() {
		return LayoutSEOEntryCustomMetaTag.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<LayoutSEOEntryCustomMetaTag, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<LayoutSEOEntryCustomMetaTag, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<LayoutSEOEntryCustomMetaTag, Object>
				attributeGetterFunction = entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply(
					(LayoutSEOEntryCustomMetaTag)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<LayoutSEOEntryCustomMetaTag, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<LayoutSEOEntryCustomMetaTag, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(LayoutSEOEntryCustomMetaTag)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<LayoutSEOEntryCustomMetaTag, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<LayoutSEOEntryCustomMetaTag, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map
			<String, Function<LayoutSEOEntryCustomMetaTag, Object>>
				_attributeGetterFunctions;

		static {
			Map<String, Function<LayoutSEOEntryCustomMetaTag, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String,
						 Function<LayoutSEOEntryCustomMetaTag, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", LayoutSEOEntryCustomMetaTag::getMvccVersion);
			attributeGetterFunctions.put(
				"ctCollectionId",
				LayoutSEOEntryCustomMetaTag::getCtCollectionId);
			attributeGetterFunctions.put(
				"layoutSEOEntryCustomMetaTagId",
				LayoutSEOEntryCustomMetaTag::getLayoutSEOEntryCustomMetaTagId);
			attributeGetterFunctions.put(
				"groupId", LayoutSEOEntryCustomMetaTag::getGroupId);
			attributeGetterFunctions.put(
				"companyId", LayoutSEOEntryCustomMetaTag::getCompanyId);
			attributeGetterFunctions.put(
				"layoutSEOEntryId",
				LayoutSEOEntryCustomMetaTag::getLayoutSEOEntryId);
			attributeGetterFunctions.put(
				"content", LayoutSEOEntryCustomMetaTag::getContent);
			attributeGetterFunctions.put(
				"property", LayoutSEOEntryCustomMetaTag::getProperty);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map
			<String, BiConsumer<LayoutSEOEntryCustomMetaTag, Object>>
				_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<LayoutSEOEntryCustomMetaTag, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap
						<String, BiConsumer<LayoutSEOEntryCustomMetaTag, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<LayoutSEOEntryCustomMetaTag, Long>)
					LayoutSEOEntryCustomMetaTag::setMvccVersion);
			attributeSetterBiConsumers.put(
				"ctCollectionId",
				(BiConsumer<LayoutSEOEntryCustomMetaTag, Long>)
					LayoutSEOEntryCustomMetaTag::setCtCollectionId);
			attributeSetterBiConsumers.put(
				"layoutSEOEntryCustomMetaTagId",
				(BiConsumer<LayoutSEOEntryCustomMetaTag, Long>)
					LayoutSEOEntryCustomMetaTag::
						setLayoutSEOEntryCustomMetaTagId);
			attributeSetterBiConsumers.put(
				"groupId",
				(BiConsumer<LayoutSEOEntryCustomMetaTag, Long>)
					LayoutSEOEntryCustomMetaTag::setGroupId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<LayoutSEOEntryCustomMetaTag, Long>)
					LayoutSEOEntryCustomMetaTag::setCompanyId);
			attributeSetterBiConsumers.put(
				"layoutSEOEntryId",
				(BiConsumer<LayoutSEOEntryCustomMetaTag, Long>)
					LayoutSEOEntryCustomMetaTag::setLayoutSEOEntryId);
			attributeSetterBiConsumers.put(
				"content",
				(BiConsumer<LayoutSEOEntryCustomMetaTag, String>)
					LayoutSEOEntryCustomMetaTag::setContent);
			attributeSetterBiConsumers.put(
				"property",
				(BiConsumer<LayoutSEOEntryCustomMetaTag, String>)
					LayoutSEOEntryCustomMetaTag::setProperty);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@Override
	public long getLayoutSEOEntryCustomMetaTagId() {
		return _layoutSEOEntryCustomMetaTagId;
	}

	@Override
	public void setLayoutSEOEntryCustomMetaTagId(
		long layoutSEOEntryCustomMetaTagId) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_layoutSEOEntryCustomMetaTagId = layoutSEOEntryCustomMetaTagId;
	}

	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@Override
	public long getLayoutSEOEntryId() {
		return _layoutSEOEntryId;
	}

	@Override
	public void setLayoutSEOEntryId(long layoutSEOEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_layoutSEOEntryId = layoutSEOEntryId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalLayoutSEOEntryId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("layoutSEOEntryId"));
	}

	@Override
	public String getContent() {
		if (_content == null) {
			return "";
		}
		else {
			return _content;
		}
	}

	@Override
	public String getContent(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getContent(languageId);
	}

	@Override
	public String getContent(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getContent(languageId, useDefault);
	}

	@Override
	public String getContent(String languageId) {
		return LocalizationUtil.getLocalization(getContent(), languageId);
	}

	@Override
	public String getContent(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getContent(), languageId, useDefault);
	}

	@Override
	public String getContentCurrentLanguageId() {
		return _contentCurrentLanguageId;
	}

	@JSON
	@Override
	public String getContentCurrentValue() {
		Locale locale = getLocale(_contentCurrentLanguageId);

		return getContent(locale);
	}

	@Override
	public Map<Locale, String> getContentMap() {
		return LocalizationUtil.getLocalizationMap(getContent());
	}

	@Override
	public void setContent(String content) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_content = content;
	}

	@Override
	public void setContent(String content, Locale locale) {
		setContent(content, locale, LocaleUtil.getDefault());
	}

	@Override
	public void setContent(
		String content, Locale locale, Locale defaultLocale) {

		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(content)) {
			setContent(
				LocalizationUtil.updateLocalization(
					getContent(), "Content", content, languageId,
					defaultLanguageId));
		}
		else {
			setContent(
				LocalizationUtil.removeLocalization(
					getContent(), "Content", languageId));
		}
	}

	@Override
	public void setContentCurrentLanguageId(String languageId) {
		_contentCurrentLanguageId = languageId;
	}

	@Override
	public void setContentMap(Map<Locale, String> contentMap) {
		setContentMap(contentMap, LocaleUtil.getDefault());
	}

	@Override
	public void setContentMap(
		Map<Locale, String> contentMap, Locale defaultLocale) {

		if (contentMap == null) {
			return;
		}

		setContent(
			LocalizationUtil.updateLocalization(
				contentMap, getContent(), "Content",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@Override
	public String getProperty() {
		if (_property == null) {
			return "";
		}
		else {
			return _property;
		}
	}

	@Override
	public void setProperty(String property) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_property = property;
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), LayoutSEOEntryCustomMetaTag.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public String[] getAvailableLanguageIds() {
		Set<String> availableLanguageIds = new TreeSet<String>();

		Map<Locale, String> contentMap = getContentMap();

		for (Map.Entry<Locale, String> entry : contentMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		return availableLanguageIds.toArray(
			new String[availableLanguageIds.size()]);
	}

	@Override
	public String getDefaultLanguageId() {
		String xml = getContent();

		if (xml == null) {
			return "";
		}

		Locale defaultLocale = LocaleUtil.getDefault();

		return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
	}

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException {
		Locale defaultLocale = LocaleUtil.fromLanguageId(
			getDefaultLanguageId());

		Locale[] availableLocales = LocaleUtil.fromLanguageIds(
			getAvailableLanguageIds());

		Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(
			LayoutSEOEntryCustomMetaTag.class.getName(), getPrimaryKey(),
			defaultLocale, availableLocales);

		prepareLocalizedFieldsForImport(defaultImportLocale);
	}

	@Override
	@SuppressWarnings("unused")
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException {

		Locale defaultLocale = LocaleUtil.getDefault();

		String modelDefaultLanguageId = getDefaultLanguageId();

		String content = getContent(defaultLocale);

		if (Validator.isNull(content)) {
			setContent(getContent(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setContent(getContent(defaultLocale), defaultLocale, defaultLocale);
		}
	}

	@Override
	public LayoutSEOEntryCustomMetaTag toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, LayoutSEOEntryCustomMetaTag>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		LayoutSEOEntryCustomMetaTagImpl layoutSEOEntryCustomMetaTagImpl =
			new LayoutSEOEntryCustomMetaTagImpl();

		layoutSEOEntryCustomMetaTagImpl.setMvccVersion(getMvccVersion());
		layoutSEOEntryCustomMetaTagImpl.setCtCollectionId(getCtCollectionId());
		layoutSEOEntryCustomMetaTagImpl.setLayoutSEOEntryCustomMetaTagId(
			getLayoutSEOEntryCustomMetaTagId());
		layoutSEOEntryCustomMetaTagImpl.setGroupId(getGroupId());
		layoutSEOEntryCustomMetaTagImpl.setCompanyId(getCompanyId());
		layoutSEOEntryCustomMetaTagImpl.setLayoutSEOEntryId(
			getLayoutSEOEntryId());
		layoutSEOEntryCustomMetaTagImpl.setContent(getContent());
		layoutSEOEntryCustomMetaTagImpl.setProperty(getProperty());

		layoutSEOEntryCustomMetaTagImpl.resetOriginalValues();

		return layoutSEOEntryCustomMetaTagImpl;
	}

	@Override
	public LayoutSEOEntryCustomMetaTag cloneWithOriginalValues() {
		LayoutSEOEntryCustomMetaTagImpl layoutSEOEntryCustomMetaTagImpl =
			new LayoutSEOEntryCustomMetaTagImpl();

		layoutSEOEntryCustomMetaTagImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		layoutSEOEntryCustomMetaTagImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		layoutSEOEntryCustomMetaTagImpl.setLayoutSEOEntryCustomMetaTagId(
			this.<Long>getColumnOriginalValue("layoutSEOEntryCustomMetaTagId"));
		layoutSEOEntryCustomMetaTagImpl.setGroupId(
			this.<Long>getColumnOriginalValue("groupId"));
		layoutSEOEntryCustomMetaTagImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		layoutSEOEntryCustomMetaTagImpl.setLayoutSEOEntryId(
			this.<Long>getColumnOriginalValue("layoutSEOEntryId"));
		layoutSEOEntryCustomMetaTagImpl.setContent(
			this.<String>getColumnOriginalValue("content"));
		layoutSEOEntryCustomMetaTagImpl.setProperty(
			this.<String>getColumnOriginalValue("property"));

		return layoutSEOEntryCustomMetaTagImpl;
	}

	@Override
	public int compareTo(
		LayoutSEOEntryCustomMetaTag layoutSEOEntryCustomMetaTag) {

		long primaryKey = layoutSEOEntryCustomMetaTag.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof LayoutSEOEntryCustomMetaTag)) {
			return false;
		}

		LayoutSEOEntryCustomMetaTag layoutSEOEntryCustomMetaTag =
			(LayoutSEOEntryCustomMetaTag)object;

		long primaryKey = layoutSEOEntryCustomMetaTag.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<LayoutSEOEntryCustomMetaTag> toCacheModel() {
		LayoutSEOEntryCustomMetaTagCacheModel
			layoutSEOEntryCustomMetaTagCacheModel =
				new LayoutSEOEntryCustomMetaTagCacheModel();

		layoutSEOEntryCustomMetaTagCacheModel.mvccVersion = getMvccVersion();

		layoutSEOEntryCustomMetaTagCacheModel.ctCollectionId =
			getCtCollectionId();

		layoutSEOEntryCustomMetaTagCacheModel.layoutSEOEntryCustomMetaTagId =
			getLayoutSEOEntryCustomMetaTagId();

		layoutSEOEntryCustomMetaTagCacheModel.groupId = getGroupId();

		layoutSEOEntryCustomMetaTagCacheModel.companyId = getCompanyId();

		layoutSEOEntryCustomMetaTagCacheModel.layoutSEOEntryId =
			getLayoutSEOEntryId();

		layoutSEOEntryCustomMetaTagCacheModel.content = getContent();

		String content = layoutSEOEntryCustomMetaTagCacheModel.content;

		if ((content != null) && (content.length() == 0)) {
			layoutSEOEntryCustomMetaTagCacheModel.content = null;
		}

		layoutSEOEntryCustomMetaTagCacheModel.property = getProperty();

		String property = layoutSEOEntryCustomMetaTagCacheModel.property;

		if ((property != null) && (property.length() == 0)) {
			layoutSEOEntryCustomMetaTagCacheModel.property = null;
		}

		return layoutSEOEntryCustomMetaTagCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<LayoutSEOEntryCustomMetaTag, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<LayoutSEOEntryCustomMetaTag, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<LayoutSEOEntryCustomMetaTag, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(LayoutSEOEntryCustomMetaTag)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function
			<InvocationHandler, LayoutSEOEntryCustomMetaTag>
				_escapedModelProxyProviderFunction =
					ProxyUtil.getProxyProviderFunction(
						LayoutSEOEntryCustomMetaTag.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private long _layoutSEOEntryCustomMetaTagId;
	private long _groupId;
	private long _companyId;
	private long _layoutSEOEntryId;
	private String _content;
	private String _contentCurrentLanguageId;
	private String _property;

	public <T> T getColumnValue(String columnName) {
		Function<LayoutSEOEntryCustomMetaTag, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((LayoutSEOEntryCustomMetaTag)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put(
			"layoutSEOEntryCustomMetaTagId", _layoutSEOEntryCustomMetaTagId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("layoutSEOEntryId", _layoutSEOEntryId);
		_columnOriginalValues.put("content", _content);
		_columnOriginalValues.put("property", _property);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("layoutSEOEntryCustomMetaTagId", 4L);

		columnBitmasks.put("groupId", 8L);

		columnBitmasks.put("companyId", 16L);

		columnBitmasks.put("layoutSEOEntryId", 32L);

		columnBitmasks.put("content", 64L);

		columnBitmasks.put("property", 128L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private LayoutSEOEntryCustomMetaTag _escapedModel;

}