/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.seo.internal.open.graph;

import com.liferay.layout.seo.internal.configuration.LayoutSEOCompanyConfiguration;
import com.liferay.layout.seo.internal.configuration.LayoutSEOGroupConfiguration;
import com.liferay.layout.seo.model.LayoutSEOSite;
import com.liferay.layout.seo.open.graph.OpenGraphConfiguration;
import com.liferay.layout.seo.service.LayoutSEOSiteLocalService;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.CompanyLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={OpenGraphConfiguration.class})
public class OpenGraphConfigurationImpl
implements OpenGraphConfiguration {
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private LayoutSEOSiteLocalService _layoutSEOSiteLocalService;

    public boolean isLayoutTranslatedLanguagesEnabled(Company company) throws PortalException {
        LayoutSEOCompanyConfiguration layoutSEOCompanyConfiguration = (LayoutSEOCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(LayoutSEOCompanyConfiguration.class, company.getCompanyId());
        if (!layoutSEOCompanyConfiguration.enableOpenGraph()) {
            return false;
        }
        return layoutSEOCompanyConfiguration.enableLayoutTranslatedLanguages();
    }

    public boolean isLayoutTranslatedLanguagesEnabled(Group group) throws PortalException {
        Company company = this._companyLocalService.getCompany(group.getCompanyId());
        LayoutSEOCompanyConfiguration layoutSEOCompanyConfiguration = (LayoutSEOCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(LayoutSEOCompanyConfiguration.class, company.getCompanyId());
        if (!layoutSEOCompanyConfiguration.enableOpenGraph() || !this._isOpenGraphEnabled(group)) {
            return false;
        }
        if (layoutSEOCompanyConfiguration.enableLayoutTranslatedLanguages()) {
            return true;
        }
        LayoutSEOGroupConfiguration layoutSEOGroupConfiguration = (LayoutSEOGroupConfiguration)this._configurationProvider.getGroupConfiguration(LayoutSEOGroupConfiguration.class, group.getGroupId());
        return layoutSEOGroupConfiguration.enableLayoutTranslatedLanguages();
    }

    public boolean isOpenGraphEnabled(Company company) throws PortalException {
        LayoutSEOCompanyConfiguration layoutSEOCompanyConfiguration = (LayoutSEOCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(LayoutSEOCompanyConfiguration.class, company.getCompanyId());
        return layoutSEOCompanyConfiguration.enableOpenGraph();
    }

    public boolean isOpenGraphEnabled(Group group) throws PortalException {
        if (!this.isOpenGraphEnabled(this._companyLocalService.getCompany(group.getCompanyId()))) {
            return false;
        }
        return this._isOpenGraphEnabled(group);
    }

    private boolean _isOpenGraphEnabled(Group group) {
        LayoutSEOSite layoutSEOSite = this._layoutSEOSiteLocalService.fetchLayoutSEOSiteByGroupId(group.getGroupId());
        return layoutSEOSite == null || layoutSEOSite.isOpenGraphEnabled();
    }
}

