/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.seo.internal.exportimport.data.handler;

import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.exportimport.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.layout.seo.model.LayoutSEOEntry;
import com.liferay.layout.seo.service.LayoutSEOEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StagedModelDataHandler.class})
public class LayoutSEOEntryStagedModelDataHandler
extends BaseStagedModelDataHandler<LayoutSEOEntry> {
    public static final String[] CLASS_NAMES = new String[]{LayoutSEOEntry.class.getName()};
    private static final Log _log = LogFactoryUtil.getLog(LayoutSEOEntryStagedModelDataHandler.class);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference(target="(ddm.form.values.serializer.type=json)")
    private DDMFormValuesSerializer _jsonDDMFormValuesSerializer;
    @Reference
    private LayoutSEOEntryLocalService _layoutSEOEntryLocalService;
    @Reference
    private StorageEngine _storageEngine;

    public void deleteStagedModel(LayoutSEOEntry layoutSEOEntry) {
        this._layoutSEOEntryLocalService.deleteLayoutSEOEntry(layoutSEOEntry);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        this._layoutSEOEntryLocalService.deleteLayoutSEOEntry(uuid, groupId);
    }

    public List<LayoutSEOEntry> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return Collections.singletonList(this._layoutSEOEntryLocalService.fetchLayoutSEOEntryByUuidAndGroupId(uuid, companyId));
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, LayoutSEOEntry layoutSEOEntry) throws Exception {
        FileEntry openGraphImageFileEntry = this._fetchFileEntry(layoutSEOEntry.getOpenGraphImageFileEntryId());
        if (openGraphImageFileEntry != null) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)layoutSEOEntry, (StagedModel)openGraphImageFileEntry, (String)"weak");
        }
        DDMStructure ddmStructure = this._getDDMStructure(portletDataContext.getCompanyId());
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)layoutSEOEntry, (StagedModel)ddmStructure, (String)"strong");
        Element layoutSEOEntryElement = portletDataContext.getExportDataElement((ClassedModel)layoutSEOEntry);
        Element structureFieldsElement = layoutSEOEntryElement.addElement("structure-fields");
        if (layoutSEOEntry.getDDMStorageId() != 0L) {
            String ddmFormValuesPath = ExportImportPathUtil.getModelPath((StagedModel)ddmStructure, (String)String.valueOf(layoutSEOEntry.getDDMStorageId()));
            structureFieldsElement.addAttribute("ddm-form-values-path", ddmFormValuesPath);
            DDMFormValuesSerializerSerializeResponse ddmFormValuesSerializerSerializeResponse = this._jsonDDMFormValuesSerializer.serialize(DDMFormValuesSerializerSerializeRequest.Builder.newBuilder((DDMFormValues)this._storageEngine.getDDMFormValues(layoutSEOEntry.getDDMStorageId())).build());
            portletDataContext.addZipEntry(ddmFormValuesPath, ddmFormValuesSerializerSerializeResponse.getContent());
        }
        portletDataContext.addClassedModel(layoutSEOEntryElement, ExportImportPathUtil.getModelPath((StagedModel)layoutSEOEntry), (ClassedModel)layoutSEOEntry);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, LayoutSEOEntry layoutSEOEntry) throws Exception {
        Map fileEntryIds = portletDataContext.getNewPrimaryKeysMap(FileEntry.class);
        long openGraphImageFileEntryId = MapUtil.getLong((Map)fileEntryIds, (long)layoutSEOEntry.getOpenGraphImageFileEntryId(), (long)0L);
        LayoutSEOEntry existingLayoutSEOEntry = (LayoutSEOEntry)this.fetchStagedModelByUuidAndGroupId(layoutSEOEntry.getUuid(), layoutSEOEntry.getGroupId());
        if (existingLayoutSEOEntry == null) {
            Map newPrimaryKeysMap = portletDataContext.getNewPrimaryKeysMap(Layout.class + ".layout");
            Layout layout = (Layout)newPrimaryKeysMap.get(layoutSEOEntry.getLayoutId());
            this._layoutSEOEntryLocalService.updateLayoutSEOEntry(layoutSEOEntry.getUserId(), layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), layoutSEOEntry.isCanonicalURLEnabled(), layoutSEOEntry.getCanonicalURLMap(), layoutSEOEntry.isOpenGraphDescriptionEnabled(), layoutSEOEntry.getOpenGraphDescriptionMap(), layoutSEOEntry.getOpenGraphImageAltMap(), openGraphImageFileEntryId, layoutSEOEntry.isOpenGraphTitleEnabled(), layoutSEOEntry.getOpenGraphTitleMap(), this._createServiceContext(layoutSEOEntry, portletDataContext));
        } else {
            this._layoutSEOEntryLocalService.updateLayoutSEOEntry(existingLayoutSEOEntry.getUserId(), portletDataContext.getScopeGroupId(), layoutSEOEntry.isPrivateLayout(), existingLayoutSEOEntry.getLayoutId(), layoutSEOEntry.isCanonicalURLEnabled(), layoutSEOEntry.getCanonicalURLMap(), layoutSEOEntry.isOpenGraphDescriptionEnabled(), layoutSEOEntry.getOpenGraphDescriptionMap(), layoutSEOEntry.getOpenGraphImageAltMap(), openGraphImageFileEntryId, layoutSEOEntry.isOpenGraphTitleEnabled(), layoutSEOEntry.getOpenGraphTitleMap(), this._createServiceContext(layoutSEOEntry, portletDataContext));
        }
    }

    private ServiceContext _createServiceContext(LayoutSEOEntry layoutSEOEntry, PortletDataContext portletDataContext) throws Exception {
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)layoutSEOEntry);
        DDMStructure ddmStructure = this._getDDMStructure(portletDataContext.getCompanyId());
        Element layoutSEOEntryElement = portletDataContext.getImportDataElement((StagedModel)layoutSEOEntry);
        Element structureFieldsElement = (Element)layoutSEOEntryElement.selectSingleNode("structure-fields");
        String serializedDDMFormValues = portletDataContext.getZipEntryAsString(structureFieldsElement.attributeValue("ddm-form-values-path"));
        serviceContext.setAttribute(ddmStructure.getStructureId() + "ddmFormValues", (Serializable)((Object)serializedDDMFormValues));
        return serviceContext;
    }

    private FileEntry _fetchFileEntry(long fileEntryId) {
        if (fileEntryId <= 0L) {
            return null;
        }
        try {
            return this._dlAppLocalService.getFileEntry(fileEntryId);
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get file entry " + fileEntryId), (Throwable)portalException);
            }
            return null;
        }
    }

    private DDMStructure _getDDMStructure(long companyId) throws Exception {
        Group companyGroup = this._groupLocalService.getCompanyGroup(companyId);
        return this._ddmStructureLocalService.getStructure(companyGroup.getGroupId(), this._classNameLocalService.getClassNameId(LayoutSEOEntry.class.getName()), "custom-meta-tags");
    }
}

