/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.layout.seo.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.layout.seo.model.LayoutSEOEntry;
import com.liferay.layout.seo.model.LayoutSEOEntryModel;
import com.liferay.layout.seo.model.LayoutSEOEntrySoap;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the LayoutSEOEntry service. Represents a row in the &quot;LayoutSEOEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>LayoutSEOEntryModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link LayoutSEOEntryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see LayoutSEOEntryImpl
 * @generated
 */
@JSON(strict = true)
public class LayoutSEOEntryModelImpl
	extends BaseModelImpl<LayoutSEOEntry> implements LayoutSEOEntryModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a layout seo entry model instance should use the <code>LayoutSEOEntry</code> interface instead.
	 */
	public static final String TABLE_NAME = "LayoutSEOEntry";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"uuid_", Types.VARCHAR}, {"layoutSEOEntryId", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"privateLayout", Types.BOOLEAN}, {"layoutId", Types.BIGINT},
		{"canonicalURL", Types.VARCHAR}, {"canonicalURLEnabled", Types.BOOLEAN},
		{"DDMStorageId", Types.BIGINT}, {"openGraphDescription", Types.VARCHAR},
		{"openGraphDescriptionEnabled", Types.BOOLEAN},
		{"openGraphImageAlt", Types.VARCHAR},
		{"openGraphImageFileEntryId", Types.BIGINT},
		{"openGraphTitle", Types.VARCHAR},
		{"openGraphTitleEnabled", Types.BOOLEAN},
		{"lastPublishDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("layoutSEOEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("privateLayout", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("layoutId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("canonicalURL", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("canonicalURLEnabled", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("DDMStorageId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("openGraphDescription", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("openGraphDescriptionEnabled", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("openGraphImageAlt", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("openGraphImageFileEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("openGraphTitle", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("openGraphTitleEnabled", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table LayoutSEOEntry (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,uuid_ VARCHAR(75) null,layoutSEOEntryId LONG not null,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,privateLayout BOOLEAN,layoutId LONG,canonicalURL STRING null,canonicalURLEnabled BOOLEAN,DDMStorageId LONG,openGraphDescription STRING null,openGraphDescriptionEnabled BOOLEAN,openGraphImageAlt STRING null,openGraphImageFileEntryId LONG,openGraphTitle STRING null,openGraphTitleEnabled BOOLEAN,lastPublishDate DATE null,primary key (layoutSEOEntryId, ctCollectionId))";

	public static final String TABLE_SQL_DROP = "drop table LayoutSEOEntry";

	public static final String ORDER_BY_JPQL =
		" ORDER BY layoutSEOEntry.layoutSEOEntryId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY LayoutSEOEntry.layoutSEOEntryId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long LAYOUTID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PRIVATELAYOUT_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long LAYOUTSEOENTRYID_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static LayoutSEOEntry toModel(LayoutSEOEntrySoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		LayoutSEOEntry model = new LayoutSEOEntryImpl();

		model.setMvccVersion(soapModel.getMvccVersion());
		model.setCtCollectionId(soapModel.getCtCollectionId());
		model.setUuid(soapModel.getUuid());
		model.setLayoutSEOEntryId(soapModel.getLayoutSEOEntryId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setPrivateLayout(soapModel.isPrivateLayout());
		model.setLayoutId(soapModel.getLayoutId());
		model.setCanonicalURL(soapModel.getCanonicalURL());
		model.setCanonicalURLEnabled(soapModel.isCanonicalURLEnabled());
		model.setDDMStorageId(soapModel.getDDMStorageId());
		model.setOpenGraphDescription(soapModel.getOpenGraphDescription());
		model.setOpenGraphDescriptionEnabled(
			soapModel.isOpenGraphDescriptionEnabled());
		model.setOpenGraphImageAlt(soapModel.getOpenGraphImageAlt());
		model.setOpenGraphImageFileEntryId(
			soapModel.getOpenGraphImageFileEntryId());
		model.setOpenGraphTitle(soapModel.getOpenGraphTitle());
		model.setOpenGraphTitleEnabled(soapModel.isOpenGraphTitleEnabled());
		model.setLastPublishDate(soapModel.getLastPublishDate());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static List<LayoutSEOEntry> toModels(
		LayoutSEOEntrySoap[] soapModels) {

		if (soapModels == null) {
			return null;
		}

		List<LayoutSEOEntry> models = new ArrayList<LayoutSEOEntry>(
			soapModels.length);

		for (LayoutSEOEntrySoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public LayoutSEOEntryModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _layoutSEOEntryId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setLayoutSEOEntryId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _layoutSEOEntryId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return LayoutSEOEntry.class;
	}

	@Override
	public String getModelClassName() {
		return LayoutSEOEntry.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<LayoutSEOEntry, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<LayoutSEOEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<LayoutSEOEntry, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((LayoutSEOEntry)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<LayoutSEOEntry, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<LayoutSEOEntry, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(LayoutSEOEntry)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<LayoutSEOEntry, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<LayoutSEOEntry, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<LayoutSEOEntry, Object>>
		_attributeGetterFunctions;

	static {
		Map<String, Function<LayoutSEOEntry, Object>> attributeGetterFunctions =
			new LinkedHashMap<String, Function<LayoutSEOEntry, Object>>();

		attributeGetterFunctions.put(
			"mvccVersion", LayoutSEOEntry::getMvccVersion);
		attributeGetterFunctions.put(
			"ctCollectionId", LayoutSEOEntry::getCtCollectionId);
		attributeGetterFunctions.put("uuid", LayoutSEOEntry::getUuid);
		attributeGetterFunctions.put(
			"layoutSEOEntryId", LayoutSEOEntry::getLayoutSEOEntryId);
		attributeGetterFunctions.put("groupId", LayoutSEOEntry::getGroupId);
		attributeGetterFunctions.put("companyId", LayoutSEOEntry::getCompanyId);
		attributeGetterFunctions.put("userId", LayoutSEOEntry::getUserId);
		attributeGetterFunctions.put("userName", LayoutSEOEntry::getUserName);
		attributeGetterFunctions.put(
			"createDate", LayoutSEOEntry::getCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", LayoutSEOEntry::getModifiedDate);
		attributeGetterFunctions.put(
			"privateLayout", LayoutSEOEntry::getPrivateLayout);
		attributeGetterFunctions.put("layoutId", LayoutSEOEntry::getLayoutId);
		attributeGetterFunctions.put(
			"canonicalURL", LayoutSEOEntry::getCanonicalURL);
		attributeGetterFunctions.put(
			"canonicalURLEnabled", LayoutSEOEntry::getCanonicalURLEnabled);
		attributeGetterFunctions.put(
			"DDMStorageId", LayoutSEOEntry::getDDMStorageId);
		attributeGetterFunctions.put(
			"openGraphDescription", LayoutSEOEntry::getOpenGraphDescription);
		attributeGetterFunctions.put(
			"openGraphDescriptionEnabled",
			LayoutSEOEntry::getOpenGraphDescriptionEnabled);
		attributeGetterFunctions.put(
			"openGraphImageAlt", LayoutSEOEntry::getOpenGraphImageAlt);
		attributeGetterFunctions.put(
			"openGraphImageFileEntryId",
			LayoutSEOEntry::getOpenGraphImageFileEntryId);
		attributeGetterFunctions.put(
			"openGraphTitle", LayoutSEOEntry::getOpenGraphTitle);
		attributeGetterFunctions.put(
			"openGraphTitleEnabled", LayoutSEOEntry::getOpenGraphTitleEnabled);
		attributeGetterFunctions.put(
			"lastPublishDate", LayoutSEOEntry::getLastPublishDate);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
	}

	private static final Map<String, BiConsumer<LayoutSEOEntry, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, BiConsumer<LayoutSEOEntry, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<LayoutSEOEntry, ?>>();

		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<LayoutSEOEntry, Long>)LayoutSEOEntry::setMvccVersion);
		attributeSetterBiConsumers.put(
			"ctCollectionId",
			(BiConsumer<LayoutSEOEntry, Long>)
				LayoutSEOEntry::setCtCollectionId);
		attributeSetterBiConsumers.put(
			"uuid",
			(BiConsumer<LayoutSEOEntry, String>)LayoutSEOEntry::setUuid);
		attributeSetterBiConsumers.put(
			"layoutSEOEntryId",
			(BiConsumer<LayoutSEOEntry, Long>)
				LayoutSEOEntry::setLayoutSEOEntryId);
		attributeSetterBiConsumers.put(
			"groupId",
			(BiConsumer<LayoutSEOEntry, Long>)LayoutSEOEntry::setGroupId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<LayoutSEOEntry, Long>)LayoutSEOEntry::setCompanyId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<LayoutSEOEntry, Long>)LayoutSEOEntry::setUserId);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<LayoutSEOEntry, String>)LayoutSEOEntry::setUserName);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<LayoutSEOEntry, Date>)LayoutSEOEntry::setCreateDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<LayoutSEOEntry, Date>)LayoutSEOEntry::setModifiedDate);
		attributeSetterBiConsumers.put(
			"privateLayout",
			(BiConsumer<LayoutSEOEntry, Boolean>)
				LayoutSEOEntry::setPrivateLayout);
		attributeSetterBiConsumers.put(
			"layoutId",
			(BiConsumer<LayoutSEOEntry, Long>)LayoutSEOEntry::setLayoutId);
		attributeSetterBiConsumers.put(
			"canonicalURL",
			(BiConsumer<LayoutSEOEntry, String>)
				LayoutSEOEntry::setCanonicalURL);
		attributeSetterBiConsumers.put(
			"canonicalURLEnabled",
			(BiConsumer<LayoutSEOEntry, Boolean>)
				LayoutSEOEntry::setCanonicalURLEnabled);
		attributeSetterBiConsumers.put(
			"DDMStorageId",
			(BiConsumer<LayoutSEOEntry, Long>)LayoutSEOEntry::setDDMStorageId);
		attributeSetterBiConsumers.put(
			"openGraphDescription",
			(BiConsumer<LayoutSEOEntry, String>)
				LayoutSEOEntry::setOpenGraphDescription);
		attributeSetterBiConsumers.put(
			"openGraphDescriptionEnabled",
			(BiConsumer<LayoutSEOEntry, Boolean>)
				LayoutSEOEntry::setOpenGraphDescriptionEnabled);
		attributeSetterBiConsumers.put(
			"openGraphImageAlt",
			(BiConsumer<LayoutSEOEntry, String>)
				LayoutSEOEntry::setOpenGraphImageAlt);
		attributeSetterBiConsumers.put(
			"openGraphImageFileEntryId",
			(BiConsumer<LayoutSEOEntry, Long>)
				LayoutSEOEntry::setOpenGraphImageFileEntryId);
		attributeSetterBiConsumers.put(
			"openGraphTitle",
			(BiConsumer<LayoutSEOEntry, String>)
				LayoutSEOEntry::setOpenGraphTitle);
		attributeSetterBiConsumers.put(
			"openGraphTitleEnabled",
			(BiConsumer<LayoutSEOEntry, Boolean>)
				LayoutSEOEntry::setOpenGraphTitleEnabled);
		attributeSetterBiConsumers.put(
			"lastPublishDate",
			(BiConsumer<LayoutSEOEntry, Date>)
				LayoutSEOEntry::setLastPublishDate);

		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public long getLayoutSEOEntryId() {
		return _layoutSEOEntryId;
	}

	@Override
	public void setLayoutSEOEntryId(long layoutSEOEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_layoutSEOEntryId = layoutSEOEntryId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public boolean getPrivateLayout() {
		return _privateLayout;
	}

	@JSON
	@Override
	public boolean isPrivateLayout() {
		return _privateLayout;
	}

	@Override
	public void setPrivateLayout(boolean privateLayout) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_privateLayout = privateLayout;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalPrivateLayout() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("privateLayout"));
	}

	@JSON
	@Override
	public long getLayoutId() {
		return _layoutId;
	}

	@Override
	public void setLayoutId(long layoutId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_layoutId = layoutId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalLayoutId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("layoutId"));
	}

	@JSON
	@Override
	public String getCanonicalURL() {
		if (_canonicalURL == null) {
			return "";
		}
		else {
			return _canonicalURL;
		}
	}

	@Override
	public String getCanonicalURL(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getCanonicalURL(languageId);
	}

	@Override
	public String getCanonicalURL(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getCanonicalURL(languageId, useDefault);
	}

	@Override
	public String getCanonicalURL(String languageId) {
		return LocalizationUtil.getLocalization(getCanonicalURL(), languageId);
	}

	@Override
	public String getCanonicalURL(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getCanonicalURL(), languageId, useDefault);
	}

	@Override
	public String getCanonicalURLCurrentLanguageId() {
		return _canonicalURLCurrentLanguageId;
	}

	@JSON
	@Override
	public String getCanonicalURLCurrentValue() {
		Locale locale = getLocale(_canonicalURLCurrentLanguageId);

		return getCanonicalURL(locale);
	}

	@Override
	public Map<Locale, String> getCanonicalURLMap() {
		return LocalizationUtil.getLocalizationMap(getCanonicalURL());
	}

	@Override
	public void setCanonicalURL(String canonicalURL) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_canonicalURL = canonicalURL;
	}

	@Override
	public void setCanonicalURL(String canonicalURL, Locale locale) {
		setCanonicalURL(canonicalURL, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setCanonicalURL(
		String canonicalURL, Locale locale, Locale defaultLocale) {

		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(canonicalURL)) {
			setCanonicalURL(
				LocalizationUtil.updateLocalization(
					getCanonicalURL(), "CanonicalURL", canonicalURL, languageId,
					defaultLanguageId));
		}
		else {
			setCanonicalURL(
				LocalizationUtil.removeLocalization(
					getCanonicalURL(), "CanonicalURL", languageId));
		}
	}

	@Override
	public void setCanonicalURLCurrentLanguageId(String languageId) {
		_canonicalURLCurrentLanguageId = languageId;
	}

	@Override
	public void setCanonicalURLMap(Map<Locale, String> canonicalURLMap) {
		setCanonicalURLMap(canonicalURLMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setCanonicalURLMap(
		Map<Locale, String> canonicalURLMap, Locale defaultLocale) {

		if (canonicalURLMap == null) {
			return;
		}

		setCanonicalURL(
			LocalizationUtil.updateLocalization(
				canonicalURLMap, getCanonicalURL(), "CanonicalURL",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public boolean getCanonicalURLEnabled() {
		return _canonicalURLEnabled;
	}

	@JSON
	@Override
	public boolean isCanonicalURLEnabled() {
		return _canonicalURLEnabled;
	}

	@Override
	public void setCanonicalURLEnabled(boolean canonicalURLEnabled) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_canonicalURLEnabled = canonicalURLEnabled;
	}

	@JSON
	@Override
	public long getDDMStorageId() {
		return _DDMStorageId;
	}

	@Override
	public void setDDMStorageId(long DDMStorageId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_DDMStorageId = DDMStorageId;
	}

	@JSON
	@Override
	public String getOpenGraphDescription() {
		if (_openGraphDescription == null) {
			return "";
		}
		else {
			return _openGraphDescription;
		}
	}

	@Override
	public String getOpenGraphDescription(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getOpenGraphDescription(languageId);
	}

	@Override
	public String getOpenGraphDescription(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getOpenGraphDescription(languageId, useDefault);
	}

	@Override
	public String getOpenGraphDescription(String languageId) {
		return LocalizationUtil.getLocalization(
			getOpenGraphDescription(), languageId);
	}

	@Override
	public String getOpenGraphDescription(
		String languageId, boolean useDefault) {

		return LocalizationUtil.getLocalization(
			getOpenGraphDescription(), languageId, useDefault);
	}

	@Override
	public String getOpenGraphDescriptionCurrentLanguageId() {
		return _openGraphDescriptionCurrentLanguageId;
	}

	@JSON
	@Override
	public String getOpenGraphDescriptionCurrentValue() {
		Locale locale = getLocale(_openGraphDescriptionCurrentLanguageId);

		return getOpenGraphDescription(locale);
	}

	@Override
	public Map<Locale, String> getOpenGraphDescriptionMap() {
		return LocalizationUtil.getLocalizationMap(getOpenGraphDescription());
	}

	@Override
	public void setOpenGraphDescription(String openGraphDescription) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_openGraphDescription = openGraphDescription;
	}

	@Override
	public void setOpenGraphDescription(
		String openGraphDescription, Locale locale) {

		setOpenGraphDescription(
			openGraphDescription, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setOpenGraphDescription(
		String openGraphDescription, Locale locale, Locale defaultLocale) {

		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(openGraphDescription)) {
			setOpenGraphDescription(
				LocalizationUtil.updateLocalization(
					getOpenGraphDescription(), "OpenGraphDescription",
					openGraphDescription, languageId, defaultLanguageId));
		}
		else {
			setOpenGraphDescription(
				LocalizationUtil.removeLocalization(
					getOpenGraphDescription(), "OpenGraphDescription",
					languageId));
		}
	}

	@Override
	public void setOpenGraphDescriptionCurrentLanguageId(String languageId) {
		_openGraphDescriptionCurrentLanguageId = languageId;
	}

	@Override
	public void setOpenGraphDescriptionMap(
		Map<Locale, String> openGraphDescriptionMap) {

		setOpenGraphDescriptionMap(
			openGraphDescriptionMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setOpenGraphDescriptionMap(
		Map<Locale, String> openGraphDescriptionMap, Locale defaultLocale) {

		if (openGraphDescriptionMap == null) {
			return;
		}

		setOpenGraphDescription(
			LocalizationUtil.updateLocalization(
				openGraphDescriptionMap, getOpenGraphDescription(),
				"OpenGraphDescription",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public boolean getOpenGraphDescriptionEnabled() {
		return _openGraphDescriptionEnabled;
	}

	@JSON
	@Override
	public boolean isOpenGraphDescriptionEnabled() {
		return _openGraphDescriptionEnabled;
	}

	@Override
	public void setOpenGraphDescriptionEnabled(
		boolean openGraphDescriptionEnabled) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_openGraphDescriptionEnabled = openGraphDescriptionEnabled;
	}

	@JSON
	@Override
	public String getOpenGraphImageAlt() {
		if (_openGraphImageAlt == null) {
			return "";
		}
		else {
			return _openGraphImageAlt;
		}
	}

	@Override
	public String getOpenGraphImageAlt(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getOpenGraphImageAlt(languageId);
	}

	@Override
	public String getOpenGraphImageAlt(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getOpenGraphImageAlt(languageId, useDefault);
	}

	@Override
	public String getOpenGraphImageAlt(String languageId) {
		return LocalizationUtil.getLocalization(
			getOpenGraphImageAlt(), languageId);
	}

	@Override
	public String getOpenGraphImageAlt(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getOpenGraphImageAlt(), languageId, useDefault);
	}

	@Override
	public String getOpenGraphImageAltCurrentLanguageId() {
		return _openGraphImageAltCurrentLanguageId;
	}

	@JSON
	@Override
	public String getOpenGraphImageAltCurrentValue() {
		Locale locale = getLocale(_openGraphImageAltCurrentLanguageId);

		return getOpenGraphImageAlt(locale);
	}

	@Override
	public Map<Locale, String> getOpenGraphImageAltMap() {
		return LocalizationUtil.getLocalizationMap(getOpenGraphImageAlt());
	}

	@Override
	public void setOpenGraphImageAlt(String openGraphImageAlt) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_openGraphImageAlt = openGraphImageAlt;
	}

	@Override
	public void setOpenGraphImageAlt(String openGraphImageAlt, Locale locale) {
		setOpenGraphImageAlt(
			openGraphImageAlt, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setOpenGraphImageAlt(
		String openGraphImageAlt, Locale locale, Locale defaultLocale) {

		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(openGraphImageAlt)) {
			setOpenGraphImageAlt(
				LocalizationUtil.updateLocalization(
					getOpenGraphImageAlt(), "OpenGraphImageAlt",
					openGraphImageAlt, languageId, defaultLanguageId));
		}
		else {
			setOpenGraphImageAlt(
				LocalizationUtil.removeLocalization(
					getOpenGraphImageAlt(), "OpenGraphImageAlt", languageId));
		}
	}

	@Override
	public void setOpenGraphImageAltCurrentLanguageId(String languageId) {
		_openGraphImageAltCurrentLanguageId = languageId;
	}

	@Override
	public void setOpenGraphImageAltMap(
		Map<Locale, String> openGraphImageAltMap) {

		setOpenGraphImageAltMap(
			openGraphImageAltMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setOpenGraphImageAltMap(
		Map<Locale, String> openGraphImageAltMap, Locale defaultLocale) {

		if (openGraphImageAltMap == null) {
			return;
		}

		setOpenGraphImageAlt(
			LocalizationUtil.updateLocalization(
				openGraphImageAltMap, getOpenGraphImageAlt(),
				"OpenGraphImageAlt", LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public long getOpenGraphImageFileEntryId() {
		return _openGraphImageFileEntryId;
	}

	@Override
	public void setOpenGraphImageFileEntryId(long openGraphImageFileEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_openGraphImageFileEntryId = openGraphImageFileEntryId;
	}

	@JSON
	@Override
	public String getOpenGraphTitle() {
		if (_openGraphTitle == null) {
			return "";
		}
		else {
			return _openGraphTitle;
		}
	}

	@Override
	public String getOpenGraphTitle(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getOpenGraphTitle(languageId);
	}

	@Override
	public String getOpenGraphTitle(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getOpenGraphTitle(languageId, useDefault);
	}

	@Override
	public String getOpenGraphTitle(String languageId) {
		return LocalizationUtil.getLocalization(
			getOpenGraphTitle(), languageId);
	}

	@Override
	public String getOpenGraphTitle(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getOpenGraphTitle(), languageId, useDefault);
	}

	@Override
	public String getOpenGraphTitleCurrentLanguageId() {
		return _openGraphTitleCurrentLanguageId;
	}

	@JSON
	@Override
	public String getOpenGraphTitleCurrentValue() {
		Locale locale = getLocale(_openGraphTitleCurrentLanguageId);

		return getOpenGraphTitle(locale);
	}

	@Override
	public Map<Locale, String> getOpenGraphTitleMap() {
		return LocalizationUtil.getLocalizationMap(getOpenGraphTitle());
	}

	@Override
	public void setOpenGraphTitle(String openGraphTitle) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_openGraphTitle = openGraphTitle;
	}

	@Override
	public void setOpenGraphTitle(String openGraphTitle, Locale locale) {
		setOpenGraphTitle(openGraphTitle, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setOpenGraphTitle(
		String openGraphTitle, Locale locale, Locale defaultLocale) {

		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(openGraphTitle)) {
			setOpenGraphTitle(
				LocalizationUtil.updateLocalization(
					getOpenGraphTitle(), "OpenGraphTitle", openGraphTitle,
					languageId, defaultLanguageId));
		}
		else {
			setOpenGraphTitle(
				LocalizationUtil.removeLocalization(
					getOpenGraphTitle(), "OpenGraphTitle", languageId));
		}
	}

	@Override
	public void setOpenGraphTitleCurrentLanguageId(String languageId) {
		_openGraphTitleCurrentLanguageId = languageId;
	}

	@Override
	public void setOpenGraphTitleMap(Map<Locale, String> openGraphTitleMap) {
		setOpenGraphTitleMap(openGraphTitleMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setOpenGraphTitleMap(
		Map<Locale, String> openGraphTitleMap, Locale defaultLocale) {

		if (openGraphTitleMap == null) {
			return;
		}

		setOpenGraphTitle(
			LocalizationUtil.updateLocalization(
				openGraphTitleMap, getOpenGraphTitle(), "OpenGraphTitle",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public boolean getOpenGraphTitleEnabled() {
		return _openGraphTitleEnabled;
	}

	@JSON
	@Override
	public boolean isOpenGraphTitleEnabled() {
		return _openGraphTitleEnabled;
	}

	@Override
	public void setOpenGraphTitleEnabled(boolean openGraphTitleEnabled) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_openGraphTitleEnabled = openGraphTitleEnabled;
	}

	@JSON
	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPublishDate = lastPublishDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(LayoutSEOEntry.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), LayoutSEOEntry.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public String[] getAvailableLanguageIds() {
		Set<String> availableLanguageIds = new TreeSet<String>();

		Map<Locale, String> canonicalURLMap = getCanonicalURLMap();

		for (Map.Entry<Locale, String> entry : canonicalURLMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> openGraphDescriptionMap =
			getOpenGraphDescriptionMap();

		for (Map.Entry<Locale, String> entry :
				openGraphDescriptionMap.entrySet()) {

			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> openGraphImageAltMap = getOpenGraphImageAltMap();

		for (Map.Entry<Locale, String> entry :
				openGraphImageAltMap.entrySet()) {

			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> openGraphTitleMap = getOpenGraphTitleMap();

		for (Map.Entry<Locale, String> entry : openGraphTitleMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		return availableLanguageIds.toArray(
			new String[availableLanguageIds.size()]);
	}

	@Override
	public String getDefaultLanguageId() {
		String xml = getCanonicalURL();

		if (xml == null) {
			return "";
		}

		Locale defaultLocale = LocaleUtil.getSiteDefault();

		return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
	}

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException {
		Locale defaultLocale = LocaleUtil.fromLanguageId(
			getDefaultLanguageId());

		Locale[] availableLocales = LocaleUtil.fromLanguageIds(
			getAvailableLanguageIds());

		Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(
			LayoutSEOEntry.class.getName(), getPrimaryKey(), defaultLocale,
			availableLocales);

		prepareLocalizedFieldsForImport(defaultImportLocale);
	}

	@Override
	@SuppressWarnings("unused")
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException {

		Locale defaultLocale = LocaleUtil.getSiteDefault();

		String modelDefaultLanguageId = getDefaultLanguageId();

		String canonicalURL = getCanonicalURL(defaultLocale);

		if (Validator.isNull(canonicalURL)) {
			setCanonicalURL(
				getCanonicalURL(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setCanonicalURL(
				getCanonicalURL(defaultLocale), defaultLocale, defaultLocale);
		}

		String openGraphDescription = getOpenGraphDescription(defaultLocale);

		if (Validator.isNull(openGraphDescription)) {
			setOpenGraphDescription(
				getOpenGraphDescription(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setOpenGraphDescription(
				getOpenGraphDescription(defaultLocale), defaultLocale,
				defaultLocale);
		}

		String openGraphImageAlt = getOpenGraphImageAlt(defaultLocale);

		if (Validator.isNull(openGraphImageAlt)) {
			setOpenGraphImageAlt(
				getOpenGraphImageAlt(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setOpenGraphImageAlt(
				getOpenGraphImageAlt(defaultLocale), defaultLocale,
				defaultLocale);
		}

		String openGraphTitle = getOpenGraphTitle(defaultLocale);

		if (Validator.isNull(openGraphTitle)) {
			setOpenGraphTitle(
				getOpenGraphTitle(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setOpenGraphTitle(
				getOpenGraphTitle(defaultLocale), defaultLocale, defaultLocale);
		}
	}

	@Override
	public LayoutSEOEntry toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, LayoutSEOEntry>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		LayoutSEOEntryImpl layoutSEOEntryImpl = new LayoutSEOEntryImpl();

		layoutSEOEntryImpl.setMvccVersion(getMvccVersion());
		layoutSEOEntryImpl.setCtCollectionId(getCtCollectionId());
		layoutSEOEntryImpl.setUuid(getUuid());
		layoutSEOEntryImpl.setLayoutSEOEntryId(getLayoutSEOEntryId());
		layoutSEOEntryImpl.setGroupId(getGroupId());
		layoutSEOEntryImpl.setCompanyId(getCompanyId());
		layoutSEOEntryImpl.setUserId(getUserId());
		layoutSEOEntryImpl.setUserName(getUserName());
		layoutSEOEntryImpl.setCreateDate(getCreateDate());
		layoutSEOEntryImpl.setModifiedDate(getModifiedDate());
		layoutSEOEntryImpl.setPrivateLayout(isPrivateLayout());
		layoutSEOEntryImpl.setLayoutId(getLayoutId());
		layoutSEOEntryImpl.setCanonicalURL(getCanonicalURL());
		layoutSEOEntryImpl.setCanonicalURLEnabled(isCanonicalURLEnabled());
		layoutSEOEntryImpl.setDDMStorageId(getDDMStorageId());
		layoutSEOEntryImpl.setOpenGraphDescription(getOpenGraphDescription());
		layoutSEOEntryImpl.setOpenGraphDescriptionEnabled(
			isOpenGraphDescriptionEnabled());
		layoutSEOEntryImpl.setOpenGraphImageAlt(getOpenGraphImageAlt());
		layoutSEOEntryImpl.setOpenGraphImageFileEntryId(
			getOpenGraphImageFileEntryId());
		layoutSEOEntryImpl.setOpenGraphTitle(getOpenGraphTitle());
		layoutSEOEntryImpl.setOpenGraphTitleEnabled(isOpenGraphTitleEnabled());
		layoutSEOEntryImpl.setLastPublishDate(getLastPublishDate());

		layoutSEOEntryImpl.resetOriginalValues();

		return layoutSEOEntryImpl;
	}

	@Override
	public int compareTo(LayoutSEOEntry layoutSEOEntry) {
		long primaryKey = layoutSEOEntry.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof LayoutSEOEntry)) {
			return false;
		}

		LayoutSEOEntry layoutSEOEntry = (LayoutSEOEntry)object;

		long primaryKey = layoutSEOEntry.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<LayoutSEOEntry> toCacheModel() {
		LayoutSEOEntryCacheModel layoutSEOEntryCacheModel =
			new LayoutSEOEntryCacheModel();

		layoutSEOEntryCacheModel.mvccVersion = getMvccVersion();

		layoutSEOEntryCacheModel.ctCollectionId = getCtCollectionId();

		layoutSEOEntryCacheModel.uuid = getUuid();

		String uuid = layoutSEOEntryCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			layoutSEOEntryCacheModel.uuid = null;
		}

		layoutSEOEntryCacheModel.layoutSEOEntryId = getLayoutSEOEntryId();

		layoutSEOEntryCacheModel.groupId = getGroupId();

		layoutSEOEntryCacheModel.companyId = getCompanyId();

		layoutSEOEntryCacheModel.userId = getUserId();

		layoutSEOEntryCacheModel.userName = getUserName();

		String userName = layoutSEOEntryCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			layoutSEOEntryCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			layoutSEOEntryCacheModel.createDate = createDate.getTime();
		}
		else {
			layoutSEOEntryCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			layoutSEOEntryCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			layoutSEOEntryCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		layoutSEOEntryCacheModel.privateLayout = isPrivateLayout();

		layoutSEOEntryCacheModel.layoutId = getLayoutId();

		layoutSEOEntryCacheModel.canonicalURL = getCanonicalURL();

		String canonicalURL = layoutSEOEntryCacheModel.canonicalURL;

		if ((canonicalURL != null) && (canonicalURL.length() == 0)) {
			layoutSEOEntryCacheModel.canonicalURL = null;
		}

		layoutSEOEntryCacheModel.canonicalURLEnabled = isCanonicalURLEnabled();

		layoutSEOEntryCacheModel.DDMStorageId = getDDMStorageId();

		layoutSEOEntryCacheModel.openGraphDescription =
			getOpenGraphDescription();

		String openGraphDescription =
			layoutSEOEntryCacheModel.openGraphDescription;

		if ((openGraphDescription != null) &&
			(openGraphDescription.length() == 0)) {

			layoutSEOEntryCacheModel.openGraphDescription = null;
		}

		layoutSEOEntryCacheModel.openGraphDescriptionEnabled =
			isOpenGraphDescriptionEnabled();

		layoutSEOEntryCacheModel.openGraphImageAlt = getOpenGraphImageAlt();

		String openGraphImageAlt = layoutSEOEntryCacheModel.openGraphImageAlt;

		if ((openGraphImageAlt != null) && (openGraphImageAlt.length() == 0)) {
			layoutSEOEntryCacheModel.openGraphImageAlt = null;
		}

		layoutSEOEntryCacheModel.openGraphImageFileEntryId =
			getOpenGraphImageFileEntryId();

		layoutSEOEntryCacheModel.openGraphTitle = getOpenGraphTitle();

		String openGraphTitle = layoutSEOEntryCacheModel.openGraphTitle;

		if ((openGraphTitle != null) && (openGraphTitle.length() == 0)) {
			layoutSEOEntryCacheModel.openGraphTitle = null;
		}

		layoutSEOEntryCacheModel.openGraphTitleEnabled =
			isOpenGraphTitleEnabled();

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			layoutSEOEntryCacheModel.lastPublishDate =
				lastPublishDate.getTime();
		}
		else {
			layoutSEOEntryCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		return layoutSEOEntryCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<LayoutSEOEntry, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<LayoutSEOEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<LayoutSEOEntry, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((LayoutSEOEntry)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<LayoutSEOEntry, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<LayoutSEOEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<LayoutSEOEntry, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((LayoutSEOEntry)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, LayoutSEOEntry>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					LayoutSEOEntry.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private String _uuid;
	private long _layoutSEOEntryId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private boolean _privateLayout;
	private long _layoutId;
	private String _canonicalURL;
	private String _canonicalURLCurrentLanguageId;
	private boolean _canonicalURLEnabled;
	private long _DDMStorageId;
	private String _openGraphDescription;
	private String _openGraphDescriptionCurrentLanguageId;
	private boolean _openGraphDescriptionEnabled;
	private String _openGraphImageAlt;
	private String _openGraphImageAltCurrentLanguageId;
	private long _openGraphImageFileEntryId;
	private String _openGraphTitle;
	private String _openGraphTitleCurrentLanguageId;
	private boolean _openGraphTitleEnabled;
	private Date _lastPublishDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<LayoutSEOEntry, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((LayoutSEOEntry)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put("layoutSEOEntryId", _layoutSEOEntryId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("privateLayout", _privateLayout);
		_columnOriginalValues.put("layoutId", _layoutId);
		_columnOriginalValues.put("canonicalURL", _canonicalURL);
		_columnOriginalValues.put("canonicalURLEnabled", _canonicalURLEnabled);
		_columnOriginalValues.put("DDMStorageId", _DDMStorageId);
		_columnOriginalValues.put(
			"openGraphDescription", _openGraphDescription);
		_columnOriginalValues.put(
			"openGraphDescriptionEnabled", _openGraphDescriptionEnabled);
		_columnOriginalValues.put("openGraphImageAlt", _openGraphImageAlt);
		_columnOriginalValues.put(
			"openGraphImageFileEntryId", _openGraphImageFileEntryId);
		_columnOriginalValues.put("openGraphTitle", _openGraphTitle);
		_columnOriginalValues.put(
			"openGraphTitleEnabled", _openGraphTitleEnabled);
		_columnOriginalValues.put("lastPublishDate", _lastPublishDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("uuid_", 4L);

		columnBitmasks.put("layoutSEOEntryId", 8L);

		columnBitmasks.put("groupId", 16L);

		columnBitmasks.put("companyId", 32L);

		columnBitmasks.put("userId", 64L);

		columnBitmasks.put("userName", 128L);

		columnBitmasks.put("createDate", 256L);

		columnBitmasks.put("modifiedDate", 512L);

		columnBitmasks.put("privateLayout", 1024L);

		columnBitmasks.put("layoutId", 2048L);

		columnBitmasks.put("canonicalURL", 4096L);

		columnBitmasks.put("canonicalURLEnabled", 8192L);

		columnBitmasks.put("DDMStorageId", 16384L);

		columnBitmasks.put("openGraphDescription", 32768L);

		columnBitmasks.put("openGraphDescriptionEnabled", 65536L);

		columnBitmasks.put("openGraphImageAlt", 131072L);

		columnBitmasks.put("openGraphImageFileEntryId", 262144L);

		columnBitmasks.put("openGraphTitle", 524288L);

		columnBitmasks.put("openGraphTitleEnabled", 1048576L);

		columnBitmasks.put("lastPublishDate", 2097152L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private LayoutSEOEntry _escapedModel;

}