/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.seo.service.persistence.impl;

import com.liferay.layout.seo.exception.NoSuchEntryException;
import com.liferay.layout.seo.model.LayoutSEOEntry;
import com.liferay.layout.seo.model.impl.LayoutSEOEntryImpl;
import com.liferay.layout.seo.model.impl.LayoutSEOEntryModelImpl;
import com.liferay.layout.seo.service.persistence.LayoutSEOEntryPersistence;
import com.liferay.layout.seo.service.persistence.LayoutSEOEntryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={LayoutSEOEntryPersistence.class})
public class LayoutSEOEntryPersistenceImpl
extends BasePersistenceImpl<LayoutSEOEntry>
implements LayoutSEOEntryPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = LayoutSEOEntryImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "layoutSEOEntry.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(layoutSEOEntry.uuid IS NULL OR layoutSEOEntry.uuid = '')";
    private FinderPath _finderPathFetchByUUID_G;
    private FinderPath _finderPathCountByUUID_G;
    private static final String _FINDER_COLUMN_UUID_G_UUID_2 = "layoutSEOEntry.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_G_UUID_3 = "(layoutSEOEntry.uuid IS NULL OR layoutSEOEntry.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_G_GROUPID_2 = "layoutSEOEntry.groupId = ?";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "layoutSEOEntry.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(layoutSEOEntry.uuid IS NULL OR layoutSEOEntry.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "layoutSEOEntry.companyId = ?";
    private FinderPath _finderPathFetchByG_P_L;
    private FinderPath _finderPathCountByG_P_L;
    private static final String _FINDER_COLUMN_G_P_L_GROUPID_2 = "layoutSEOEntry.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_P_L_PRIVATELAYOUT_2 = "layoutSEOEntry.privateLayout = ? AND ";
    private static final String _FINDER_COLUMN_G_P_L_LAYOUTID_2 = "layoutSEOEntry.layoutId = ?";
    private int _valueObjectFinderCacheListThreshold;
    private boolean _columnBitmaskEnabled;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_LAYOUTSEOENTRY = "SELECT layoutSEOEntry FROM LayoutSEOEntry layoutSEOEntry";
    private static final String _SQL_SELECT_LAYOUTSEOENTRY_WHERE = "SELECT layoutSEOEntry FROM LayoutSEOEntry layoutSEOEntry WHERE ";
    private static final String _SQL_COUNT_LAYOUTSEOENTRY = "SELECT COUNT(layoutSEOEntry) FROM LayoutSEOEntry layoutSEOEntry";
    private static final String _SQL_COUNT_LAYOUTSEOENTRY_WHERE = "SELECT COUNT(layoutSEOEntry) FROM LayoutSEOEntry layoutSEOEntry WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "layoutSEOEntry.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No LayoutSEOEntry exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No LayoutSEOEntry exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(LayoutSEOEntryPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid"});

    public List<LayoutSEOEntry> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<LayoutSEOEntry> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<LayoutSEOEntry> findByUuid(String uuid, int start, int end, OrderByComparator<LayoutSEOEntry> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<LayoutSEOEntry> findByUuid(String uuid, int start, int end, OrderByComparator<LayoutSEOEntry> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid;
                finderArgs = new Object[]{uuid};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (LayoutSEOEntry layoutSEOEntry : list) {
                if (uuid.equals(layoutSEOEntry.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_LAYOUTSEOENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY layoutSEOEntry.layoutSEOEntryId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public LayoutSEOEntry findByUuid_First(String uuid, OrderByComparator<LayoutSEOEntry> orderByComparator) throws NoSuchEntryException {
        LayoutSEOEntry layoutSEOEntry = this.fetchByUuid_First(uuid, orderByComparator);
        if (layoutSEOEntry != null) {
            return layoutSEOEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchEntryException(sb.toString());
    }

    public LayoutSEOEntry fetchByUuid_First(String uuid, OrderByComparator<LayoutSEOEntry> orderByComparator) {
        List<LayoutSEOEntry> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public LayoutSEOEntry findByUuid_Last(String uuid, OrderByComparator<LayoutSEOEntry> orderByComparator) throws NoSuchEntryException {
        LayoutSEOEntry layoutSEOEntry = this.fetchByUuid_Last(uuid, orderByComparator);
        if (layoutSEOEntry != null) {
            return layoutSEOEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchEntryException(sb.toString());
    }

    public LayoutSEOEntry fetchByUuid_Last(String uuid, OrderByComparator<LayoutSEOEntry> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<LayoutSEOEntry> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public LayoutSEOEntry[] findByUuid_PrevAndNext(long layoutSEOEntryId, String uuid, OrderByComparator<LayoutSEOEntry> orderByComparator) throws NoSuchEntryException {
        uuid = Objects.toString(uuid, "");
        LayoutSEOEntry layoutSEOEntry = this.findByPrimaryKey(layoutSEOEntryId);
        Session session = null;
        try {
            session = this.openSession();
            LayoutSEOEntry[] array = new LayoutSEOEntryImpl[]{this.getByUuid_PrevAndNext(session, layoutSEOEntry, uuid, orderByComparator, true), layoutSEOEntry, this.getByUuid_PrevAndNext(session, layoutSEOEntry, uuid, orderByComparator, false)};
            LayoutSEOEntry[] layoutSEOEntryArray = array;
            return layoutSEOEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected LayoutSEOEntry getByUuid_PrevAndNext(Session session, LayoutSEOEntry layoutSEOEntry, String uuid, OrderByComparator<LayoutSEOEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_LAYOUTSEOENTRY_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY layoutSEOEntry.layoutSEOEntryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)layoutSEOEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (LayoutSEOEntry)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (LayoutSEOEntry layoutSEOEntry : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)layoutSEOEntry);
        }
    }

    public int countByUuid(String uuid) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_LAYOUTSEOENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public LayoutSEOEntry findByUUID_G(String uuid, long groupId) throws NoSuchEntryException {
        LayoutSEOEntry layoutSEOEntry = this.fetchByUUID_G(uuid, groupId);
        if (layoutSEOEntry == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("uuid=");
            sb.append(uuid);
            sb.append(", groupId=");
            sb.append(groupId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchEntryException(sb.toString());
        }
        return layoutSEOEntry;
    }

    public LayoutSEOEntry fetchByUUID_G(String uuid, long groupId) {
        return this.fetchByUUID_G(uuid, groupId, true);
    }

    public LayoutSEOEntry fetchByUUID_G(String uuid, long groupId, boolean useFinderCache) {
        LayoutSEOEntry layoutSEOEntry;
        uuid = Objects.toString(uuid, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{uuid, groupId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByUUID_G, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof LayoutSEOEntry && (!Objects.equals(uuid, (layoutSEOEntry = (LayoutSEOEntry)result).getUuid()) || groupId != layoutSEOEntry.getGroupId())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_LAYOUTSEOENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(layoutSEOEntry.uuid IS NULL OR layoutSEOEntry.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("layoutSEOEntry.uuid = ? AND ");
            }
            sb.append(_FINDER_COLUMN_UUID_G_GROUPID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(groupId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByUUID_G, finderArgs, (Object)list);
                    }
                } else {
                    LayoutSEOEntry layoutSEOEntry2 = (LayoutSEOEntry)list.get(0);
                    result = layoutSEOEntry2;
                    this.cacheResult(layoutSEOEntry2);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(this._finderPathFetchByUUID_G, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (LayoutSEOEntry)result;
    }

    public LayoutSEOEntry removeByUUID_G(String uuid, long groupId) throws NoSuchEntryException {
        LayoutSEOEntry layoutSEOEntry = this.findByUUID_G(uuid, groupId);
        return (LayoutSEOEntry)this.remove((BaseModel)layoutSEOEntry);
    }

    public int countByUUID_G(String uuid, long groupId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUUID_G;
        Object[] finderArgs = new Object[]{uuid, groupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_LAYOUTSEOENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(layoutSEOEntry.uuid IS NULL OR layoutSEOEntry.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("layoutSEOEntry.uuid = ? AND ");
            }
            sb.append(_FINDER_COLUMN_UUID_G_GROUPID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(groupId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<LayoutSEOEntry> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<LayoutSEOEntry> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<LayoutSEOEntry> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<LayoutSEOEntry> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<LayoutSEOEntry> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<LayoutSEOEntry> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid_C;
                finderArgs = new Object[]{uuid, companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (LayoutSEOEntry layoutSEOEntry : list) {
                if (uuid.equals(layoutSEOEntry.getUuid()) && companyId == layoutSEOEntry.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_LAYOUTSEOENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(layoutSEOEntry.uuid IS NULL OR layoutSEOEntry.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("layoutSEOEntry.uuid = ? AND ");
            }
            sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY layoutSEOEntry.layoutSEOEntryId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public LayoutSEOEntry findByUuid_C_First(String uuid, long companyId, OrderByComparator<LayoutSEOEntry> orderByComparator) throws NoSuchEntryException {
        LayoutSEOEntry layoutSEOEntry = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (layoutSEOEntry != null) {
            return layoutSEOEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchEntryException(sb.toString());
    }

    public LayoutSEOEntry fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<LayoutSEOEntry> orderByComparator) {
        List<LayoutSEOEntry> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public LayoutSEOEntry findByUuid_C_Last(String uuid, long companyId, OrderByComparator<LayoutSEOEntry> orderByComparator) throws NoSuchEntryException {
        LayoutSEOEntry layoutSEOEntry = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (layoutSEOEntry != null) {
            return layoutSEOEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchEntryException(sb.toString());
    }

    public LayoutSEOEntry fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<LayoutSEOEntry> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<LayoutSEOEntry> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public LayoutSEOEntry[] findByUuid_C_PrevAndNext(long layoutSEOEntryId, String uuid, long companyId, OrderByComparator<LayoutSEOEntry> orderByComparator) throws NoSuchEntryException {
        uuid = Objects.toString(uuid, "");
        LayoutSEOEntry layoutSEOEntry = this.findByPrimaryKey(layoutSEOEntryId);
        Session session = null;
        try {
            session = this.openSession();
            LayoutSEOEntry[] array = new LayoutSEOEntryImpl[]{this.getByUuid_C_PrevAndNext(session, layoutSEOEntry, uuid, companyId, orderByComparator, true), layoutSEOEntry, this.getByUuid_C_PrevAndNext(session, layoutSEOEntry, uuid, companyId, orderByComparator, false)};
            LayoutSEOEntry[] layoutSEOEntryArray = array;
            return layoutSEOEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected LayoutSEOEntry getByUuid_C_PrevAndNext(Session session, LayoutSEOEntry layoutSEOEntry, String uuid, long companyId, OrderByComparator<LayoutSEOEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_LAYOUTSEOENTRY_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append("(layoutSEOEntry.uuid IS NULL OR layoutSEOEntry.uuid = '') AND ");
        } else {
            bindUuid = true;
            sb.append("layoutSEOEntry.uuid = ? AND ");
        }
        sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY layoutSEOEntry.layoutSEOEntryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)layoutSEOEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (LayoutSEOEntry)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (LayoutSEOEntry layoutSEOEntry : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)layoutSEOEntry);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_LAYOUTSEOENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(layoutSEOEntry.uuid IS NULL OR layoutSEOEntry.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("layoutSEOEntry.uuid = ? AND ");
            }
            sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public LayoutSEOEntry findByG_P_L(long groupId, boolean privateLayout, long layoutId) throws NoSuchEntryException {
        LayoutSEOEntry layoutSEOEntry = this.fetchByG_P_L(groupId, privateLayout, layoutId);
        if (layoutSEOEntry == null) {
            StringBundler sb = new StringBundler(8);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("groupId=");
            sb.append(groupId);
            sb.append(", privateLayout=");
            sb.append(privateLayout);
            sb.append(", layoutId=");
            sb.append(layoutId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchEntryException(sb.toString());
        }
        return layoutSEOEntry;
    }

    public LayoutSEOEntry fetchByG_P_L(long groupId, boolean privateLayout, long layoutId) {
        return this.fetchByG_P_L(groupId, privateLayout, layoutId, true);
    }

    public LayoutSEOEntry fetchByG_P_L(long groupId, boolean privateLayout, long layoutId, boolean useFinderCache) {
        LayoutSEOEntry layoutSEOEntry;
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{groupId, privateLayout, layoutId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByG_P_L, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof LayoutSEOEntry && (groupId != (layoutSEOEntry = (LayoutSEOEntry)result).getGroupId() || privateLayout != layoutSEOEntry.isPrivateLayout() || layoutId != layoutSEOEntry.getLayoutId())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(5);
            sb.append(_SQL_SELECT_LAYOUTSEOENTRY_WHERE);
            sb.append(_FINDER_COLUMN_G_P_L_GROUPID_2);
            sb.append(_FINDER_COLUMN_G_P_L_PRIVATELAYOUT_2);
            sb.append(_FINDER_COLUMN_G_P_L_LAYOUTID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(privateLayout);
                queryPos.add(layoutId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByG_P_L, finderArgs, (Object)list);
                    }
                } else {
                    LayoutSEOEntry layoutSEOEntry2 = (LayoutSEOEntry)list.get(0);
                    result = layoutSEOEntry2;
                    this.cacheResult(layoutSEOEntry2);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(this._finderPathFetchByG_P_L, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (LayoutSEOEntry)result;
    }

    public LayoutSEOEntry removeByG_P_L(long groupId, boolean privateLayout, long layoutId) throws NoSuchEntryException {
        LayoutSEOEntry layoutSEOEntry = this.findByG_P_L(groupId, privateLayout, layoutId);
        return (LayoutSEOEntry)this.remove((BaseModel)layoutSEOEntry);
    }

    public int countByG_P_L(long groupId, boolean privateLayout, long layoutId) {
        FinderPath finderPath = this._finderPathCountByG_P_L;
        Object[] finderArgs = new Object[]{groupId, privateLayout, layoutId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_COUNT_LAYOUTSEOENTRY_WHERE);
            sb.append(_FINDER_COLUMN_G_P_L_GROUPID_2);
            sb.append(_FINDER_COLUMN_G_P_L_PRIVATELAYOUT_2);
            sb.append(_FINDER_COLUMN_G_P_L_LAYOUTID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(privateLayout);
                queryPos.add(layoutId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public LayoutSEOEntryPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("uuid", "uuid_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(LayoutSEOEntry.class);
        this.setModelImplClass(LayoutSEOEntryImpl.class);
        this.setModelPKClass(Long.TYPE);
    }

    public void cacheResult(LayoutSEOEntry layoutSEOEntry) {
        this.entityCache.putResult(this.entityCacheEnabled, LayoutSEOEntryImpl.class, (Serializable)Long.valueOf(layoutSEOEntry.getPrimaryKey()), (Serializable)layoutSEOEntry);
        this.finderCache.putResult(this._finderPathFetchByUUID_G, new Object[]{layoutSEOEntry.getUuid(), layoutSEOEntry.getGroupId()}, (Object)layoutSEOEntry);
        this.finderCache.putResult(this._finderPathFetchByG_P_L, new Object[]{layoutSEOEntry.getGroupId(), layoutSEOEntry.isPrivateLayout(), layoutSEOEntry.getLayoutId()}, (Object)layoutSEOEntry);
        layoutSEOEntry.resetOriginalValues();
    }

    public void cacheResult(List<LayoutSEOEntry> layoutSEOEntries) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && layoutSEOEntries.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (LayoutSEOEntry layoutSEOEntry : layoutSEOEntries) {
            if (this.entityCache.getResult(this.entityCacheEnabled, LayoutSEOEntryImpl.class, (Serializable)Long.valueOf(layoutSEOEntry.getPrimaryKey())) == null) {
                this.cacheResult(layoutSEOEntry);
                continue;
            }
            layoutSEOEntry.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(LayoutSEOEntryImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(LayoutSEOEntry layoutSEOEntry) {
        this.entityCache.removeResult(this.entityCacheEnabled, LayoutSEOEntryImpl.class, (Serializable)Long.valueOf(layoutSEOEntry.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((LayoutSEOEntryModelImpl)layoutSEOEntry, true);
    }

    public void clearCache(List<LayoutSEOEntry> layoutSEOEntries) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (LayoutSEOEntry layoutSEOEntry : layoutSEOEntries) {
            this.entityCache.removeResult(this.entityCacheEnabled, LayoutSEOEntryImpl.class, (Serializable)Long.valueOf(layoutSEOEntry.getPrimaryKey()));
            this.clearUniqueFindersCache((LayoutSEOEntryModelImpl)layoutSEOEntry, true);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(this.entityCacheEnabled, LayoutSEOEntryImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(LayoutSEOEntryModelImpl layoutSEOEntryModelImpl) {
        Object[] args = new Object[]{layoutSEOEntryModelImpl.getUuid(), layoutSEOEntryModelImpl.getGroupId()};
        this.finderCache.putResult(this._finderPathCountByUUID_G, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByUUID_G, args, (Object)layoutSEOEntryModelImpl, false);
        args = new Object[]{layoutSEOEntryModelImpl.getGroupId(), layoutSEOEntryModelImpl.isPrivateLayout(), layoutSEOEntryModelImpl.getLayoutId()};
        this.finderCache.putResult(this._finderPathCountByG_P_L, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByG_P_L, args, (Object)layoutSEOEntryModelImpl, false);
    }

    protected void clearUniqueFindersCache(LayoutSEOEntryModelImpl layoutSEOEntryModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{layoutSEOEntryModelImpl.getUuid(), layoutSEOEntryModelImpl.getGroupId()};
            this.finderCache.removeResult(this._finderPathCountByUUID_G, args);
            this.finderCache.removeResult(this._finderPathFetchByUUID_G, args);
        }
        if ((layoutSEOEntryModelImpl.getColumnBitmask() & this._finderPathFetchByUUID_G.getColumnBitmask()) != 0L) {
            args = new Object[]{layoutSEOEntryModelImpl.getOriginalUuid(), layoutSEOEntryModelImpl.getOriginalGroupId()};
            this.finderCache.removeResult(this._finderPathCountByUUID_G, args);
            this.finderCache.removeResult(this._finderPathFetchByUUID_G, args);
        }
        if (clearCurrent) {
            args = new Object[]{layoutSEOEntryModelImpl.getGroupId(), layoutSEOEntryModelImpl.isPrivateLayout(), layoutSEOEntryModelImpl.getLayoutId()};
            this.finderCache.removeResult(this._finderPathCountByG_P_L, args);
            this.finderCache.removeResult(this._finderPathFetchByG_P_L, args);
        }
        if ((layoutSEOEntryModelImpl.getColumnBitmask() & this._finderPathFetchByG_P_L.getColumnBitmask()) != 0L) {
            args = new Object[]{layoutSEOEntryModelImpl.getOriginalGroupId(), layoutSEOEntryModelImpl.getOriginalPrivateLayout(), layoutSEOEntryModelImpl.getOriginalLayoutId()};
            this.finderCache.removeResult(this._finderPathCountByG_P_L, args);
            this.finderCache.removeResult(this._finderPathFetchByG_P_L, args);
        }
    }

    public LayoutSEOEntry create(long layoutSEOEntryId) {
        LayoutSEOEntryImpl layoutSEOEntry = new LayoutSEOEntryImpl();
        layoutSEOEntry.setNew(true);
        layoutSEOEntry.setPrimaryKey(layoutSEOEntryId);
        String uuid = PortalUUIDUtil.generate();
        layoutSEOEntry.setUuid(uuid);
        layoutSEOEntry.setCompanyId(CompanyThreadLocal.getCompanyId());
        return layoutSEOEntry;
    }

    public LayoutSEOEntry remove(long layoutSEOEntryId) throws NoSuchEntryException {
        return this.remove(Long.valueOf(layoutSEOEntryId));
    }

    public LayoutSEOEntry remove(Serializable primaryKey) throws NoSuchEntryException {
        Session session = null;
        try {
            session = this.openSession();
            LayoutSEOEntry layoutSEOEntry = (LayoutSEOEntry)session.get(LayoutSEOEntryImpl.class, primaryKey);
            if (layoutSEOEntry == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            LayoutSEOEntry layoutSEOEntry2 = (LayoutSEOEntry)this.remove((BaseModel)layoutSEOEntry);
            return layoutSEOEntry2;
        }
        catch (NoSuchEntryException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected LayoutSEOEntry removeImpl(LayoutSEOEntry layoutSEOEntry) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)layoutSEOEntry)) {
                layoutSEOEntry = (LayoutSEOEntry)session.get(LayoutSEOEntryImpl.class, layoutSEOEntry.getPrimaryKeyObj());
            }
            if (layoutSEOEntry != null) {
                session.delete((Object)layoutSEOEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (layoutSEOEntry != null) {
            this.clearCache(layoutSEOEntry);
        }
        return layoutSEOEntry;
    }

    public LayoutSEOEntry updateImpl(LayoutSEOEntry layoutSEOEntry) {
        boolean isNew = layoutSEOEntry.isNew();
        if (!(layoutSEOEntry instanceof LayoutSEOEntryModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(layoutSEOEntry.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)layoutSEOEntry);
                throw new IllegalArgumentException("Implement ModelWrapper in layoutSEOEntry proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom LayoutSEOEntry implementation " + layoutSEOEntry.getClass());
        }
        LayoutSEOEntryModelImpl layoutSEOEntryModelImpl = (LayoutSEOEntryModelImpl)layoutSEOEntry;
        if (Validator.isNull((String)layoutSEOEntry.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            layoutSEOEntry.setUuid(uuid);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && layoutSEOEntry.getCreateDate() == null) {
            if (serviceContext == null) {
                layoutSEOEntry.setCreateDate(date);
            } else {
                layoutSEOEntry.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!layoutSEOEntryModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                layoutSEOEntry.setModifiedDate(date);
            } else {
                layoutSEOEntry.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)layoutSEOEntry);
                layoutSEOEntry.setNew(false);
            } else {
                layoutSEOEntry = (LayoutSEOEntry)session.merge((Object)layoutSEOEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!this._columnBitmaskEnabled) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{layoutSEOEntryModelImpl.getUuid()};
            this.finderCache.removeResult(this._finderPathCountByUuid, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
            args = new Object[]{layoutSEOEntryModelImpl.getUuid(), layoutSEOEntryModelImpl.getCompanyId()};
            this.finderCache.removeResult(this._finderPathCountByUuid_C, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((layoutSEOEntryModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUuid.getColumnBitmask()) != 0L) {
                args = new Object[]{layoutSEOEntryModelImpl.getOriginalUuid()};
                this.finderCache.removeResult(this._finderPathCountByUuid, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
                args = new Object[]{layoutSEOEntryModelImpl.getUuid()};
                this.finderCache.removeResult(this._finderPathCountByUuid, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
            }
            if ((layoutSEOEntryModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUuid_C.getColumnBitmask()) != 0L) {
                args = new Object[]{layoutSEOEntryModelImpl.getOriginalUuid(), layoutSEOEntryModelImpl.getOriginalCompanyId()};
                this.finderCache.removeResult(this._finderPathCountByUuid_C, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
                args = new Object[]{layoutSEOEntryModelImpl.getUuid(), layoutSEOEntryModelImpl.getCompanyId()};
                this.finderCache.removeResult(this._finderPathCountByUuid_C, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
            }
        }
        this.entityCache.putResult(this.entityCacheEnabled, LayoutSEOEntryImpl.class, (Serializable)Long.valueOf(layoutSEOEntry.getPrimaryKey()), (Serializable)layoutSEOEntry, false);
        this.clearUniqueFindersCache(layoutSEOEntryModelImpl, false);
        this.cacheUniqueFindersCache(layoutSEOEntryModelImpl);
        layoutSEOEntry.resetOriginalValues();
        return layoutSEOEntry;
    }

    public LayoutSEOEntry findByPrimaryKey(Serializable primaryKey) throws NoSuchEntryException {
        LayoutSEOEntry layoutSEOEntry = (LayoutSEOEntry)this.fetchByPrimaryKey(primaryKey);
        if (layoutSEOEntry == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return layoutSEOEntry;
    }

    public LayoutSEOEntry findByPrimaryKey(long layoutSEOEntryId) throws NoSuchEntryException {
        return this.findByPrimaryKey(Long.valueOf(layoutSEOEntryId));
    }

    public LayoutSEOEntry fetchByPrimaryKey(long layoutSEOEntryId) {
        return (LayoutSEOEntry)this.fetchByPrimaryKey(Long.valueOf(layoutSEOEntryId));
    }

    public List<LayoutSEOEntry> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<LayoutSEOEntry> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<LayoutSEOEntry> findAll(int start, int end, OrderByComparator<LayoutSEOEntry> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<LayoutSEOEntry> findAll(int start, int end, OrderByComparator<LayoutSEOEntry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_LAYOUTSEOENTRY);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_LAYOUTSEOENTRY;
                sql = sql.concat(" ORDER BY layoutSEOEntry.layoutSEOEntryId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (LayoutSEOEntry layoutSEOEntry : this.findAll()) {
            this.remove((BaseModel)layoutSEOEntry);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_LAYOUTSEOENTRY);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "layoutSEOEntryId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_LAYOUTSEOENTRY;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return LayoutSEOEntryModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        LayoutSEOEntryModelImpl.setEntityCacheEnabled(this.entityCacheEnabled);
        LayoutSEOEntryModelImpl.setFinderCacheEnabled(this.finderCacheEnabled);
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, LayoutSEOEntryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, LayoutSEOEntryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByUuid = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, LayoutSEOEntryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUuid = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, LayoutSEOEntryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, 16L);
        this._finderPathCountByUuid = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()});
        this._finderPathFetchByUUID_G = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, LayoutSEOEntryImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, 18L);
        this._finderPathCountByUUID_G = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUUID_G", new String[]{String.class.getName(), Long.class.getName()});
        this._finderPathWithPaginationFindByUuid_C = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, LayoutSEOEntryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUuid_C = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, LayoutSEOEntryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, 17L);
        this._finderPathCountByUuid_C = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()});
        this._finderPathFetchByG_P_L = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, LayoutSEOEntryImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByG_P_L", new String[]{Long.class.getName(), Boolean.class.getName(), Long.class.getName()}, 14L);
        this._finderPathCountByG_P_L = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_P_L", new String[]{Long.class.getName(), Boolean.class.getName(), Long.class.getName()});
        LayoutSEOEntryUtil.setPersistence((LayoutSEOEntryPersistence)this);
    }

    @Deactivate
    public void deactivate() {
        LayoutSEOEntryUtil.setPersistence(null);
        this.entityCache.removeCache(LayoutSEOEntryImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.layout.seo.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
        super.setConfiguration(configuration);
        this._columnBitmaskEnabled = GetterUtil.getBoolean((String)configuration.get("value.object.column.bitmask.enabled.com.liferay.layout.seo.model.LayoutSEOEntry"), (boolean)true);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.layout.seo.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.layout.seo.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }
}

