/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.seo.service.impl;

import com.liferay.layout.seo.exception.NoSuchEntryException;
import com.liferay.layout.seo.model.LayoutSEOEntry;
import com.liferay.layout.seo.service.base.LayoutSEOEntryLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.DateUtil;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.layout.seo.model.LayoutSEOEntry"}, service={AopService.class})
public class LayoutSEOEntryLocalServiceImpl
extends LayoutSEOEntryLocalServiceBaseImpl {
    public void deleteLayoutSEOEntry(long groupId, boolean privateLayout, long layoutId) throws NoSuchEntryException {
        this.layoutSEOEntryPersistence.removeByG_P_L(groupId, privateLayout, layoutId);
    }

    public void deleteLayoutSEOEntry(String uuid, long groupId) throws NoSuchEntryException {
        this.layoutSEOEntryPersistence.removeByUUID_G(uuid, groupId);
    }

    public LayoutSEOEntry fetchLayoutSEOEntry(long groupId, boolean privateLayout, long layoutId) {
        return this.layoutSEOEntryPersistence.fetchByG_P_L(groupId, privateLayout, layoutId);
    }

    public LayoutSEOEntry updateLayoutSEOEntry(long userId, long groupId, boolean privateLayout, long layoutId, boolean enabled, Map<Locale, String> canonicalURLMap, ServiceContext serviceContext) throws PortalException {
        LayoutSEOEntry layoutSEOEntry = this.layoutSEOEntryPersistence.fetchByG_P_L(groupId, privateLayout, layoutId);
        if (layoutSEOEntry == null) {
            return this._addLayoutSEOEntry(userId, groupId, privateLayout, layoutId, enabled, canonicalURLMap, serviceContext);
        }
        layoutSEOEntry.setModifiedDate(DateUtil.newDate());
        layoutSEOEntry.setEnabled(enabled);
        layoutSEOEntry.setCanonicalURLMap(canonicalURLMap);
        return (LayoutSEOEntry)this.layoutSEOEntryPersistence.update((BaseModel)layoutSEOEntry);
    }

    private LayoutSEOEntry _addLayoutSEOEntry(long userId, long groupId, boolean privateLayout, long layoutId, boolean enabled, Map<Locale, String> canonicalURLMap, ServiceContext serviceContext) throws PortalException {
        LayoutSEOEntry layoutSEOEntry = this.layoutSEOEntryPersistence.create(this.counterLocalService.increment());
        layoutSEOEntry.setUuid(serviceContext.getUuid());
        layoutSEOEntry.setGroupId(groupId);
        Group group = this.groupLocalService.getGroup(groupId);
        layoutSEOEntry.setCompanyId(group.getCompanyId());
        layoutSEOEntry.setUserId(userId);
        Date now = DateUtil.newDate();
        layoutSEOEntry.setCreateDate(now);
        layoutSEOEntry.setModifiedDate(now);
        layoutSEOEntry.setPrivateLayout(privateLayout);
        layoutSEOEntry.setLayoutId(layoutId);
        layoutSEOEntry.setEnabled(enabled);
        layoutSEOEntry.setCanonicalURLMap(canonicalURLMap);
        return (LayoutSEOEntry)this.layoutSEOEntryPersistence.update((BaseModel)layoutSEOEntry);
    }
}

