/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.seo.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.layout.seo.model.LayoutSEOEntry;
import com.liferay.layout.seo.service.LayoutSEOEntryLocalService;
import com.liferay.layout.seo.service.LayoutSEOEntryLocalServiceUtil;
import com.liferay.layout.seo.service.persistence.LayoutSEOEntryPersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class LayoutSEOEntryLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
IdentifiableOSGiService,
LayoutSEOEntryLocalService {
    protected LayoutSEOEntryLocalService layoutSEOEntryLocalService;
    @Reference
    protected LayoutSEOEntryPersistence layoutSEOEntryPersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    @Reference
    protected GroupLocalService groupLocalService;
    @Reference
    protected LayoutLocalService layoutLocalService;
    private static final Log _log = LogFactoryUtil.getLog(LayoutSEOEntryLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public LayoutSEOEntry addLayoutSEOEntry(LayoutSEOEntry layoutSEOEntry) {
        layoutSEOEntry.setNew(true);
        return (LayoutSEOEntry)this.layoutSEOEntryPersistence.update((BaseModel)layoutSEOEntry);
    }

    @Transactional(enabled=false)
    public LayoutSEOEntry createLayoutSEOEntry(long layoutSEOEntryId) {
        return this.layoutSEOEntryPersistence.create(layoutSEOEntryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public LayoutSEOEntry deleteLayoutSEOEntry(long layoutSEOEntryId) throws PortalException {
        return this.layoutSEOEntryPersistence.remove(layoutSEOEntryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public LayoutSEOEntry deleteLayoutSEOEntry(LayoutSEOEntry layoutSEOEntry) {
        return (LayoutSEOEntry)this.layoutSEOEntryPersistence.remove((BaseModel)layoutSEOEntry);
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(LayoutSEOEntry.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.layoutSEOEntryPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.layoutSEOEntryPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.layoutSEOEntryPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.layoutSEOEntryPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.layoutSEOEntryPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public LayoutSEOEntry fetchLayoutSEOEntry(long layoutSEOEntryId) {
        return this.layoutSEOEntryPersistence.fetchByPrimaryKey(layoutSEOEntryId);
    }

    public LayoutSEOEntry fetchLayoutSEOEntryByUuidAndGroupId(String uuid, long groupId) {
        return this.layoutSEOEntryPersistence.fetchByUUID_G(uuid, groupId);
    }

    public LayoutSEOEntry getLayoutSEOEntry(long layoutSEOEntryId) throws PortalException {
        return this.layoutSEOEntryPersistence.findByPrimaryKey(layoutSEOEntryId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.layoutSEOEntryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(LayoutSEOEntry.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("layoutSEOEntryId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.layoutSEOEntryLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(LayoutSEOEntry.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("layoutSEOEntryId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.layoutSEOEntryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(LayoutSEOEntry.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("layoutSEOEntryId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setGroupId(portletDataContext.getScopeGroupId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<LayoutSEOEntry>(){

            public void performAction(LayoutSEOEntry layoutSEOEntry) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)layoutSEOEntry);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)LayoutSEOEntry.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return this.layoutSEOEntryLocalService.deleteLayoutSEOEntry((LayoutSEOEntry)persistedModel);
    }

    public BasePersistence<LayoutSEOEntry> getBasePersistence() {
        return this.layoutSEOEntryPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.layoutSEOEntryPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<LayoutSEOEntry> getLayoutSEOEntriesByUuidAndCompanyId(String uuid, long companyId) {
        return this.layoutSEOEntryPersistence.findByUuid_C(uuid, companyId);
    }

    public List<LayoutSEOEntry> getLayoutSEOEntriesByUuidAndCompanyId(String uuid, long companyId, int start, int end, OrderByComparator<LayoutSEOEntry> orderByComparator) {
        return this.layoutSEOEntryPersistence.findByUuid_C(uuid, companyId, start, end, orderByComparator);
    }

    public LayoutSEOEntry getLayoutSEOEntryByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        return this.layoutSEOEntryPersistence.findByUUID_G(uuid, groupId);
    }

    public List<LayoutSEOEntry> getLayoutSEOEntries(int start, int end) {
        return this.layoutSEOEntryPersistence.findAll(start, end);
    }

    public int getLayoutSEOEntriesCount() {
        return this.layoutSEOEntryPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public LayoutSEOEntry updateLayoutSEOEntry(LayoutSEOEntry layoutSEOEntry) {
        return (LayoutSEOEntry)this.layoutSEOEntryPersistence.update((BaseModel)layoutSEOEntry);
    }

    @Deactivate
    protected void deactivate() {
        LayoutSEOEntryLocalServiceUtil.setService(null);
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{LayoutSEOEntryLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.layoutSEOEntryLocalService = (LayoutSEOEntryLocalService)aopProxy;
        LayoutSEOEntryLocalServiceUtil.setService((LayoutSEOEntryLocalService)this.layoutSEOEntryLocalService);
    }

    public String getOSGiServiceIdentifier() {
        return LayoutSEOEntryLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return LayoutSEOEntry.class;
    }

    protected String getModelClassName() {
        return LayoutSEOEntry.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.layoutSEOEntryPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

