/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.seo.internal.exportimport.data.handler;

import com.liferay.exportimport.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.layout.seo.model.LayoutSEOEntry;
import com.liferay.layout.seo.service.LayoutSEOEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.StagedModel;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StagedModelDataHandler.class})
public class LayoutSEOEntryStagedModelDataHandler
extends BaseStagedModelDataHandler<LayoutSEOEntry> {
    public static final String[] CLASS_NAMES = new String[]{LayoutSEOEntry.class.getName()};
    @Reference
    private LayoutSEOEntryLocalService _layoutSEOEntryLocalService;

    public void deleteStagedModel(LayoutSEOEntry layoutSEOEntry) throws PortalException {
        this._layoutSEOEntryLocalService.deleteLayoutSEOEntry(layoutSEOEntry);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        this._layoutSEOEntryLocalService.deleteLayoutSEOEntry(uuid, groupId);
    }

    public List<LayoutSEOEntry> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return Collections.singletonList(this._layoutSEOEntryLocalService.fetchLayoutSEOEntryByUuidAndGroupId(uuid, companyId));
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, LayoutSEOEntry layoutSEOEntry) throws Exception {
        portletDataContext.addClassedModel(portletDataContext.getExportDataElement((ClassedModel)layoutSEOEntry), ExportImportPathUtil.getModelPath((StagedModel)layoutSEOEntry), (ClassedModel)layoutSEOEntry);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, LayoutSEOEntry layoutSEOEntry) throws Exception {
        LayoutSEOEntry existingLayoutSEOEntry = (LayoutSEOEntry)this.fetchStagedModelByUuidAndGroupId(layoutSEOEntry.getUuid(), layoutSEOEntry.getGroupId());
        if (existingLayoutSEOEntry == null) {
            Map newPrimaryKeysMap = portletDataContext.getNewPrimaryKeysMap(Layout.class + ".layout");
            Layout layout = (Layout)newPrimaryKeysMap.get(layoutSEOEntry.getLayoutId());
            this._layoutSEOEntryLocalService.updateLayoutSEOEntry(layoutSEOEntry.getUserId(), layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), layoutSEOEntry.isEnabled(), layoutSEOEntry.getCanonicalURLMap(), portletDataContext.createServiceContext((StagedModel)layoutSEOEntry));
        } else {
            this._layoutSEOEntryLocalService.updateLayoutSEOEntry(existingLayoutSEOEntry.getUserId(), portletDataContext.getScopeGroupId(), layoutSEOEntry.isPrivateLayout(), existingLayoutSEOEntry.getLayoutId(), layoutSEOEntry.isEnabled(), layoutSEOEntry.getCanonicalURLMap(), portletDataContext.createServiceContext((StagedModel)layoutSEOEntry));
        }
    }
}

