/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.seo.internal;

import com.liferay.layout.seo.internal.LayoutSEOLinkImpl;
import com.liferay.layout.seo.internal.configuration.LayoutSEOCompanyConfiguration;
import com.liferay.layout.seo.kernel.LayoutSEOLink;
import com.liferay.layout.seo.kernel.LayoutSEOLinkManager;
import com.liferay.layout.seo.model.LayoutSEOEntry;
import com.liferay.layout.seo.service.LayoutSEOEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.util.Html;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={LayoutSEOLinkManager.class})
public class LayoutSEOLinkManagerImpl
implements LayoutSEOLinkManager {
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Html _html;
    @Reference
    private LayoutSEOEntryLocalService _layoutSEOEntryLocalService;
    @Reference
    private Portal _portal;

    public List<LayoutSEOLink> getLocalizedLayoutSEOLinks(Layout layout, Locale locale, String canonicalURL, Map<Locale, String> alternateURLs) throws PortalException {
        ArrayList<LayoutSEOLink> layoutSEOLinks = new ArrayList<LayoutSEOLink>(alternateURLs.size() + 2);
        layoutSEOLinks.add(new LayoutSEOLinkImpl(this._html.escapeAttribute(this._getCanonicalURL(layout, locale, canonicalURL, alternateURLs)), null, LayoutSEOLink.Relationship.CANONICAL));
        alternateURLs.forEach((urlLocale, url) -> layoutSEOLinks.add(new LayoutSEOLinkImpl(this._html.escapeAttribute(url), LocaleUtil.toW3cLanguageId((Locale)urlLocale), LayoutSEOLink.Relationship.ALTERNATE)));
        String defaultLocaleURL = alternateURLs.get(this._portal.getSiteDefaultLocale(layout.getGroupId()));
        if (defaultLocaleURL == null) {
            return layoutSEOLinks;
        }
        layoutSEOLinks.add(new LayoutSEOLinkImpl(this._html.escapeAttribute(defaultLocaleURL), "x-default", LayoutSEOLink.Relationship.ALTERNATE));
        return layoutSEOLinks;
    }

    private String _getCanonicalURL(Layout layout, Locale locale, String canonicalURL, Map<Locale, String> alternateURLs) throws ConfigurationException {
        String layoutCanonicalURL = this._getLayoutCanonicalURL(locale, layout);
        if (Validator.isNotNull((String)layoutCanonicalURL)) {
            return layoutCanonicalURL;
        }
        LayoutSEOCompanyConfiguration layoutSEOCompanyConfiguration = (LayoutSEOCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(LayoutSEOCompanyConfiguration.class, layout.getCompanyId());
        if (Objects.equals(layoutSEOCompanyConfiguration.canonicalURL(), "default-language-url")) {
            return canonicalURL;
        }
        return alternateURLs.getOrDefault(locale, canonicalURL);
    }

    private String _getLayoutCanonicalURL(Locale locale, Layout layout) {
        LayoutSEOEntry layoutSEOEntry = this._layoutSEOEntryLocalService.fetchLayoutSEOEntry(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId());
        if (layoutSEOEntry == null || !layoutSEOEntry.isEnabled()) {
            return "";
        }
        return layoutSEOEntry.getCanonicalURL(locale);
    }
}

