/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.internal.upgrade.v3_2_0;

import com.liferay.layout.page.template.internal.upgrade.v3_2_0.util.LayoutPageTemplateEntryTable;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class UpgradeLayoutPageTemplateEntry
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.upgradeSchema();
        this.upgradeLayoutPageTemplateEntryKey();
    }

    protected void upgradeLayoutPageTemplateEntryKey() throws SQLException {
        try (Statement s = this.connection.createStatement();
             ResultSet rs = s.executeQuery("select layoutPageTemplateEntryId, name from LayoutPageTemplateEntry");
             PreparedStatement ps = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement("update LayoutPageTemplateEntry set layoutPageTemplateEntryKey = ? where layoutPageTemplateEntryId = ?"));){
            while (rs.next()) {
                long layoutPageTemplateEntryId = rs.getLong("layoutPageTemplateEntryId");
                String name = rs.getString("name");
                ps.setString(1, this._generateLayoutPageTemplateEntryKey(name));
                ps.setLong(2, layoutPageTemplateEntryId);
                ps.addBatch();
            }
            ps.executeBatch();
        }
    }

    protected void upgradeSchema() throws Exception {
        this.alter(LayoutPageTemplateEntryTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "layoutPageTemplateEntryKey", "VARCHAR(75)")});
    }

    private String _generateLayoutPageTemplateEntryKey(String name) {
        String layoutPageTemplateEntryKey = StringUtil.toLowerCase((String)name.trim());
        return StringUtil.replace((String)layoutPageTemplateEntryKey, (char)' ', (char)'-');
    }
}

