/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.layout.page.template.service.base;

import com.liferay.layout.page.template.model.LayoutPageTemplateCollection;
import com.liferay.layout.page.template.service.LayoutPageTemplateCollectionService;
import com.liferay.layout.page.template.service.LayoutPageTemplateCollectionServiceUtil;
import com.liferay.layout.page.template.service.persistence.LayoutPageTemplateCollectionPersistence;
import com.liferay.layout.page.template.service.persistence.LayoutPageTemplateEntryPersistence;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.service.BaseServiceImpl;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.spring.extender.service.ServiceReference;

import java.sql.Connection;

import javax.sql.DataSource;

/**
 * Provides the base implementation for the layout page template collection remote service.
 *
 * <p>
 * This implementation exists only as a container for the default service methods generated by ServiceBuilder. All custom service methods should be put in {@link com.liferay.layout.page.template.service.impl.LayoutPageTemplateCollectionServiceImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see com.liferay.layout.page.template.service.impl.LayoutPageTemplateCollectionServiceImpl
 * @generated
 */
public abstract class LayoutPageTemplateCollectionServiceBaseImpl
	extends BaseServiceImpl
	implements IdentifiableOSGiService, LayoutPageTemplateCollectionService {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. Use <code>LayoutPageTemplateCollectionService</code> via injection or a <code>org.osgi.util.tracker.ServiceTracker</code> or use <code>LayoutPageTemplateCollectionServiceUtil</code>.
	 */

	/**
	 * Returns the layout page template collection local service.
	 *
	 * @return the layout page template collection local service
	 */
	public com.liferay.layout.page.template.service.
		LayoutPageTemplateCollectionLocalService
			getLayoutPageTemplateCollectionLocalService() {

		return layoutPageTemplateCollectionLocalService;
	}

	/**
	 * Sets the layout page template collection local service.
	 *
	 * @param layoutPageTemplateCollectionLocalService the layout page template collection local service
	 */
	public void setLayoutPageTemplateCollectionLocalService(
		com.liferay.layout.page.template.service.
			LayoutPageTemplateCollectionLocalService
				layoutPageTemplateCollectionLocalService) {

		this.layoutPageTemplateCollectionLocalService =
			layoutPageTemplateCollectionLocalService;
	}

	/**
	 * Returns the layout page template collection remote service.
	 *
	 * @return the layout page template collection remote service
	 */
	public LayoutPageTemplateCollectionService
		getLayoutPageTemplateCollectionService() {

		return layoutPageTemplateCollectionService;
	}

	/**
	 * Sets the layout page template collection remote service.
	 *
	 * @param layoutPageTemplateCollectionService the layout page template collection remote service
	 */
	public void setLayoutPageTemplateCollectionService(
		LayoutPageTemplateCollectionService
			layoutPageTemplateCollectionService) {

		this.layoutPageTemplateCollectionService =
			layoutPageTemplateCollectionService;
	}

	/**
	 * Returns the layout page template collection persistence.
	 *
	 * @return the layout page template collection persistence
	 */
	public LayoutPageTemplateCollectionPersistence
		getLayoutPageTemplateCollectionPersistence() {

		return layoutPageTemplateCollectionPersistence;
	}

	/**
	 * Sets the layout page template collection persistence.
	 *
	 * @param layoutPageTemplateCollectionPersistence the layout page template collection persistence
	 */
	public void setLayoutPageTemplateCollectionPersistence(
		LayoutPageTemplateCollectionPersistence
			layoutPageTemplateCollectionPersistence) {

		this.layoutPageTemplateCollectionPersistence =
			layoutPageTemplateCollectionPersistence;
	}

	/**
	 * Returns the counter local service.
	 *
	 * @return the counter local service
	 */
	public com.liferay.counter.kernel.service.CounterLocalService
		getCounterLocalService() {

		return counterLocalService;
	}

	/**
	 * Sets the counter local service.
	 *
	 * @param counterLocalService the counter local service
	 */
	public void setCounterLocalService(
		com.liferay.counter.kernel.service.CounterLocalService
			counterLocalService) {

		this.counterLocalService = counterLocalService;
	}

	/**
	 * Returns the resource local service.
	 *
	 * @return the resource local service
	 */
	public com.liferay.portal.kernel.service.ResourceLocalService
		getResourceLocalService() {

		return resourceLocalService;
	}

	/**
	 * Sets the resource local service.
	 *
	 * @param resourceLocalService the resource local service
	 */
	public void setResourceLocalService(
		com.liferay.portal.kernel.service.ResourceLocalService
			resourceLocalService) {

		this.resourceLocalService = resourceLocalService;
	}

	/**
	 * Returns the user local service.
	 *
	 * @return the user local service
	 */
	public com.liferay.portal.kernel.service.UserLocalService
		getUserLocalService() {

		return userLocalService;
	}

	/**
	 * Sets the user local service.
	 *
	 * @param userLocalService the user local service
	 */
	public void setUserLocalService(
		com.liferay.portal.kernel.service.UserLocalService userLocalService) {

		this.userLocalService = userLocalService;
	}

	/**
	 * Returns the user remote service.
	 *
	 * @return the user remote service
	 */
	public com.liferay.portal.kernel.service.UserService getUserService() {
		return userService;
	}

	/**
	 * Sets the user remote service.
	 *
	 * @param userService the user remote service
	 */
	public void setUserService(
		com.liferay.portal.kernel.service.UserService userService) {

		this.userService = userService;
	}

	/**
	 * Returns the user persistence.
	 *
	 * @return the user persistence
	 */
	public UserPersistence getUserPersistence() {
		return userPersistence;
	}

	/**
	 * Sets the user persistence.
	 *
	 * @param userPersistence the user persistence
	 */
	public void setUserPersistence(UserPersistence userPersistence) {
		this.userPersistence = userPersistence;
	}

	/**
	 * Returns the layout page template entry local service.
	 *
	 * @return the layout page template entry local service
	 */
	public
		com.liferay.layout.page.template.service.
			LayoutPageTemplateEntryLocalService
				getLayoutPageTemplateEntryLocalService() {

		return layoutPageTemplateEntryLocalService;
	}

	/**
	 * Sets the layout page template entry local service.
	 *
	 * @param layoutPageTemplateEntryLocalService the layout page template entry local service
	 */
	public void setLayoutPageTemplateEntryLocalService(
		com.liferay.layout.page.template.service.
			LayoutPageTemplateEntryLocalService
				layoutPageTemplateEntryLocalService) {

		this.layoutPageTemplateEntryLocalService =
			layoutPageTemplateEntryLocalService;
	}

	/**
	 * Returns the layout page template entry remote service.
	 *
	 * @return the layout page template entry remote service
	 */
	public
		com.liferay.layout.page.template.service.LayoutPageTemplateEntryService
			getLayoutPageTemplateEntryService() {

		return layoutPageTemplateEntryService;
	}

	/**
	 * Sets the layout page template entry remote service.
	 *
	 * @param layoutPageTemplateEntryService the layout page template entry remote service
	 */
	public void setLayoutPageTemplateEntryService(
		com.liferay.layout.page.template.service.LayoutPageTemplateEntryService
			layoutPageTemplateEntryService) {

		this.layoutPageTemplateEntryService = layoutPageTemplateEntryService;
	}

	/**
	 * Returns the layout page template entry persistence.
	 *
	 * @return the layout page template entry persistence
	 */
	public LayoutPageTemplateEntryPersistence
		getLayoutPageTemplateEntryPersistence() {

		return layoutPageTemplateEntryPersistence;
	}

	/**
	 * Sets the layout page template entry persistence.
	 *
	 * @param layoutPageTemplateEntryPersistence the layout page template entry persistence
	 */
	public void setLayoutPageTemplateEntryPersistence(
		LayoutPageTemplateEntryPersistence layoutPageTemplateEntryPersistence) {

		this.layoutPageTemplateEntryPersistence =
			layoutPageTemplateEntryPersistence;
	}

	public void afterPropertiesSet() {
		LayoutPageTemplateCollectionServiceUtil.setService(
			layoutPageTemplateCollectionService);
	}

	public void destroy() {
		LayoutPageTemplateCollectionServiceUtil.setService(null);
	}

	/**
	 * Returns the OSGi service identifier.
	 *
	 * @return the OSGi service identifier
	 */
	@Override
	public String getOSGiServiceIdentifier() {
		return LayoutPageTemplateCollectionService.class.getName();
	}

	protected Class<?> getModelClass() {
		return LayoutPageTemplateCollection.class;
	}

	protected String getModelClassName() {
		return LayoutPageTemplateCollection.class.getName();
	}

	/**
	 * Performs a SQL query.
	 *
	 * @param sql the sql query
	 */
	protected void runSQL(String sql) {
		DataSource dataSource =
			layoutPageTemplateCollectionPersistence.getDataSource();

		DB db = DBManagerUtil.getDB();

		Connection currentConnection = CurrentConnectionUtil.getConnection(
			dataSource);

		try {
			if (currentConnection != null) {
				db.runSQL(currentConnection, new String[] {sql});

				return;
			}

			try (Connection connection = dataSource.getConnection()) {
				db.runSQL(connection, new String[] {sql});
			}
		}
		catch (Exception exception) {
			throw new SystemException(exception);
		}
	}

	@BeanReference(
		type = com.liferay.layout.page.template.service.LayoutPageTemplateCollectionLocalService.class
	)
	protected com.liferay.layout.page.template.service.
		LayoutPageTemplateCollectionLocalService
			layoutPageTemplateCollectionLocalService;

	@BeanReference(type = LayoutPageTemplateCollectionService.class)
	protected LayoutPageTemplateCollectionService
		layoutPageTemplateCollectionService;

	@BeanReference(type = LayoutPageTemplateCollectionPersistence.class)
	protected LayoutPageTemplateCollectionPersistence
		layoutPageTemplateCollectionPersistence;

	@ServiceReference(
		type = com.liferay.counter.kernel.service.CounterLocalService.class
	)
	protected com.liferay.counter.kernel.service.CounterLocalService
		counterLocalService;

	@ServiceReference(
		type = com.liferay.portal.kernel.service.ResourceLocalService.class
	)
	protected com.liferay.portal.kernel.service.ResourceLocalService
		resourceLocalService;

	@ServiceReference(
		type = com.liferay.portal.kernel.service.UserLocalService.class
	)
	protected com.liferay.portal.kernel.service.UserLocalService
		userLocalService;

	@ServiceReference(
		type = com.liferay.portal.kernel.service.UserService.class
	)
	protected com.liferay.portal.kernel.service.UserService userService;

	@ServiceReference(type = UserPersistence.class)
	protected UserPersistence userPersistence;

	@BeanReference(
		type = com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService.class
	)
	protected
		com.liferay.layout.page.template.service.
			LayoutPageTemplateEntryLocalService
				layoutPageTemplateEntryLocalService;

	@BeanReference(
		type = com.liferay.layout.page.template.service.LayoutPageTemplateEntryService.class
	)
	protected
		com.liferay.layout.page.template.service.LayoutPageTemplateEntryService
			layoutPageTemplateEntryService;

	@BeanReference(type = LayoutPageTemplateEntryPersistence.class)
	protected LayoutPageTemplateEntryPersistence
		layoutPageTemplateEntryPersistence;

	private static final Log _log = LogFactoryUtil.getLog(
		LayoutPageTemplateCollectionServiceBaseImpl.class);

}