/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.util.comparator;

import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.portal.kernel.util.OrderByComparator;

public class KBObjectsPriorityComparator<T>
extends OrderByComparator<T> {
    public static final String ORDER_BY_ASC = "modelFolder DESC, priority ASC, title ASC";
    public static final String ORDER_BY_DESC = "modelFolder DESC, priority DESC, title ASC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"priority", "title"};
    private final boolean _ascending;

    public KBObjectsPriorityComparator() {
        this(false);
    }

    public KBObjectsPriorityComparator(boolean ascending) {
        this._ascending = ascending;
    }

    public int compare(T t1, T t2) {
        int value = 0;
        double priority1 = this.getPriority(t1);
        double priority2 = this.getPriority(t2);
        String title1 = this.getTitle(t1);
        String title2 = this.getTitle(t1);
        value = t1 instanceof KBFolder && t2 instanceof KBFolder ? title1.compareToIgnoreCase(title2) : (t1 instanceof KBFolder ? -1 : (t2 instanceof KBFolder ? 1 : (priority1 < priority2 ? -1 : (priority1 > priority2 ? 1 : title1.compareToIgnoreCase(title2)))));
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    public boolean isAscending() {
        return this._ascending;
    }

    protected double getPriority(Object obj) {
        if (obj instanceof KBArticle) {
            KBArticle kbArticle = (KBArticle)obj;
            return kbArticle.getPriority();
        }
        return 0.0;
    }

    protected String getTitle(Object obj) {
        if (obj instanceof KBArticle) {
            KBArticle kbArticle = (KBArticle)obj;
            return kbArticle.getTitle();
        }
        KBFolder kbFolder = (KBFolder)obj;
        return kbFolder.getName();
    }
}

