/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.collection.provider.item.selector.web.internal.item.selector;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemListBuilder;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.LabelItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.LabelItemListBuilder;
import com.liferay.info.collection.provider.InfoCollectionProvider;
import com.liferay.item.selector.ItemSelectorViewDescriptor;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.url.builder.PortletURLBuilder;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.KeyValuePairComparator;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public abstract class BaseItemSelectorViewDescriptor<T extends InfoCollectionProvider<?>>
implements ItemSelectorViewDescriptor<T> {
    protected final HttpServletRequest httpServletRequest;
    protected final List<T> infoCollectionProviders;
    protected final PortletURL portletURL;
    protected final ThemeDisplay themeDisplay;
    private String _selectedItemType;

    public BaseItemSelectorViewDescriptor(HttpServletRequest httpServletRequest, PortletURL portletURL, List<T> infoCollectionProviders) {
        this.httpServletRequest = httpServletRequest;
        this.portletURL = portletURL;
        this.infoCollectionProviders = infoCollectionProviders;
        this.themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public String[] getDisplayViews() {
        return new String[]{"icon"};
    }

    public List<LabelItem> getFilterLabelItems() {
        return LabelItemListBuilder.add(() -> Validator.isNotNull((String)this.getSelectedItemType()), labelItem -> {
            labelItem.putData("removeLabelURL", PortletURLBuilder.create((PortletURL)this.portletURL).setParameter("itemType", (String)null).buildString());
            labelItem.setDismissible(true);
            String modelResource = ResourceActionsUtil.getModelResource((Locale)this.themeDisplay.getLocale(), (String)this.getSelectedItemType());
            labelItem.setLabel(LanguageUtil.get((Locale)this.themeDisplay.getLocale(), (String)"item-type") + ": " + modelResource);
        }).build();
    }

    public List<DropdownItem> getFilterNavigationDropdownItems() {
        return DropdownItemListBuilder.addGroup(dropdownGroupItem -> {
            dropdownGroupItem.setDropdownItems(this._getFilterTypeDropdownItems());
            dropdownGroupItem.setLabel(LanguageUtil.get((Locale)this.themeDisplay.getLocale(), (String)"filter-by-item-type"));
        }).build();
    }

    public boolean isShowSearch() {
        return true;
    }

    protected String getSelectedItemType() {
        if (this._selectedItemType != null) {
            return this._selectedItemType;
        }
        this._selectedItemType = ParamUtil.getString((HttpServletRequest)this.httpServletRequest, (String)"itemType");
        return this._selectedItemType;
    }

    private List<DropdownItem> _getFilterTypeDropdownItems() {
        final List keyValuePairs = TransformUtil.transform(this.infoCollectionProviders, infoCollectionProvider -> {
            String collectionItemClassName = infoCollectionProvider.getCollectionItemClassName();
            return new KeyValuePair(collectionItemClassName, ResourceActionsUtil.getModelResource((Locale)this.themeDisplay.getLocale(), (String)collectionItemClassName));
        });
        ListUtil.distinct((List)keyValuePairs, (Comparator)new KeyValuePairComparator(false, true));
        return new DropdownItemList(){
            {
                for (KeyValuePair keyValuePair : keyValuePairs) {
                    this.add(dropdownItem -> {
                        if (Objects.equals(keyValuePair.getKey(), BaseItemSelectorViewDescriptor.this.getSelectedItemType())) {
                            dropdownItem.setActive(true);
                        }
                        dropdownItem.setHref(BaseItemSelectorViewDescriptor.this.portletURL, new Object[]{"itemType", keyValuePair.getKey()});
                        dropdownItem.setLabel(keyValuePair.getValue());
                    });
                }
            }
        };
    }
}

