/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.html.preview.model.impl;

import com.liferay.html.preview.model.HtmlPreviewEntry;
import com.liferay.html.preview.service.HtmlPreviewEntryLocalServiceUtil;

/**
 * The extended model base implementation for the HtmlPreviewEntry service. Represents a row in the &quot;HtmlPreviewEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link HtmlPreviewEntryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see HtmlPreviewEntryImpl
 * @see HtmlPreviewEntry
 * @generated
 */
public abstract class HtmlPreviewEntryBaseImpl
	extends HtmlPreviewEntryModelImpl implements HtmlPreviewEntry {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a html preview entry model instance should use the <code>HtmlPreviewEntry</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			HtmlPreviewEntryLocalServiceUtil.addHtmlPreviewEntry(this);
		}
		else {
			HtmlPreviewEntryLocalServiceUtil.updateHtmlPreviewEntry(this);
		}
	}

}