/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.portal.instances.internal.resource.v1_0;

import com.liferay.headless.portal.instances.dto.v1_0.Admin;
import com.liferay.headless.portal.instances.dto.v1_0.PortalInstance;
import com.liferay.headless.portal.instances.internal.resource.v1_0.BasePortalInstanceResourceImpl;
import com.liferay.headless.portal.instances.resource.v1_0.PortalInstanceResource;
import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.exception.UserScreenNameException;
import com.liferay.portal.kernel.instance.PortalInstancePool;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.security.auth.EmailAddressValidator;
import com.liferay.portal.kernel.service.CompanyService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.EmailAddressValidatorFactory;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.vulcan.pagination.Page;
import java.util.ArrayList;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/portal-instance.properties"}, scope=ServiceScope.PROTOTYPE, service={PortalInstanceResource.class})
public class PortalInstanceResourceImpl
extends BasePortalInstanceResourceImpl {
    @Reference
    private CompanyService _companyService;

    @Override
    public void deletePortalInstance(String portalInstanceId) throws Exception {
        Company company = this._companyService.getCompanyByWebId(portalInstanceId);
        this._companyService.deleteCompany(company.getCompanyId());
    }

    @Override
    public PortalInstance getPortalInstance(String portalInstanceId) throws Exception {
        return this._toPortalInstance(this._companyService.getCompanyByWebId(portalInstanceId));
    }

    @Override
    public Page<PortalInstance> getPortalInstancesPage(Boolean skipDefault) throws Exception {
        boolean finalSkipDefault = GetterUtil.getBoolean((Object)skipDefault);
        ArrayList portalInstances = new ArrayList();
        this._companyService.forEachCompany(company -> {
            if (!finalSkipDefault || PortalInstancePool.getDefaultCompanyId() != company.getCompanyId()) {
                portalInstances.add(this._toPortalInstance((Company)company));
            }
        });
        return Page.of(portalInstances);
    }

    @Override
    public PortalInstance patchPortalInstance(String portalInstanceId, PortalInstance portalInstance) throws Exception {
        Company company = this._companyService.getCompanyByWebId(portalInstanceId);
        String virtualHostname = GetterUtil.getString((String)portalInstance.getVirtualHost(), (String)company.getVirtualHostname());
        String domain = GetterUtil.getString((String)portalInstance.getDomain(), (String)company.getMx());
        return this._toPortalInstance(this._companyService.updateCompany(company.getCompanyId(), virtualHostname, domain, company.getMaxUsers(), company.isActive()));
    }

    @Override
    public PortalInstance postPortalInstance(PortalInstance portalInstance) throws Exception {
        Admin admin = portalInstance.getAdmin();
        Long companyId = portalInstance.getCompanyId();
        if (companyId == null) {
            companyId = 0L;
        }
        long finalCompanyId = companyId;
        if (admin != null) {
            this._validateAdmin(admin);
            return this._toPortalInstance(PortalInstances.addCompany((String)portalInstance.getSiteInitializerKey(), () -> this._companyService.addCompany(Long.valueOf(finalCompanyId), portalInstance.getPortalInstanceId(), portalInstance.getVirtualHost(), portalInstance.getDomain(), 0, true, null, null, admin.getEmailAddress(), admin.getGivenName(), null, admin.getFamilyName())));
        }
        return this._toPortalInstance(PortalInstances.addCompany((String)portalInstance.getSiteInitializerKey(), () -> this._companyService.addCompany(finalCompanyId, portalInstance.getPortalInstanceId(), portalInstance.getVirtualHost(), portalInstance.getDomain(), 0, true)));
    }

    @Override
    public void putPortalInstanceActivate(String portalInstanceId) throws Exception {
        Company company = this._companyService.getCompanyByWebId(portalInstanceId);
        this._companyService.updateCompany(company.getCompanyId(), company.getVirtualHostname(), company.getMx(), company.getMaxUsers(), true);
    }

    @Override
    public void putPortalInstanceDeactivate(String portalInstanceId) throws Exception {
        Company company = this._companyService.getCompanyByWebId(portalInstanceId);
        this._companyService.updateCompany(company.getCompanyId(), company.getVirtualHostname(), company.getMx(), company.getMaxUsers(), false);
    }

    private PortalInstance _toPortalInstance(final Company company) {
        return new PortalInstance(){
            {
                this.setActive(() -> ((Company)company).isActive());
                this.setCompanyId(() -> ((Company)company).getCompanyId());
                this.setDomain(() -> ((Company)company).getMx());
                this.setPortalInstanceId(() -> ((Company)company).getWebId());
                this.setVirtualHost(() -> ((Company)company).getVirtualHostname());
            }
        };
    }

    private void _validateAdmin(Admin admin) throws Exception {
        if (Validator.isNull((String)admin.getEmailAddress()) || Validator.isNull((String)admin.getFamilyName()) || Validator.isNull((String)admin.getGivenName())) {
            throw new UserScreenNameException.MustNotBeNull();
        }
        EmailAddressValidator emailAddressValidator = EmailAddressValidatorFactory.getInstance();
        if (!emailAddressValidator.validate(0L, admin.getEmailAddress())) {
            throw new UserEmailAddressException.MustValidate(admin.getEmailAddress(), emailAddressValidator);
        }
    }
}

