/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.object.internal.dto.v1_0.converter;

import com.liferay.headless.delivery.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.object.dto.v1_0.Collaborator;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.sharing.model.SharingEntry;
import com.liferay.sharing.security.permission.SharingEntryAction;
import java.util.Collection;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.headless.object.dto.v1_0.Collaborator"}, service={DTOConverter.class})
public class CollaboratorDTOConverter
implements DTOConverter<SharingEntry, Collaborator> {
    @Reference
    private Portal _portal;
    @Reference
    private UserGroupLocalService _userGroupLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return Collaborator.class.getSimpleName();
    }

    public Collaborator toDTO(final DTOConverterContext dtoConverterContext, final SharingEntry sharingEntry) throws Exception {
        final User user = this._getUser(sharingEntry);
        final UserGroup userGroup = this._getUserGroup(sharingEntry);
        return new Collaborator(){
            {
                this.setActionIds(() -> (String[])TransformUtil.transformToArray((Collection)SharingEntryAction.getSharingEntryActions((long)sharingEntry.getActionIds()), SharingEntryAction::getActionId, String.class));
                this.setCreator(() -> CreatorUtil.toCreator((DTOConverterContext)dtoConverterContext, (Portal)CollaboratorDTOConverter.this._portal, (User)CollaboratorDTOConverter.this._userLocalService.getUser(sharingEntry.getUserId())));
                this.setDateExpired(() -> ((SharingEntry)sharingEntry).getExpirationDate());
                this.setExternalReferenceCode(() -> {
                    if (user != null) {
                        return user.getExternalReferenceCode();
                    }
                    return userGroup.getExternalReferenceCode();
                });
                this.setName(() -> {
                    if (user != null) {
                        return user.getFullName();
                    }
                    return userGroup.getName();
                });
                this.setPortrait(() -> {
                    if (user != null) {
                        if (user.getPortraitId() == 0L) {
                            return null;
                        }
                        ThemeDisplay themeDisplay = new ThemeDisplay(){
                            {
                                this.setPathImage(CollaboratorDTOConverter.this._portal.getPathImage());
                            }
                        };
                        return user.getPortraitURL(themeDisplay);
                    }
                    return null;
                });
                this.setShare(() -> ((SharingEntry)sharingEntry).isShareable());
                this.setType(() -> {
                    if (user != null) {
                        return Collaborator.Type.USER;
                    }
                    return Collaborator.Type.USER_GROUP;
                });
            }
        };
    }

    private User _getUser(SharingEntry sharingEntry) throws Exception {
        if (sharingEntry.getToUserId() > 0L) {
            return this._userLocalService.getUser(sharingEntry.getToUserId());
        }
        return null;
    }

    private UserGroup _getUserGroup(SharingEntry sharingEntry) throws Exception {
        if (sharingEntry.getToUserGroupId() > 0L) {
            return this._userGroupLocalService.getUserGroup(sharingEntry.getToUserGroupId());
        }
        return null;
    }
}

