/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.object.internal.graphql.query.v1_0;

import com.liferay.headless.object.dto.v1_0.Collaborator;
import com.liferay.headless.object.dto.v1_0.ObjectEntryFolder;
import com.liferay.headless.object.resource.v1_0.CollaboratorResource;
import com.liferay.headless.object.resource.v1_0.ObjectEntryFolderResource;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.aggregation.Facet;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLTypeExtension;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.osgi.service.component.ComponentServiceObjects;

public class Query {
    private static ComponentServiceObjects<CollaboratorResource> _collaboratorResourceComponentServiceObjects;
    private static ComponentServiceObjects<ObjectEntryFolderResource> _objectEntryFolderResourceComponentServiceObjects;
    private AcceptLanguage _acceptLanguage;
    private BiFunction<Object, List<String>, Aggregation> _aggregationBiFunction;
    private Company _company;
    private BiFunction<Object, String, Filter> _filterBiFunction;
    private GroupLocalService _groupLocalService;
    private HttpServletRequest _httpServletRequest;
    private HttpServletResponse _httpServletResponse;
    private ResourceActionLocalService _resourceActionLocalService;
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    private RoleLocalService _roleLocalService;
    private BiFunction<Object, String, Sort[]> _sortsBiFunction;
    private UriInfo _uriInfo;
    private User _user;

    public static void setCollaboratorResourceComponentServiceObjects(ComponentServiceObjects<CollaboratorResource> collaboratorResourceComponentServiceObjects) {
        _collaboratorResourceComponentServiceObjects = collaboratorResourceComponentServiceObjects;
    }

    public static void setObjectEntryFolderResourceComponentServiceObjects(ComponentServiceObjects<ObjectEntryFolderResource> objectEntryFolderResourceComponentServiceObjects) {
        _objectEntryFolderResourceComponentServiceObjects = objectEntryFolderResourceComponentServiceObjects;
    }

    @GraphQLField(description="Retrieves the collaborator of an object entry.")
    public @GraphQLField(description="Retrieves the collaborator of an object entry.") Collaborator objectEntryFolderCollaboratorByTypeCollaborator(@GraphQLName(value="objectEntryFolderId") Long objectEntryFolderId, @GraphQLName(value="type") String type, @GraphQLName(value="collaboratorId") Long collaboratorId) throws Exception {
        return (Collaborator)this._applyComponentServiceObjects(_collaboratorResourceComponentServiceObjects, this::_populateResourceContext, collaboratorResource -> collaboratorResource.getObjectEntryFolderCollaboratorByTypeCollaborator(objectEntryFolderId, type, collaboratorId));
    }

    @GraphQLField(description="Retrieves the collaborators of an object entry folder.")
    public @GraphQLField(description="Retrieves the collaborators of an object entry folder.") CollaboratorPage objectEntryFolderCollaborators(@GraphQLName(value="objectEntryFolderId") Long objectEntryFolderId, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (CollaboratorPage)this._applyComponentServiceObjects(_collaboratorResourceComponentServiceObjects, this::_populateResourceContext, collaboratorResource -> new CollaboratorPage(collaboratorResource.getObjectEntryFolderCollaboratorsPage(objectEntryFolderId, Pagination.of((int)page, (int)pageSize))));
    }

    @GraphQLField(description="Retrieves the collaborator for an object entry folder.")
    public @GraphQLField(description="Retrieves the collaborator for an object entry folder.") Collaborator scopeScopeKeyObjectEntryFolderByExternalReferenceCodeCollaboratorByTypeCollaborator(@GraphQLName(value="scopeKey") String scopeKey, @GraphQLName(value="externalReferenceCode") String externalReferenceCode, @GraphQLName(value="type") String type, @GraphQLName(value="collaboratorId") Long collaboratorId) throws Exception {
        return (Collaborator)this._applyComponentServiceObjects(_collaboratorResourceComponentServiceObjects, this::_populateResourceContext, collaboratorResource -> collaboratorResource.getScopeScopeKeyObjectEntryFolderByExternalReferenceCodeCollaboratorByTypeCollaborator(scopeKey, externalReferenceCode, type, collaboratorId));
    }

    @GraphQLField(description="Retrieves the collaborators of an object entry.")
    public @GraphQLField(description="Retrieves the collaborators of an object entry.") CollaboratorPage scopeScopeKeyObjectEntryFolderByExternalReferenceCodeCollaborators(@GraphQLName(value="scopeKey") String scopeKey, @GraphQLName(value="externalReferenceCode") String externalReferenceCode, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (CollaboratorPage)this._applyComponentServiceObjects(_collaboratorResourceComponentServiceObjects, this::_populateResourceContext, collaboratorResource -> new CollaboratorPage(collaboratorResource.getScopeScopeKeyObjectEntryFolderByExternalReferenceCodeCollaboratorsPage(scopeKey, externalReferenceCode, Pagination.of((int)page, (int)pageSize))));
    }

    @GraphQLField(description="Retrieves the object entry folder.")
    public @GraphQLField(description="Retrieves the object entry folder.") ObjectEntryFolder objectEntryFolder(@GraphQLName(value="objectEntryFolderId") Long objectEntryFolderId) throws Exception {
        return (ObjectEntryFolder)this._applyComponentServiceObjects(_objectEntryFolderResourceComponentServiceObjects, this::_populateResourceContext, objectEntryFolderResource -> objectEntryFolderResource.getObjectEntryFolder(objectEntryFolderId));
    }

    @GraphQLField
    public ObjectEntryFolderPage objectEntryFolderPermissions(@GraphQLName(value="objectEntryFolderId") Long objectEntryFolderId, @GraphQLName(value="roleNames") String roleNames) throws Exception {
        return (ObjectEntryFolderPage)this._applyComponentServiceObjects(_objectEntryFolderResourceComponentServiceObjects, this::_populateResourceContext, objectEntryFolderResource -> new ObjectEntryFolderPage(objectEntryFolderResource.getObjectEntryFolderPermissionsPage(objectEntryFolderId, roleNames)));
    }

    @GraphQLField
    public ObjectEntryFolder scopeScopeKeyObjectEntryFolderByExternalReferenceCode(@GraphQLName(value="scopeKey") String scopeKey, @GraphQLName(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return (ObjectEntryFolder)this._applyComponentServiceObjects(_objectEntryFolderResourceComponentServiceObjects, this::_populateResourceContext, objectEntryFolderResource -> objectEntryFolderResource.getScopeScopeKeyObjectEntryFolderByExternalReferenceCode(scopeKey, externalReferenceCode));
    }

    @GraphQLField
    public ObjectEntryFolderPage scopeScopeKeyObjectEntryFolders(@GraphQLName(value="scopeKey") String scopeKey, @GraphQLName(value="flatten") Boolean flatten, @GraphQLName(value="search") String search, @GraphQLName(value="aggregation") List<String> aggregations, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (ObjectEntryFolderPage)this._applyComponentServiceObjects(_objectEntryFolderResourceComponentServiceObjects, this::_populateResourceContext, objectEntryFolderResource -> new ObjectEntryFolderPage(objectEntryFolderResource.getScopeScopeKeyObjectEntryFoldersPage(scopeKey, flatten, search, this._aggregationBiFunction.apply(objectEntryFolderResource, aggregations), this._filterBiFunction.apply(objectEntryFolderResource, filterString), Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(objectEntryFolderResource, sortsString))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, R, E1 extends Throwable, E2 extends Throwable> R _applyComponentServiceObjects(ComponentServiceObjects<T> componentServiceObjects, UnsafeConsumer<T, E1> unsafeConsumer, UnsafeFunction<T, R, E2> unsafeFunction) throws E1, E2 {
        Object resource = componentServiceObjects.getService();
        try {
            unsafeConsumer.accept(resource);
            Object object = unsafeFunction.apply(resource);
            return (R)object;
        }
        finally {
            componentServiceObjects.ungetService(resource);
        }
    }

    private void _populateResourceContext(CollaboratorResource collaboratorResource) throws Exception {
        collaboratorResource.setContextAcceptLanguage(this._acceptLanguage);
        collaboratorResource.setContextCompany(this._company);
        collaboratorResource.setContextHttpServletRequest(this._httpServletRequest);
        collaboratorResource.setContextHttpServletResponse(this._httpServletResponse);
        collaboratorResource.setContextUriInfo(this._uriInfo);
        collaboratorResource.setContextUser(this._user);
        collaboratorResource.setGroupLocalService(this._groupLocalService);
        collaboratorResource.setResourceActionLocalService(this._resourceActionLocalService);
        collaboratorResource.setResourcePermissionLocalService(this._resourcePermissionLocalService);
        collaboratorResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(ObjectEntryFolderResource objectEntryFolderResource) throws Exception {
        objectEntryFolderResource.setContextAcceptLanguage(this._acceptLanguage);
        objectEntryFolderResource.setContextCompany(this._company);
        objectEntryFolderResource.setContextHttpServletRequest(this._httpServletRequest);
        objectEntryFolderResource.setContextHttpServletResponse(this._httpServletResponse);
        objectEntryFolderResource.setContextUriInfo(this._uriInfo);
        objectEntryFolderResource.setContextUser(this._user);
        objectEntryFolderResource.setGroupLocalService(this._groupLocalService);
        objectEntryFolderResource.setResourceActionLocalService(this._resourceActionLocalService);
        objectEntryFolderResource.setResourcePermissionLocalService(this._resourcePermissionLocalService);
        objectEntryFolderResource.setRoleLocalService(this._roleLocalService);
    }

    @GraphQLName(value="CollaboratorPage")
    public class CollaboratorPage {
        @GraphQLField
        protected Map<String, Map<String, String>> actions;
        @GraphQLField
        protected List<Facet> facets;
        @GraphQLField
        protected Collection<Collaborator> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public CollaboratorPage(Page collaboratorPage) {
            this.actions = collaboratorPage.getActions();
            this.facets = collaboratorPage.getFacets();
            this.items = collaboratorPage.getItems();
            this.lastPage = collaboratorPage.getLastPage();
            this.page = collaboratorPage.getPage();
            this.pageSize = collaboratorPage.getPageSize();
            this.totalCount = collaboratorPage.getTotalCount();
        }
    }

    @GraphQLName(value="ObjectEntryFolderPage")
    public class ObjectEntryFolderPage {
        @GraphQLField
        protected Map<String, Map<String, String>> actions;
        @GraphQLField
        protected List<Facet> facets;
        @GraphQLField
        protected Collection<ObjectEntryFolder> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public ObjectEntryFolderPage(Page objectEntryFolderPage) {
            this.actions = objectEntryFolderPage.getActions();
            this.facets = objectEntryFolderPage.getFacets();
            this.items = objectEntryFolderPage.getItems();
            this.lastPage = objectEntryFolderPage.getLastPage();
            this.page = objectEntryFolderPage.getPage();
            this.pageSize = objectEntryFolderPage.getPageSize();
            this.totalCount = objectEntryFolderPage.getTotalCount();
        }
    }

    @GraphQLTypeExtension(value=ObjectEntryFolder.class)
    public class ParentObjectEntryFolderObjectEntryFolderIdTypeExtension {
        private ObjectEntryFolder _objectEntryFolder;

        public ParentObjectEntryFolderObjectEntryFolderIdTypeExtension(ObjectEntryFolder objectEntryFolder) {
            this._objectEntryFolder = objectEntryFolder;
        }

        @GraphQLField(description="Retrieves the object entry folder.")
        public @GraphQLField(description="Retrieves the object entry folder.") ObjectEntryFolder parentObjectEntryFolder() throws Exception {
            if (this._objectEntryFolder.getParentObjectEntryFolderId() == null) {
                return null;
            }
            return (ObjectEntryFolder)Query.this._applyComponentServiceObjects(_objectEntryFolderResourceComponentServiceObjects, Query.this::_populateResourceContext, objectEntryFolderResource -> objectEntryFolderResource.getObjectEntryFolder(this._objectEntryFolder.getParentObjectEntryFolderId()));
        }
    }

    @GraphQLTypeExtension(value=ObjectEntryFolder.class)
    public class GetObjectEntryFolderCollaboratorsPageTypeExtension {
        private ObjectEntryFolder _objectEntryFolder;

        public GetObjectEntryFolderCollaboratorsPageTypeExtension(ObjectEntryFolder objectEntryFolder) {
            this._objectEntryFolder = objectEntryFolder;
        }

        @GraphQLField(description="Retrieves the collaborators of an object entry folder.")
        public @GraphQLField(description="Retrieves the collaborators of an object entry folder.") CollaboratorPage collaborators(@GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
            return (CollaboratorPage)Query.this._applyComponentServiceObjects(_collaboratorResourceComponentServiceObjects, Query.this::_populateResourceContext, collaboratorResource -> new CollaboratorPage(collaboratorResource.getObjectEntryFolderCollaboratorsPage(this._objectEntryFolder.getId(), Pagination.of((int)page, (int)pageSize))));
        }
    }

    @GraphQLTypeExtension(value=ObjectEntryFolder.class)
    public class GetObjectEntryFolderCollaboratorByTypeCollaboratorTypeExtension {
        private ObjectEntryFolder _objectEntryFolder;

        public GetObjectEntryFolderCollaboratorByTypeCollaboratorTypeExtension(ObjectEntryFolder objectEntryFolder) {
            this._objectEntryFolder = objectEntryFolder;
        }

        @GraphQLField(description="Retrieves the collaborator of an object entry.")
        public @GraphQLField(description="Retrieves the collaborator of an object entry.") Collaborator collaboratorByTypeCollaborator(@GraphQLName(value="type") String type, @GraphQLName(value="collaboratorId") Long collaboratorId) throws Exception {
            return (Collaborator)Query.this._applyComponentServiceObjects(_collaboratorResourceComponentServiceObjects, Query.this::_populateResourceContext, collaboratorResource -> collaboratorResource.getObjectEntryFolderCollaboratorByTypeCollaborator(this._objectEntryFolder.getId(), type, collaboratorId));
        }
    }
}

