/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.asset.library.internal.resource.v1_0;

import com.liferay.headless.asset.library.dto.v1_0.AssetLibrary;
import com.liferay.headless.asset.library.resource.v1_0.AssetLibraryResource;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.Resource;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.PermissionServiceUtil;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourceLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortField;
import com.liferay.portal.odata.sort.SortParser;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineExportTaskResource;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.fields.NestedFieldsSupplier;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.ModelPermissionsUtil;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.UriInfoUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

@Path(value="/v1.0")
public abstract class BaseAssetLibraryResourceImpl
implements AssetLibraryResource,
EntityModelResource,
VulcanBatchEngineTaskItemDelegate<AssetLibrary> {
    protected AcceptLanguage contextAcceptLanguage;
    protected UnsafeBiConsumer<Collection<AssetLibrary>, UnsafeFunction<AssetLibrary, AssetLibrary, Exception>, Exception> contextBatchUnsafeBiConsumer;
    protected UnsafeBiConsumer<Collection<AssetLibrary>, UnsafeConsumer<AssetLibrary, Exception>, Exception> contextBatchUnsafeConsumer;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected SortParserProvider sortParserProvider;
    protected VulcanBatchEngineExportTaskResource vulcanBatchEngineExportTaskResource;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;
    private static final Log _log = LogFactoryUtil.getLog(BaseAssetLibraryResourceImpl.class);

    @Operation(description="Deletes the asset library by external reference code.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryExternalReferenceCode")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @DELETE
    @Path(value="/asset-libraries/{assetLibraryExternalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteAssetLibrary(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryExternalReferenceCode") String assetLibraryExternalReferenceCode) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @Consumes(value={"application/json"})
    @DELETE
    @Path(value="/asset-libraries/batch")
    @Produces(value={"application/json"})
    public Response deleteAssetLibraryBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(AssetLibrary.class.getName(), callbackURL, object)).build();
    }

    @Operation(description="Unpins the asset library.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryExternalReferenceCode")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @DELETE
    @Path(value="/asset-libraries/{assetLibraryExternalReferenceCode}/pins")
    @Produces(value={"application/json", "application/xml"})
    public void deleteAssetLibraryPin(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryExternalReferenceCode") String assetLibraryExternalReferenceCode) throws Exception {
    }

    protected abstract Page<AssetLibrary> doGetAssetLibrariesPage(String var1, String var2, com.liferay.portal.kernel.search.filter.Filter var3, Pagination var4, Sort[] var5) throws Exception;

    @Operation(description="Retrieves the asset libraries. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="keywords"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @GET
    @Path(value="/asset-libraries")
    @Produces(value={"application/json", "application/xml"})
    public final Page<AssetLibrary> getAssetLibrariesPage(@Parameter(hidden=true) @QueryParam(value="keywords") String keywords, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        Page<AssetLibrary> assetLibrariesPage = this.doGetAssetLibrariesPage(keywords, search, filter, pagination, sorts);
        for (AssetLibrary assetLibrary : assetLibrariesPage.getItems()) {
            assetLibrary.setPermissions(() -> (Permission[])NestedFieldsSupplier.supply((String)"permissions", nestedField -> {
                Page<Permission> permissionsPage = this.getAssetLibraryPermissionsPage(assetLibrary.getExternalReferenceCode(), null);
                Collection permissions = permissionsPage.getItems();
                return permissions.toArray(new Permission[permissions.size()]);
            }));
        }
        return assetLibrariesPage;
    }

    @Operation(description="Retrieves the pinned asset libraries.")
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @GET
    @Path(value="/asset-libraries/pinned-by-me")
    @Produces(value={"application/json", "application/xml"})
    public Page<AssetLibrary> getAssetLibrariesPinnedByMePage(@Context Pagination pagination) throws Exception {
        return Page.of(Collections.emptyList());
    }

    protected abstract AssetLibrary doGetAssetLibrary(String var1) throws Exception;

    @Operation(description="Retrieves the asset library by external reference code.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryExternalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @GET
    @Path(value="/asset-libraries/{assetLibraryExternalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public final AssetLibrary getAssetLibrary(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryExternalReferenceCode") String assetLibraryExternalReferenceCode) throws Exception {
        AssetLibrary getAssetLibrary = this.doGetAssetLibrary(assetLibraryExternalReferenceCode);
        getAssetLibrary.setPermissions(() -> (Permission[])NestedFieldsSupplier.supply((String)"permissions", nestedField -> {
            Page<Permission> permissionsPage = this.getAssetLibraryPermissionsPage(getAssetLibrary.getExternalReferenceCode(), null);
            Collection permissions = permissionsPage.getItems();
            return permissions.toArray(new Permission[permissions.size()]);
        }));
        return getAssetLibrary;
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryExternalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @GET
    @Path(value="/asset-libraries/{assetLibraryExternalReferenceCode}/permissions")
    @Produces(value={"application/json", "application/xml"})
    public Page<Permission> getAssetLibraryPermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryExternalReferenceCode") String assetLibraryExternalReferenceCode, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        Long groupId = this.getPermissionCheckerGroupId(assetLibraryExternalReferenceCode);
        Long resourceId = this.getPermissionCheckerResourceId(assetLibraryExternalReferenceCode);
        String resourceName = this.getPermissionCheckerResourceName(assetLibraryExternalReferenceCode);
        PermissionServiceUtil.checkPermission((long)groupId, (String)resourceName, (long)resourceId);
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", resourceId, "getAssetLibraryPermissionsPage", null, resourceName, groupId)).put((Object)"replace", this.addAction("PERMISSIONS", resourceId, "putAssetLibraryPermissionsPage", null, resourceName, groupId)).build(), resourceId, resourceName, roleNames);
    }

    @Operation(description="Updates the asset library using only the fields received in the request body with the given external reference code. Any other fields are left untouched.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryExternalReferenceCode")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/asset-libraries/{assetLibraryExternalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public AssetLibrary patchAssetLibrary(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryExternalReferenceCode") String assetLibraryExternalReferenceCode, AssetLibrary assetLibrary) throws Exception {
        AssetLibrary existingAssetLibrary = this.getAssetLibrary(assetLibraryExternalReferenceCode);
        if (assetLibrary.getAssetLibraryKey() != null) {
            existingAssetLibrary.setAssetLibraryKey(assetLibrary.getAssetLibraryKey());
        }
        if (assetLibrary.getDescription() != null) {
            existingAssetLibrary.setDescription(assetLibrary.getDescription());
        }
        if (assetLibrary.getDescription_i18n() != null) {
            existingAssetLibrary.setDescription_i18n(assetLibrary.getDescription_i18n());
        }
        if (assetLibrary.getExternalReferenceCode() != null) {
            existingAssetLibrary.setExternalReferenceCode(assetLibrary.getExternalReferenceCode());
        }
        if (assetLibrary.getName() != null) {
            existingAssetLibrary.setName(assetLibrary.getName());
        }
        if (assetLibrary.getName_i18n() != null) {
            existingAssetLibrary.setName_i18n(assetLibrary.getName_i18n());
        }
        if (assetLibrary.getPermissions() != null) {
            existingAssetLibrary.setPermissions(assetLibrary.getPermissions());
        }
        if (assetLibrary.getType() != null) {
            existingAssetLibrary.setType(assetLibrary.getType());
        }
        this.preparePatch(assetLibrary, existingAssetLibrary);
        return this.putAssetLibrary(assetLibraryExternalReferenceCode, existingAssetLibrary);
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="keywords"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort"), @Parameter(in=ParameterIn.QUERY, name="callbackURL"), @Parameter(in=ParameterIn.QUERY, name="contentType"), @Parameter(in=ParameterIn.QUERY, name="fieldNames")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @Consumes(value={"application/json"})
    @Path(value="/asset-libraries/export-batch")
    @POST
    @Produces(value={"application/json"})
    public Response postAssetLibrariesPageExportBatch(@Parameter(hidden=true) @QueryParam(value="keywords") String keywords, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Sort[] sorts, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, @Parameter(hidden=true) @DefaultValue(value="JSON") @QueryParam(value="contentType") String contentType, @Parameter(hidden=true) @QueryParam(value="fieldNames") String fieldNames) throws Exception {
        this.vulcanBatchEngineExportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineExportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineExportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineExportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineExportTaskResource.setContextUser(this.contextUser);
        this.vulcanBatchEngineExportTaskResource.setGroupLocalService(this.groupLocalService);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineExportTaskResource.postExportTask(AssetLibrary.class.getName(), callbackURL, contentType, fieldNames)).build();
    }

    protected abstract AssetLibrary doPostAssetLibrary(AssetLibrary var1) throws Exception;

    @Operation(description="Adds a new asset library")
    @Tags(value={@Tag(name="AssetLibrary")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/asset-libraries")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public final AssetLibrary postAssetLibrary(AssetLibrary assetLibrary) throws Exception {
        Permission[] permissions = assetLibrary.getPermissions();
        AssetLibrary postAssetLibrary = this.doPostAssetLibrary(assetLibrary);
        if (permissions != null) {
            Page<Permission> permissionsPage = this.putAssetLibraryPermissionsPage(postAssetLibrary.getExternalReferenceCode(), permissions);
            postAssetLibrary.setPermissions(() -> (Permission[])NestedFieldsSupplier.supply((String)"permissions", nestedField -> {
                Collection collection = permissionsPage.getItems();
                return collection.toArray(new Permission[collection.size()]);
            }));
        }
        return postAssetLibrary;
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @Consumes(value={"application/json"})
    @Path(value="/asset-libraries/batch")
    @POST
    @Produces(value={"application/json"})
    public Response postAssetLibraryBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(AssetLibrary.class.getName(), callbackURL, null, object)).build();
    }

    protected abstract AssetLibrary doPutAssetLibrary(String var1, AssetLibrary var2) throws Exception;

    @Operation(description="Replaces the asset library with information sent in the request body with the given external reference code. Any missing fields are deleted unless they are required.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryExternalReferenceCode")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/asset-libraries/{assetLibraryExternalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public final AssetLibrary putAssetLibrary(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryExternalReferenceCode") String assetLibraryExternalReferenceCode, AssetLibrary assetLibrary) throws Exception {
        Permission[] permissions = assetLibrary.getPermissions();
        AssetLibrary putAssetLibrary = this.doPutAssetLibrary(assetLibraryExternalReferenceCode, assetLibrary);
        if (permissions != null) {
            Page<Permission> permissionsPage = this.putAssetLibraryPermissionsPage(putAssetLibrary.getExternalReferenceCode(), permissions);
            putAssetLibrary.setPermissions(() -> (Permission[])NestedFieldsSupplier.supply((String)"permissions", nestedField -> {
                Collection collection = permissionsPage.getItems();
                return collection.toArray(new Permission[collection.size()]);
            }));
        }
        return putAssetLibrary;
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @Consumes(value={"application/json"})
    @Path(value="/asset-libraries/batch")
    @Produces(value={"application/json"})
    @PUT
    public Response putAssetLibraryBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(AssetLibrary.class.getName(), callbackURL, object)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryExternalReferenceCode")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/asset-libraries/{assetLibraryExternalReferenceCode}/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Page<Permission> putAssetLibraryPermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryExternalReferenceCode") String assetLibraryExternalReferenceCode, Permission[] permissions) throws Exception {
        Long groupId = this.getPermissionCheckerGroupId(assetLibraryExternalReferenceCode);
        Long resourceId = this.getPermissionCheckerResourceId(assetLibraryExternalReferenceCode);
        String resourceName = this.getPermissionCheckerResourceName(assetLibraryExternalReferenceCode);
        PermissionServiceUtil.checkPermission((long)groupId, (String)resourceName, (long)resourceId);
        ModelPermissions modelPermissions = ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)resourceId, (String)resourceName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService);
        Collection roleNames = modelPermissions.getRoleNames();
        for (ResourcePermission resourcePermission : this.resourcePermissionLocalService.getResourcePermissions(this.contextCompany.getCompanyId(), resourceName, 4, String.valueOf(resourceId))) {
            Role role = this.roleLocalService.fetchRole(resourcePermission.getRoleId());
            if (role == null || roleNames.contains(role.getName())) continue;
            for (ResourceAction resourceAction : this.resourceActionLocalService.getResourceActions(resourceName)) {
                this.resourcePermissionLocalService.removeResourcePermission(this.contextCompany.getCompanyId(), resourceName, 4, String.valueOf(resourceId), role.getRoleId(), resourceAction.getActionId());
            }
        }
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), groupId.longValue(), resourceName, String.valueOf(resourceId), modelPermissions);
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", resourceId, "getAssetLibraryPermissionsPage", null, resourceName, groupId)).put((Object)"replace", this.addAction("PERMISSIONS", resourceId, "putAssetLibraryPermissionsPage", null, resourceName, groupId)).build(), resourceId, resourceName, null);
    }

    @Operation(description="Pins the asset library.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryExternalReferenceCode")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @Path(value="/asset-libraries/{assetLibraryExternalReferenceCode}/pins")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public AssetLibrary putAssetLibraryPin(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryExternalReferenceCode") String assetLibraryExternalReferenceCode) throws Exception {
        return new AssetLibrary();
    }

    public void create(Collection<AssetLibrary> assetLibraries, Map<String, Serializable> parameters) throws Exception {
        String updateStrategy;
        UnsafeFunction assetLibraryUnsafeFunction = null;
        String createStrategy = (String)((Object)parameters.getOrDefault("createStrategy", (Serializable)((Object)"INSERT")));
        if (StringUtil.equalsIgnoreCase((String)createStrategy, (String)"INSERT")) {
            assetLibraryUnsafeFunction = assetLibrary -> this.postAssetLibrary((AssetLibrary)assetLibrary);
        }
        if (StringUtil.equalsIgnoreCase((String)createStrategy, (String)"UPSERT") && StringUtil.equalsIgnoreCase((String)(updateStrategy = (String)((Object)parameters.getOrDefault("updateStrategy", (Serializable)((Object)"UPDATE")))), (String)"UPDATE")) {
            assetLibraryUnsafeFunction = assetLibrary -> {
                AssetLibrary persistedAssetLibrary = null;
                persistedAssetLibrary = this.putAssetLibrary(assetLibrary.getExternalReferenceCode(), (AssetLibrary)assetLibrary);
                return persistedAssetLibrary;
            };
        }
        if (assetLibraryUnsafeFunction == null) {
            throw new NotSupportedException("Create strategy \"" + createStrategy + "\" is not supported for AssetLibrary");
        }
        if (this.contextBatchUnsafeBiConsumer != null) {
            this.contextBatchUnsafeBiConsumer.accept(assetLibraries, (Object)assetLibraryUnsafeFunction);
        } else if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(assetLibraries, arg_0 -> ((UnsafeFunction)assetLibraryUnsafeFunction).apply(arg_0));
        } else {
            for (AssetLibrary assetLibrary2 : assetLibraries) {
                assetLibraryUnsafeFunction.apply((Object)assetLibrary2);
            }
        }
    }

    public void delete(Collection<AssetLibrary> assetLibraries, Map<String, Serializable> parameters) throws Exception {
        UnsafeFunction assetLibraryUnsafeFunction = assetLibrary -> {
            if (assetLibrary.getExternalReferenceCode() != null) {
                this.deleteAssetLibrary(assetLibrary.getExternalReferenceCode());
                return assetLibrary;
            }
            throw new UnsupportedOperationException("Unable to delete by external reference code or ID");
        };
        if (this.contextBatchUnsafeBiConsumer != null) {
            this.contextBatchUnsafeBiConsumer.accept(assetLibraries, (Object)assetLibraryUnsafeFunction);
        } else if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(assetLibraries, arg_0 -> ((UnsafeFunction)assetLibraryUnsafeFunction).apply(arg_0));
        } else {
            for (AssetLibrary assetLibrary2 : assetLibraries) {
                assetLibraryUnsafeFunction.apply((Object)assetLibrary2);
            }
        }
    }

    public Set<String> getAvailableCreateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"INSERT", "UPSERT"});
    }

    public Set<String> getAvailableUpdateStrategies() {
        return SetUtil.fromArray((Object[])new String[0]);
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public String getResourceName() {
        return "AssetLibrary";
    }

    public String getVersion() {
        return "v1.0";
    }

    public Page<AssetLibrary> read(com.liferay.portal.kernel.search.filter.Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        return this.getAssetLibrariesPage((String)((Object)parameters.get("keywords")), search, filter, pagination, sorts);
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<AssetLibrary> assetLibraries, Map<String, Serializable> parameters) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    protected Long getPermissionCheckerGroupId(String groupExternalReferenceCode) throws Exception {
        Group group = this.groupLocalService.getGroupByExternalReferenceCode(groupExternalReferenceCode, this.contextCompany.getCompanyId());
        return group.getGroupId();
    }

    protected Long getPermissionCheckerResourceId(String externalReferenceCode) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected String getPermissionCheckerResourceName(String externalReferenceCode) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Page<Permission> toPermissionPage(Map<String, Map<String, String>> actions, long id, String resourceName, String roleNames) throws Exception {
        List resourceActions = this.resourceActionLocalService.getResourceActions(resourceName);
        if (Validator.isNotNull((String)roleNames)) {
            return Page.of(actions, this._getPermissions(this.contextCompany.getCompanyId(), resourceActions, id, resourceName, StringUtil.split((String)roleNames)));
        }
        return Page.of(actions, this._getPermissions(this.contextCompany.getCompanyId(), resourceActions, id, resourceName, null));
    }

    private Collection<Permission> _getPermissions(long companyId, List<ResourceAction> resourceActions, long resourceId, String resourceName, String[] roleNames) throws Exception {
        HashMap<String, 2> permissions = new HashMap<String, 2>();
        int count = this.resourcePermissionLocalService.getResourcePermissionsCount(companyId, resourceName, 4, String.valueOf(resourceId));
        if (count == 0) {
            ResourceLocalServiceUtil.addResources((long)companyId, (long)resourceId, (long)0L, (String)resourceName, (String)String.valueOf(resourceId), (boolean)false, (boolean)true, (boolean)true);
        }
        List actionIds = this.transform(resourceActions, resourceAction -> resourceAction.getActionId());
        HashSet resourcePermissions = new HashSet();
        resourcePermissions.addAll(this.resourcePermissionLocalService.getResourcePermissions(companyId, resourceName, 1, String.valueOf(companyId)));
        resourcePermissions.addAll(this.resourcePermissionLocalService.getResourcePermissions(companyId, resourceName, 2, String.valueOf(GroupThreadLocal.getGroupId())));
        resourcePermissions.addAll(this.resourcePermissionLocalService.getResourcePermissions(companyId, resourceName, 3, "0"));
        resourcePermissions.addAll(this.resourcePermissionLocalService.getResourcePermissions(companyId, resourceName, 4, String.valueOf(resourceId)));
        List resources = this.transform(resourcePermissions, resourcePermission -> ResourceLocalServiceUtil.getResource((long)resourcePermission.getCompanyId(), (String)resourcePermission.getName(), (int)resourcePermission.getScope(), (String)resourcePermission.getPrimKey()));
        HashSet<Role> roles = new HashSet<Role>();
        if (roleNames != null) {
            for (String string : roleNames) {
                roles.add(this.roleLocalService.getRole(companyId, string));
            }
        } else {
            for (ResourcePermission resourcePermission2 : resourcePermissions) {
                Role role = this.roleLocalService.getRole(resourcePermission2.getRoleId());
                roles.add(role);
            }
        }
        for (final Role role : roles) {
            final HashSet actionsIdsSet = new HashSet();
            for (Resource resource : resources) {
                actionsIdsSet.addAll(this.resourcePermissionLocalService.getAvailableResourcePermissionActionIds(resource.getCompanyId(), resource.getName(), 1, String.valueOf(resource.getCompanyId()), role.getRoleId(), actionIds));
                actionsIdsSet.addAll(this.resourcePermissionLocalService.getAvailableResourcePermissionActionIds(resource.getCompanyId(), resource.getName(), 2, String.valueOf(GroupThreadLocal.getGroupId()), role.getRoleId(), actionIds));
                actionsIdsSet.addAll(this.resourcePermissionLocalService.getAvailableResourcePermissionActionIds(resource.getCompanyId(), resource.getName(), 3, "0", role.getRoleId(), actionIds));
                actionsIdsSet.addAll(this.resourcePermissionLocalService.getAvailableResourcePermissionActionIds(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), role.getRoleId(), actionIds));
            }
            if (actionsIdsSet.isEmpty()) continue;
            Permission permission = new Permission(){
                {
                    this.actionIds = actionsIdsSet.toArray(new String[0]);
                    this.roleName = role.getName();
                }
            };
            permissions.put(role.getName(), permission);
        }
        return permissions.values();
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextBatchUnsafeBiConsumer(UnsafeBiConsumer<Collection<AssetLibrary>, UnsafeFunction<AssetLibrary, AssetLibrary, Exception>, Exception> contextBatchUnsafeBiConsumer) {
        this.contextBatchUnsafeBiConsumer = contextBatchUnsafeBiConsumer;
    }

    public void setContextBatchUnsafeConsumer(UnsafeBiConsumer<Collection<AssetLibrary>, UnsafeConsumer<AssetLibrary, Exception>, Exception> contextBatchUnsafeConsumer) {
        this.contextBatchUnsafeConsumer = contextBatchUnsafeConsumer;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = UriInfoUtil.getVulcanUriInfo((String)this.getApplicationPath(), (UriInfo)contextUriInfo);
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public void setSortParserProvider(SortParserProvider sortParserProvider) {
        this.sortParserProvider = sortParserProvider;
    }

    protected String getApplicationPath() {
        return "headless-asset-library";
    }

    public void setVulcanBatchEngineExportTaskResource(VulcanBatchEngineExportTaskResource vulcanBatchEngineExportTaskResource) {
        this.vulcanBatchEngineExportTaskResource = vulcanBatchEngineExportTaskResource;
    }

    public void setVulcanBatchEngineImportTaskResource(VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource) {
        this.vulcanBatchEngineImportTaskResource = vulcanBatchEngineImportTaskResource;
    }

    public com.liferay.portal.kernel.search.filter.Filter toFilter(String filterString, Map<String, List<String>> multivaluedMap) {
        try {
            EntityModel entityModel = this.getEntityModel(multivaluedMap);
            FilterParser filterParser = this.filterParserProvider.provide(entityModel);
            Filter oDataFilter = new Filter(filterParser.parse(filterString));
            return (com.liferay.portal.kernel.search.filter.Filter)this.expressionConvert.convert(oDataFilter.getExpression(), this.contextAcceptLanguage.getPreferredLocale(), entityModel);
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid filter " + filterString), (Throwable)exception);
            return null;
        }
    }

    public Sort[] toSorts(String sortString) {
        if (Validator.isNull((String)sortString)) {
            return null;
        }
        try {
            SortParser sortParser = this.sortParserProvider.provide(this.getEntityModel(Collections.emptyMap()));
            if (sortParser == null) {
                return null;
            }
            com.liferay.portal.odata.sort.Sort oDataSort = new com.liferay.portal.odata.sort.Sort(sortParser.parse(sortString));
            List sortFields = oDataSort.getSortFields();
            Sort[] sorts = new Sort[sortFields.size()];
            for (int i = 0; i < sortFields.size(); ++i) {
                SortField sortField = (SortField)sortFields.get(i);
                sorts[i] = new Sort(sortField.getSortableFieldName(this.contextAcceptLanguage.getPreferredLocale()), !sortField.isAscending());
            }
            return sorts;
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid sort " + sortString), (Throwable)exception);
            return new Sort[0];
        }
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected void preparePatch(AssetLibrary assetLibrary, AssetLibrary existingAssetLibrary) {
    }

    protected <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    public static <R, E extends Throwable> R[] transform(int[] array, UnsafeFunction<Integer, R, E> unsafeFunction, Class<? extends R> clazz) {
        return TransformUtil.transform((int[])array, unsafeFunction, clazz);
    }

    public static <R, E extends Throwable> R[] transform(long[] array, UnsafeFunction<Long, R, E> unsafeFunction, Class<? extends R> clazz) {
        return TransformUtil.transform((long[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    public static <T, E extends Throwable> boolean[] transformToBooleanArray(Collection<T> collection, UnsafeFunction<T, Boolean, E> unsafeFunction) {
        return TransformUtil.transformToBooleanArray(collection, unsafeFunction);
    }

    public static <T, E extends Throwable> boolean[] transformToBooleanArray(T[] array, UnsafeFunction<T, Boolean, E> unsafeFunction) {
        return TransformUtil.transformToBooleanArray((Object[])array, unsafeFunction);
    }

    public static <T, E extends Throwable> byte[] transformToByteArray(Collection<T> collection, UnsafeFunction<T, Byte, E> unsafeFunction) {
        return TransformUtil.transformToByteArray(collection, unsafeFunction);
    }

    public static <T, E extends Throwable> byte[] transformToByteArray(T[] array, UnsafeFunction<T, Byte, E> unsafeFunction) {
        return TransformUtil.transformToByteArray((Object[])array, unsafeFunction);
    }

    public static <T, E extends Throwable> double[] transformToDoubleArray(Collection<T> collection, UnsafeFunction<T, Double, E> unsafeFunction) {
        return TransformUtil.transformToDoubleArray(collection, unsafeFunction);
    }

    public static <T, E extends Throwable> double[] transformToDoubleArray(T[] array, UnsafeFunction<T, Double, E> unsafeFunction) {
        return TransformUtil.transformToDoubleArray((Object[])array, unsafeFunction);
    }

    public static <T, E extends Throwable> float[] transformToFloatArray(Collection<T> collection, UnsafeFunction<T, Float, E> unsafeFunction) {
        return TransformUtil.transformToFloatArray(collection, unsafeFunction);
    }

    public static <T, E extends Throwable> float[] transformToFloatArray(T[] array, UnsafeFunction<T, Float, E> unsafeFunction) {
        return TransformUtil.transformToFloatArray((Object[])array, unsafeFunction);
    }

    public static <T, R, E extends Throwable> int[] transformToIntArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToIntArray(collection, unsafeFunction);
    }

    public static <T, E extends Throwable> int[] transformToIntArray(T[] array, UnsafeFunction<T, Integer, E> unsafeFunction) {
        return TransformUtil.transformToIntArray((Object[])array, unsafeFunction);
    }

    public static <R, E extends Throwable> List<R> transformToList(int[] array, UnsafeFunction<Integer, R, E> unsafeFunction) {
        return TransformUtil.transformToList((int[])array, unsafeFunction);
    }

    public static <R, E extends Throwable> List<R> transformToList(long[] array, UnsafeFunction<Long, R, E> unsafeFunction) {
        return TransformUtil.transformToList((long[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> long[] transformToLongArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToLongArray(collection, unsafeFunction);
    }

    public static <T, E extends Throwable> long[] transformToLongArray(T[] array, UnsafeFunction<T, Long, E> unsafeFunction) {
        return TransformUtil.transformToLongArray((Object[])array, unsafeFunction);
    }

    public static <T, E extends Throwable> short[] transformToShortArray(Collection<T> collection, UnsafeFunction<T, Short, E> unsafeFunction) {
        return TransformUtil.transformToShortArray(collection, unsafeFunction);
    }

    public static <T, E extends Throwable> short[] transformToShortArray(T[] array, UnsafeFunction<T, Short, E> unsafeFunction) {
        return TransformUtil.transformToShortArray((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransform(collection, unsafeFunction);
    }

    public static <R, E extends Throwable> R[] unsafeTransform(int[] array, UnsafeFunction<Integer, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        return TransformUtil.unsafeTransform((int[])array, unsafeFunction, clazz);
    }

    public static <R, E extends Throwable> R[] unsafeTransform(long[] array, UnsafeFunction<Long, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        return TransformUtil.unsafeTransform((long[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        return TransformUtil.unsafeTransform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
    }

    public static <T, E extends Throwable> boolean[] unsafeTransformToBooleanArray(Collection<T> collection, UnsafeFunction<T, Boolean, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToBooleanArray(collection, unsafeFunction);
    }

    public static <T, E extends Throwable> boolean[] unsafeTransformToBooleanArray(T[] array, UnsafeFunction<T, Boolean, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToBooleanArray((Object[])array, unsafeFunction);
    }

    public static <T, E extends Throwable> byte[] unsafeTransformToByteArray(Collection<T> collection, UnsafeFunction<T, Byte, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToByteArray(collection, unsafeFunction);
    }

    public static <T, E extends Throwable> byte[] unsafeTransformToByteArray(T[] array, UnsafeFunction<T, Byte, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToByteArray((Object[])array, unsafeFunction);
    }

    public static <T, E extends Throwable> double[] unsafeTransformToDoubleArray(Collection<T> collection, UnsafeFunction<T, Double, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToDoubleArray(collection, unsafeFunction);
    }

    public static <T, E extends Throwable> double[] unsafeTransformToDoubleArray(T[] array, UnsafeFunction<T, Double, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToDoubleArray((Object[])array, unsafeFunction);
    }

    public static <T, E extends Throwable> float[] unsafeTransformToFloatArray(Collection<T> collection, UnsafeFunction<T, Float, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToFloatArray(collection, unsafeFunction);
    }

    public static <T, E extends Throwable> float[] unsafeTransformToFloatArray(T[] array, UnsafeFunction<T, Float, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToFloatArray((Object[])array, unsafeFunction);
    }

    public static <T, R, E extends Throwable> int[] unsafeTransformToIntArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToIntArray(collection, unsafeFunction);
    }

    public static <T, E extends Throwable> int[] unsafeTransformToIntArray(T[] array, UnsafeFunction<T, Integer, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToIntArray((Object[])array, unsafeFunction);
    }

    public static <R, E extends Throwable> List<R> unsafeTransformToList(int[] array, UnsafeFunction<Integer, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((int[])array, unsafeFunction);
    }

    public static <R, E extends Throwable> List<R> unsafeTransformToList(long[] array, UnsafeFunction<Long, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((long[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> long[] unsafeTransformToLongArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToLongArray(collection, unsafeFunction);
    }

    public static <T, E extends Throwable> long[] unsafeTransformToLongArray(T[] array, UnsafeFunction<T, Long, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToLongArray((Object[])array, unsafeFunction);
    }

    public static <T, E extends Throwable> short[] unsafeTransformToShortArray(Collection<T> collection, UnsafeFunction<T, Short, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToShortArray(collection, unsafeFunction);
    }

    public static <T, E extends Throwable> short[] unsafeTransformToShortArray(T[] array, UnsafeFunction<T, Short, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToShortArray((Object[])array, unsafeFunction);
    }
}

