/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.asset.library.internal.dto.v1_0.converter;

import com.liferay.depot.model.DepotEntryGroupRel;
import com.liferay.depot.service.DepotEntryGroupRelLocalService;
import com.liferay.headless.asset.library.dto.v1_0.ConnectedSite;
import com.liferay.headless.asset.library.internal.resource.v1_0.BaseConnectedSiteResourceImpl;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.JaxRsLinkUtil;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DTOConverter.class})
public class ConnectedSiteDTOConverter
implements DTOConverter<DepotEntryGroupRel, ConnectedSite> {
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private DepotEntryGroupRelLocalService _depotEntryGroupRelLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Portal _portal;

    public String getContentType() {
        return ConnectedSite.class.getSimpleName();
    }

    public String getJaxRsLink(long classPK, UriInfo uriInfo) {
        return JaxRsLinkUtil.getJaxRsLink((String)"headless-asset-library", BaseConnectedSiteResourceImpl.class, (String)"getAssetLibrarySite", (UriInfo)uriInfo, (Object[])new Object[]{classPK});
    }

    public ConnectedSite toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final DepotEntryGroupRel depotEntryGroupRel = this._depotEntryGroupRelLocalService.getDepotEntryGroupRel(((Long)dtoConverterContext.getId()).longValue());
        final Group group = this._groupLocalService.getGroup(depotEntryGroupRel.getToGroupId());
        return new ConnectedSite(){
            {
                this.setDescriptiveName(() -> group.getDescriptiveName(dtoConverterContext.getLocale()));
                this.setDescriptiveName_i18n(() -> LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)group.getDescriptiveNameMap()));
                this.setExternalReferenceCode(() -> ((Group)group).getExternalReferenceCode());
                this.setId(() -> ((Group)group).getGroupId());
                this.setLogo(() -> {
                    ThemeDisplay themeDisplay = new ThemeDisplay(){
                        {
                            this.setCompany(ConnectedSiteDTOConverter.this._companyLocalService.getCompany(group.getCompanyId()));
                            this.setPathImage(ConnectedSiteDTOConverter.this._portal.getPathImage());
                        }
                    };
                    return group.getLogoURL(themeDisplay, true);
                });
                this.setName(() -> group.getName(dtoConverterContext.getLocale()));
                this.setName_i18n(() -> LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)group.getNameMap()));
                this.setSearchable(() -> ((DepotEntryGroupRel)depotEntryGroupRel).isSearchable());
            }
        };
    }
}

