/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.content.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.admin.content.dto.v1_0.DisplayPageTemplateSettings;
import com.liferay.headless.delivery.dto.v1_0.Creator;
import com.liferay.headless.delivery.dto.v1_0.CustomField;
import com.liferay.headless.delivery.dto.v1_0.PageDefinition;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="Represents a Display Page Template that has fields and is tied to a content type", value="DisplayPageTemplate")
@Schema(description="Represents a Display Page Template that has fields and is tied to a content type", requiredProperties={"title"})
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="DisplayPageTemplate")
public class DisplayPageTemplate
implements Serializable {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Map<String, Map<String, String>> actions;
    @JsonIgnore
    private Supplier<Map<String, Map<String, String>>> _actionsSupplier;
    @GraphQLField(description="The list of languages the Display Page Template has a translation for.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The list of languages the Display Page Template has a translation for.") String[] availableLanguages;
    @JsonIgnore
    private Supplier<String[]> _availableLanguagesSupplier;
    @GraphQLField(description="The Display Page Template's creator.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The Display Page Template's creator.") Creator creator;
    @JsonIgnore
    private Supplier<Creator> _creatorSupplier;
    @GraphQLField(description="The custom fields associated to the page that renders the Display Page Template.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The custom fields associated to the page that renders the Display Page Template.") CustomField[] customFields;
    @JsonIgnore
    private Supplier<CustomField[]> _customFieldsSupplier;
    @GraphQLField(description="The Display Page Template's creation date.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The Display Page Template's creation date.") Date dateCreated;
    @JsonIgnore
    private Supplier<Date> _dateCreatedSupplier;
    @GraphQLField(description="The last time any field of the Display Page Template was changed.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The last time any field of the Display Page Template was changed.") Date dateModified;
    @JsonIgnore
    private Supplier<Date> _dateModifiedSupplier;
    @GraphQLField(description="The Display Page Template's external key.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The Display Page Template's external key.") String displayPageTemplateKey;
    @JsonIgnore
    private Supplier<String> _displayPageTemplateKeySupplier;
    @GraphQLField(description="The Display Page Template's external key.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The Display Page Template's external key.") DisplayPageTemplateSettings displayPageTemplateSettings;
    @JsonIgnore
    private Supplier<DisplayPageTemplateSettings> _displayPageTemplateSettingsSupplier;
    @GraphQLField(description="Specifies if the Display Page Template is the default one for the content type.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Specifies if the Display Page Template is the default one for the content type.") Boolean markedAsDefault;
    @JsonIgnore
    private Supplier<Boolean> _markedAsDefaultSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected PageDefinition pageDefinition;
    @JsonIgnore
    private Supplier<PageDefinition> _pageDefinitionSupplier;
    @GraphQLField(description="The ID of the site to which this Page Template is scoped.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The ID of the site to which this Page Template is scoped.") Long siteId;
    @JsonIgnore
    private Supplier<Long> _siteIdSupplier;
    @GraphQLField(description="The title of the Display Page Template")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotEmpty
    protected @GraphQLField(description="The title of the Display Page Template") @NotEmpty String title;
    @JsonIgnore
    private Supplier<String> _titleSupplier;
    @GraphQLField(description="A valid external identifier to reference this Display Page Template.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="A valid external identifier to reference this Display Page Template.") String uuid;
    @JsonIgnore
    private Supplier<String> _uuidSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.content.dto.v1_0.DisplayPageTemplate", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static DisplayPageTemplate toDTO(String json) {
        return (DisplayPageTemplate)ObjectMapperUtil.readValue(DisplayPageTemplate.class, (String)json);
    }

    public static DisplayPageTemplate unsafeToDTO(String json) {
        return (DisplayPageTemplate)ObjectMapperUtil.unsafeReadValue(DisplayPageTemplate.class, (String)json);
    }

    @Schema
    @Valid
    public Map<String, Map<String, String>> getActions() {
        if (this._actionsSupplier != null) {
            this.actions = this._actionsSupplier.get();
            this._actionsSupplier = null;
        }
        return this.actions;
    }

    public void setActions(Map<String, Map<String, String>> actions) {
        this.actions = actions;
        this._actionsSupplier = null;
    }

    @JsonIgnore
    public void setActions(UnsafeSupplier<Map<String, Map<String, String>>, Exception> actionsUnsafeSupplier) {
        this._actionsSupplier = () -> {
            try {
                return (Map)actionsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The list of languages the Display Page Template has a translation for.")
    public String[] getAvailableLanguages() {
        if (this._availableLanguagesSupplier != null) {
            this.availableLanguages = this._availableLanguagesSupplier.get();
            this._availableLanguagesSupplier = null;
        }
        return this.availableLanguages;
    }

    public void setAvailableLanguages(String[] availableLanguages) {
        this.availableLanguages = availableLanguages;
        this._availableLanguagesSupplier = null;
    }

    @JsonIgnore
    public void setAvailableLanguages(UnsafeSupplier<String[], Exception> availableLanguagesUnsafeSupplier) {
        this._availableLanguagesSupplier = () -> {
            try {
                return (String[])availableLanguagesUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The Display Page Template's creator.")
    @Valid
    public Creator getCreator() {
        if (this._creatorSupplier != null) {
            this.creator = this._creatorSupplier.get();
            this._creatorSupplier = null;
        }
        return this.creator;
    }

    public void setCreator(Creator creator) {
        this.creator = creator;
        this._creatorSupplier = null;
    }

    @JsonIgnore
    public void setCreator(UnsafeSupplier<Creator, Exception> creatorUnsafeSupplier) {
        this._creatorSupplier = () -> {
            try {
                return (Creator)creatorUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The custom fields associated to the page that renders the Display Page Template.")
    @Valid
    public CustomField[] getCustomFields() {
        if (this._customFieldsSupplier != null) {
            this.customFields = this._customFieldsSupplier.get();
            this._customFieldsSupplier = null;
        }
        return this.customFields;
    }

    public void setCustomFields(CustomField[] customFields) {
        this.customFields = customFields;
        this._customFieldsSupplier = null;
    }

    @JsonIgnore
    public void setCustomFields(UnsafeSupplier<CustomField[], Exception> customFieldsUnsafeSupplier) {
        this._customFieldsSupplier = () -> {
            try {
                return (CustomField[])customFieldsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The Display Page Template's creation date.")
    public Date getDateCreated() {
        if (this._dateCreatedSupplier != null) {
            this.dateCreated = this._dateCreatedSupplier.get();
            this._dateCreatedSupplier = null;
        }
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        this._dateCreatedSupplier = null;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        this._dateCreatedSupplier = () -> {
            try {
                return (Date)dateCreatedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The last time any field of the Display Page Template was changed.")
    public Date getDateModified() {
        if (this._dateModifiedSupplier != null) {
            this.dateModified = this._dateModifiedSupplier.get();
            this._dateModifiedSupplier = null;
        }
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
        this._dateModifiedSupplier = null;
    }

    @JsonIgnore
    public void setDateModified(UnsafeSupplier<Date, Exception> dateModifiedUnsafeSupplier) {
        this._dateModifiedSupplier = () -> {
            try {
                return (Date)dateModifiedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The Display Page Template's external key.")
    public String getDisplayPageTemplateKey() {
        if (this._displayPageTemplateKeySupplier != null) {
            this.displayPageTemplateKey = this._displayPageTemplateKeySupplier.get();
            this._displayPageTemplateKeySupplier = null;
        }
        return this.displayPageTemplateKey;
    }

    public void setDisplayPageTemplateKey(String displayPageTemplateKey) {
        this.displayPageTemplateKey = displayPageTemplateKey;
        this._displayPageTemplateKeySupplier = null;
    }

    @JsonIgnore
    public void setDisplayPageTemplateKey(UnsafeSupplier<String, Exception> displayPageTemplateKeyUnsafeSupplier) {
        this._displayPageTemplateKeySupplier = () -> {
            try {
                return (String)displayPageTemplateKeyUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The Display Page Template's external key.")
    @Valid
    public DisplayPageTemplateSettings getDisplayPageTemplateSettings() {
        if (this._displayPageTemplateSettingsSupplier != null) {
            this.displayPageTemplateSettings = this._displayPageTemplateSettingsSupplier.get();
            this._displayPageTemplateSettingsSupplier = null;
        }
        return this.displayPageTemplateSettings;
    }

    public void setDisplayPageTemplateSettings(DisplayPageTemplateSettings displayPageTemplateSettings) {
        this.displayPageTemplateSettings = displayPageTemplateSettings;
        this._displayPageTemplateSettingsSupplier = null;
    }

    @JsonIgnore
    public void setDisplayPageTemplateSettings(UnsafeSupplier<DisplayPageTemplateSettings, Exception> displayPageTemplateSettingsUnsafeSupplier) {
        this._displayPageTemplateSettingsSupplier = () -> {
            try {
                return (DisplayPageTemplateSettings)displayPageTemplateSettingsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="Specifies if the Display Page Template is the default one for the content type.")
    public Boolean getMarkedAsDefault() {
        if (this._markedAsDefaultSupplier != null) {
            this.markedAsDefault = this._markedAsDefaultSupplier.get();
            this._markedAsDefaultSupplier = null;
        }
        return this.markedAsDefault;
    }

    public void setMarkedAsDefault(Boolean markedAsDefault) {
        this.markedAsDefault = markedAsDefault;
        this._markedAsDefaultSupplier = null;
    }

    @JsonIgnore
    public void setMarkedAsDefault(UnsafeSupplier<Boolean, Exception> markedAsDefaultUnsafeSupplier) {
        this._markedAsDefaultSupplier = () -> {
            try {
                return (Boolean)markedAsDefaultUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public PageDefinition getPageDefinition() {
        if (this._pageDefinitionSupplier != null) {
            this.pageDefinition = this._pageDefinitionSupplier.get();
            this._pageDefinitionSupplier = null;
        }
        return this.pageDefinition;
    }

    public void setPageDefinition(PageDefinition pageDefinition) {
        this.pageDefinition = pageDefinition;
        this._pageDefinitionSupplier = null;
    }

    @JsonIgnore
    public void setPageDefinition(UnsafeSupplier<PageDefinition, Exception> pageDefinitionUnsafeSupplier) {
        this._pageDefinitionSupplier = () -> {
            try {
                return (PageDefinition)pageDefinitionUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The ID of the site to which this Page Template is scoped.")
    public Long getSiteId() {
        if (this._siteIdSupplier != null) {
            this.siteId = this._siteIdSupplier.get();
            this._siteIdSupplier = null;
        }
        return this.siteId;
    }

    public void setSiteId(Long siteId) {
        this.siteId = siteId;
        this._siteIdSupplier = null;
    }

    @JsonIgnore
    public void setSiteId(UnsafeSupplier<Long, Exception> siteIdUnsafeSupplier) {
        this._siteIdSupplier = () -> {
            try {
                return (Long)siteIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The title of the Display Page Template")
    public String getTitle() {
        if (this._titleSupplier != null) {
            this.title = this._titleSupplier.get();
            this._titleSupplier = null;
        }
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this._titleSupplier = null;
    }

    @JsonIgnore
    public void setTitle(UnsafeSupplier<String, Exception> titleUnsafeSupplier) {
        this._titleSupplier = () -> {
            try {
                return (String)titleUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="A valid external identifier to reference this Display Page Template.")
    public String getUuid() {
        if (this._uuidSupplier != null) {
            this.uuid = this._uuidSupplier.get();
            this._uuidSupplier = null;
        }
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
        this._uuidSupplier = null;
    }

    @JsonIgnore
    public void setUuid(UnsafeSupplier<String, Exception> uuidUnsafeSupplier) {
        this._uuidSupplier = () -> {
            try {
                return (String)uuidUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DisplayPageTemplate)) {
            return false;
        }
        DisplayPageTemplate displayPageTemplate = (DisplayPageTemplate)object;
        return Objects.equals(this.toString(), displayPageTemplate.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        String uuid;
        String title;
        Long siteId;
        PageDefinition pageDefinition;
        Boolean markedAsDefault;
        DisplayPageTemplateSettings displayPageTemplateSettings;
        String displayPageTemplateKey;
        Date dateModified;
        Date dateCreated;
        CustomField[] customFields;
        Creator creator;
        String[] availableLanguages;
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        Map<String, Map<String, String>> actions = this.getActions();
        if (actions != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"actions\": ");
            sb.append(DisplayPageTemplate._toJSON(actions));
        }
        if ((availableLanguages = this.getAvailableLanguages()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"availableLanguages\": ");
            sb.append("[");
            for (int i = 0; i < availableLanguages.length; ++i) {
                sb.append("\"");
                sb.append(DisplayPageTemplate._escape(availableLanguages[i]));
                sb.append("\"");
                if (i + 1 >= availableLanguages.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((creator = this.getCreator()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creator\": ");
            sb.append((Object)creator);
        }
        if ((customFields = this.getCustomFields()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"customFields\": ");
            sb.append("[");
            for (int i = 0; i < customFields.length; ++i) {
                sb.append((Object)customFields[i]);
                if (i + 1 >= customFields.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((dateCreated = this.getDateCreated()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(dateCreated));
            sb.append("\"");
        }
        if ((dateModified = this.getDateModified()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(dateModified));
            sb.append("\"");
        }
        if ((displayPageTemplateKey = this.getDisplayPageTemplateKey()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"displayPageTemplateKey\": ");
            sb.append("\"");
            sb.append(DisplayPageTemplate._escape(displayPageTemplateKey));
            sb.append("\"");
        }
        if ((displayPageTemplateSettings = this.getDisplayPageTemplateSettings()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"displayPageTemplateSettings\": ");
            sb.append(String.valueOf(displayPageTemplateSettings));
        }
        if ((markedAsDefault = this.getMarkedAsDefault()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"markedAsDefault\": ");
            sb.append((Object)markedAsDefault);
        }
        if ((pageDefinition = this.getPageDefinition()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"pageDefinition\": ");
            sb.append((Object)pageDefinition);
        }
        if ((siteId = this.getSiteId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"siteId\": ");
            sb.append((Object)siteId);
        }
        if ((title = this.getTitle()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"title\": ");
            sb.append("\"");
            sb.append(DisplayPageTemplate._escape(title));
            sb.append("\"");
        }
        if ((uuid = this.getUuid()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"uuid\": ");
            sb.append("\"");
            sb.append(DisplayPageTemplate._escape(uuid));
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(DisplayPageTemplate._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (DisplayPageTemplate._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(DisplayPageTemplate._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(DisplayPageTemplate._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(DisplayPageTemplate._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

