/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.internal.util;

import com.liferay.gradle.plugins.workspace.internal.util.FileUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.tasks.TaskContainer;

public class GradleUtil
extends com.liferay.gradle.util.GradleUtil {
    private static final String _DEFAULT_REPOSITORY_URL = "https://repository-cdn.liferay.com/nexus/content/groups/public";
    private static final String _REPOSITORY_URL = "https://repository.liferay.com/nexus/content/groups/public";

    public static void addDefaultRepositories(Project project) {
        RepositoryHandler repositoryHandler = project.getRepositories();
        repositoryHandler.maven((Action)new Action<MavenArtifactRepository>(){

            public void execute(MavenArtifactRepository mavenArtifactRepository) {
                mavenArtifactRepository.setUrl((Object)GradleUtil._DEFAULT_REPOSITORY_URL);
            }
        });
        repositoryHandler.mavenCentral();
        repositoryHandler.maven((Action)new Action<MavenArtifactRepository>(){

            public void execute(MavenArtifactRepository mavenArtifactRepository) {
                mavenArtifactRepository.setUrl((Object)GradleUtil._REPOSITORY_URL);
            }
        });
    }

    public static String getArchivesBaseName(Project project) {
        BasePluginConvention basePluginConvention = (BasePluginConvention)GradleUtil.getConvention((Project)project, BasePluginConvention.class);
        return basePluginConvention.getArchivesBaseName();
    }

    public static String getProjectPath(File projectDir, File rootDir) {
        String projectPath = FileUtil.relativize((File)projectDir, (File)rootDir);
        return ":" + projectPath.replace(File.separatorChar, ':');
    }

    public static Object getProperty(Object object, String name) {
        try {
            Class<?> clazz = object.getClass();
            Method hasPropertyMethod = clazz.getMethod("hasProperty", String.class);
            boolean hasProperty = (Boolean)hasPropertyMethod.invoke(object, name);
            if (!hasProperty) {
                return null;
            }
            Method getPropertyMethod = clazz.getMethod("getProperty", String.class);
            Object value = getPropertyMethod.invoke(object, name);
            if (value instanceof String && Validator.isNull((String)((String)value))) {
                value = null;
            }
            return value;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new GradleException("Unable to get property", (Throwable)reflectiveOperationException);
        }
    }

    public static boolean getProperty(Object object, String name, boolean defaultValue) {
        Object value = GradleUtil.getProperty(object, name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return defaultValue;
    }

    public static String getProperty(Object object, String name, String defaultValue) {
        Object value = GradleUtil.getProperty(object, name);
        if (value == null) {
            return defaultValue;
        }
        return GradleUtil.toString((Object)value);
    }

    public static boolean hasTask(Project project, String name) {
        TaskContainer taskContainer = project.getTasks();
        return taskContainer.findByName(name) != null;
    }

    public static boolean toBoolean(Object object) {
        if ((object = GradleUtil.toObject((Object)object)) instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.parseBoolean((String)object);
        }
        return false;
    }

    public static File toFile(Project project, Object object) {
        if ((object = GradleUtil.toObject((Object)object)) == null) {
            return null;
        }
        return project.file(object);
    }

    public static URL toURL(Object url) {
        if ((url = GradleUtil.toObject((Object)url)) instanceof URL) {
            return (URL)url;
        }
        String s = GradleUtil.toString((Object)url);
        if (Validator.isNull((String)s)) {
            return null;
        }
        try {
            return new URL(GradleUtil.toString((Object)url));
        }
        catch (MalformedURLException malformedURLException) {
            throw new GradleException("Unable to parse " + s, (Throwable)malformedURLException);
        }
    }
}

