/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.internal.client.extension;

import com.liferay.gradle.plugins.css.builder.BuildCSSTask;
import com.liferay.gradle.plugins.theme.builder.BuildThemeTask;
import com.liferay.gradle.plugins.theme.builder.ThemeBuilderPlugin;
import com.liferay.gradle.plugins.workspace.LiferayWorkspaceNodePlugin;
import com.liferay.gradle.plugins.workspace.WorkspaceExtension;
import com.liferay.gradle.plugins.workspace.internal.client.extension.ClientExtensionConfigurer;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.CopySpec;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.War;

public class ThemeCSSTypeConfigurer
implements ClientExtensionConfigurer {
    @Override
    public void apply(final Project project, TaskProvider<Copy> assembleClientExtensionTaskProvider) {
        LiferayWorkspaceNodePlugin.INSTANCE.apply((Object)project);
        GradleUtil.applyPlugin((Project)project, ThemeBuilderPlugin.class);
        this._addDependenciesParentThemes(project);
        this._addDependenciesPortalCommonCSS(project);
        this._configureTaskBuildTheme(project);
        final BuildCSSTask buildCSSTask = this._configureTaskBuildCSS(project);
        War war = (War)GradleUtil.getTask((Project)project, (String)"war");
        war.setEnabled(false);
        assembleClientExtensionTaskProvider.configure((Action)new Action<Copy>(){

            public void execute(Copy copy) {
                copy.dependsOn(new Object[]{buildCSSTask});
                copy.into((Object)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return "static";
                    }
                }, (Closure)new Closure<Void>((Object)copy){

                    public void doCall(CopySpec copySpec) {
                        copySpec.from(new Object[]{new File(project.getBuildDir(), "buildTheme")});
                        copySpec.include(new String[]{"css/*.css"});
                        copySpec.into((Object)"static");
                    }
                });
            }
        });
    }

    private void _addDependenciesParentThemes(Project project) {
        GradleUtil.addDependency((Project)project, (String)"parentThemes", (String)"com.liferay", (String)"com.liferay.frontend.theme.styled", (String)"latest.release");
        GradleUtil.addDependency((Project)project, (String)"parentThemes", (String)"com.liferay", (String)"com.liferay.frontend.theme.unstyled", (String)"latest.release");
        GradleUtil.addDependency((Project)project, (String)"parentThemes", (String)"com.liferay.plugins", (String)"classic-theme", (String)"latest.release");
    }

    private void _addDependenciesPortalCommonCSS(Project project) {
        GradleUtil.addDependency((Project)project, (String)"portalCommonCSS", (String)"com.liferay", (String)"com.liferay.frontend.css.common", (String)"latest.release", (boolean)false);
    }

    private BuildCSSTask _configureTaskBuildCSS(Project project) {
        BuildCSSTask buildCSSTask = (BuildCSSTask)GradleUtil.getTask((Project)project, (String)"buildCSS");
        buildCSSTask.setOutputDirName((Object)".");
        return buildCSSTask;
    }

    private BuildThemeTask _configureTaskBuildTheme(final Project project) {
        final BuildThemeTask buildThemeTask = (BuildThemeTask)GradleUtil.getTask((Project)project, (String)"buildTheme");
        File srcDir = project.file((Object)"src");
        if (!srcDir.exists()) {
            srcDir.mkdirs();
        }
        buildThemeTask.setDiffsDir((Object)srcDir);
        File packageJsonFile = project.file((Object)"package.json");
        if (!packageJsonFile.exists()) {
            return buildThemeTask;
        }
        Map<String, Object> packageJsonMap = this._getPackageJsonMap(packageJsonFile);
        Map liferayDesignPackMap = (Map)packageJsonMap.get("liferayDesignPack");
        String baseTheme = (String)liferayDesignPackMap.get("baseTheme");
        if (baseTheme.equals("styled") || baseTheme.equals("unstyled")) {
            baseTheme = "_" + baseTheme;
        }
        buildThemeTask.setParentName((Object)baseTheme);
        final HashMap allDependencyMap = new HashMap();
        Map dependenciesMap = (Map)packageJsonMap.get("dependencies");
        Map devDependenciesMap = (Map)packageJsonMap.get("devDependencies");
        if (Objects.nonNull(dependenciesMap)) {
            allDependencyMap.putAll(dependenciesMap);
        }
        if (Objects.nonNull(devDependenciesMap)) {
            allDependencyMap.putAll(devDependenciesMap);
        }
        if (!allDependencyMap.isEmpty()) {
            buildThemeTask.dependsOn(new Object[]{"npmInstall"});
            buildThemeTask.doFirst((Action)new Action<Task>(){

                public void execute(Task task) {
                    File nodeMoudleDir;
                    WorkspaceExtension workspaceExtension = (WorkspaceExtension)GradleUtil.getExtension((ExtensionAware)project.getGradle(), WorkspaceExtension.class);
                    String nodePackageManager = workspaceExtension.getNodePackageManager();
                    if (Objects.equals(nodePackageManager, "yarn")) {
                        Project rootProject = project.getRootProject();
                        nodeMoudleDir = rootProject.file((Object)"node_modules");
                    } else {
                        nodeMoudleDir = project.file((Object)"node_modules");
                    }
                    for (final String key : allDependencyMap.keySet()) {
                        final File dependencyDir = new File(nodeMoudleDir, key);
                        if (!dependencyDir.exists()) continue;
                        project.copy((Action)new Action<CopySpec>(){

                            public void execute(CopySpec copySpec) {
                                copySpec.from(new Object[]{dependencyDir});
                                copySpec.into((Object)(buildThemeTask.getOutputDir() + "/css/" + key));
                                copySpec.setIncludeEmptyDirs(false);
                            }
                        });
                    }
                }
            });
        }
        return buildThemeTask;
    }

    private Map<String, Object> _getPackageJsonMap(File packageJsonFile) {
        if (!packageJsonFile.exists()) {
            return Collections.emptyMap();
        }
        JsonSlurper jsonSlurper = new JsonSlurper();
        return (Map)jsonSlurper.parse(packageJsonFile);
    }
}

