/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.source.formatter;

import com.liferay.gradle.plugins.source.formatter.FormatSourceTask;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.file.FileCollection;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;

public class SourceFormatterPlugin
implements Plugin<Project> {
    public static final String CHECK_SOURCE_FORMATTING_TASK_NAME = "checkSourceFormatting";
    public static final String CONFIGURATION_NAME = "sourceFormatter";
    public static final String FORMAT_SOURCE_TASK_NAME = "formatSource";
    private static final Spec<Task> _skipIfExecutingParentTaskSpec = new Spec<Task>(){

        public boolean isSatisfiedBy(Task task) {
            Project project = task.getProject();
            Gradle gradle = project.getGradle();
            TaskExecutionGraph taskExecutionGraph = gradle.getTaskGraph();
            Project parentProject = project;
            while ((parentProject = parentProject.getParent()) != null) {
                TaskContainer parentProjectTaskContainer = parentProject.getTasks();
                Task parentProjectTask = (Task)parentProjectTaskContainer.findByName(task.getName());
                if (parentProjectTask == null || !taskExecutionGraph.hasTask(parentProjectTask)) continue;
                return false;
            }
            return true;
        }
    };

    public void apply(Project project) {
        Configuration sourceFormatterConfiguration = this._addConfigurationSourceFormatter(project);
        this._addTaskCheckSourceFormatting(project);
        this._addTaskFormatSource(project);
        this._configureTasksFormatSource(project, (FileCollection)sourceFormatterConfiguration);
    }

    private Configuration _addConfigurationSourceFormatter(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                SourceFormatterPlugin.this._addDependenciesSourceFormatter(project);
            }
        });
        configuration.setDescription("Configures Liferay Source Formatter for this project.");
        configuration.setVisible(false);
        return configuration;
    }

    private void _addDependenciesSourceFormatter(Project project) {
        GradleUtil.addDependency((Project)project, (String)CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.source.formatter", (String)"latest.release");
    }

    private FormatSourceTask _addTaskCheckSourceFormatting(Project project) {
        FormatSourceTask formatSourceTask = (FormatSourceTask)GradleUtil.addTask((Project)project, (String)CHECK_SOURCE_FORMATTING_TASK_NAME, FormatSourceTask.class);
        formatSourceTask.onlyIf(_skipIfExecutingParentTaskSpec);
        formatSourceTask.setAutoFix(false);
        formatSourceTask.setDescription("Checks the source formatting of this project.");
        formatSourceTask.setFailOnAutoFix(true);
        formatSourceTask.setFailOnHasWarning(true);
        formatSourceTask.setGroup("verification");
        formatSourceTask.setPrintErrors(true);
        return formatSourceTask;
    }

    private FormatSourceTask _addTaskFormatSource(Project project) {
        FormatSourceTask formatSourceTask = (FormatSourceTask)GradleUtil.addTask((Project)project, (String)FORMAT_SOURCE_TASK_NAME, FormatSourceTask.class);
        formatSourceTask.onlyIf(_skipIfExecutingParentTaskSpec);
        formatSourceTask.setDescription("Runs Liferay Source Formatter to format the project files.");
        formatSourceTask.setGroup("formatting");
        return formatSourceTask;
    }

    private void _configureTaskFormatSource(FormatSourceTask formatSourceTask, FileCollection classpath) {
        String sourceBaseDir;
        String javaParserEnabled;
        String formatLocalChanges;
        String formatLatestAuthor;
        String formatCurrentBranch;
        String fileNames;
        String fileExtensions;
        formatSourceTask.setClasspath(classpath);
        String checkNames = GradleUtil.getTaskPrefixedProperty((Task)formatSourceTask, (String)"source.check.names");
        if (Validator.isNotNull((String)checkNames)) {
            formatSourceTask.setCheckNames(checkNames.split(","));
        }
        if (Validator.isNotNull((String)(fileExtensions = GradleUtil.getTaskPrefixedProperty((Task)formatSourceTask, (String)"file.extensions")))) {
            formatSourceTask.setFileExtensions(fileExtensions.split(","));
        }
        if (Validator.isNotNull((String)(fileNames = GradleUtil.getTaskPrefixedProperty((Task)formatSourceTask, (String)"file.names")))) {
            formatSourceTask.setFileNames(fileNames.split(","));
        }
        if (Validator.isNotNull((String)(formatCurrentBranch = GradleUtil.getTaskPrefixedProperty((Task)formatSourceTask, (String)"format.current.branch")))) {
            formatSourceTask.setFormatCurrentBranch(Boolean.parseBoolean(formatCurrentBranch));
        }
        if (Validator.isNotNull((String)(formatLatestAuthor = GradleUtil.getTaskPrefixedProperty((Task)formatSourceTask, (String)"format.latest.author")))) {
            formatSourceTask.setFormatLatestAuthor(Boolean.parseBoolean(formatLatestAuthor));
        }
        if (Validator.isNotNull((String)(formatLocalChanges = GradleUtil.getTaskPrefixedProperty((Task)formatSourceTask, (String)"format.local.changes")))) {
            formatSourceTask.setFormatLocalChanges(Boolean.parseBoolean(formatLocalChanges));
        }
        if (Validator.isNotNull((String)(javaParserEnabled = GradleUtil.getTaskPrefixedProperty((Task)formatSourceTask, (String)"java.parser.enabled")))) {
            formatSourceTask.setJavaParserEnabled(Boolean.parseBoolean(javaParserEnabled));
        }
        if (Validator.isNotNull((String)(sourceBaseDir = GradleUtil.getTaskPrefixedProperty((Task)formatSourceTask, (String)"source.base.dir")))) {
            formatSourceTask.setBaseDirName(sourceBaseDir);
        }
    }

    private void _configureTasksFormatSource(Project project, final FileCollection classpath) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(FormatSourceTask.class, (Action)new Action<FormatSourceTask>(){

            public void execute(FormatSourceTask formatSourceTask) {
                SourceFormatterPlugin.this._configureTaskFormatSource(formatSourceTask, classpath);
            }
        });
    }
}

