/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.npm;

import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackageDependency;
import com.liferay.frontend.js.loader.modules.extender.npm.ModuleNameUtil;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMRegistry;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolver;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.osgi.framework.Bundle;

public class NPMResolverImpl
implements NPMResolver {
    private final String _jsPackageIdentifier;
    private final NPMRegistry _npmRegistry;
    private final Map<String, String> _packageNamesMap;

    public NPMResolverImpl(Bundle bundle, NPMRegistry npmRegistry, JSONObject packageJSONObject, JSONObject packagesJSONObject) {
        this._npmRegistry = npmRegistry;
        this._jsPackageIdentifier = this._resolveJSPackageIdentifier(bundle, packageJSONObject);
        this._packageNamesMap = this._loadPackageNamesMap(packagesJSONObject);
    }

    public JSPackage getDependencyJSPackage(String packageName) {
        JSPackageDependency jsPackageDependency;
        JSPackage jsPackage = this.getJSPackage();
        String destPackageName = this._packageNamesMap.get(packageName);
        if (Validator.isNull((String)destPackageName)) {
            destPackageName = packageName;
        }
        if ((jsPackageDependency = jsPackage.getJSPackageDependency(destPackageName)) == null) {
            return null;
        }
        return this._npmRegistry.resolveJSPackageDependency(jsPackageDependency);
    }

    public JSPackage getJSPackage() {
        return this._npmRegistry.getJSPackage(this._jsPackageIdentifier);
    }

    public String resolveModuleName(String moduleName) {
        JSPackage jsPackage;
        String packageName = ModuleNameUtil.getPackageName((String)moduleName);
        if (!packageName.equals((jsPackage = this.getJSPackage()).getName()) && (jsPackage = this.getDependencyJSPackage(packageName)) == null) {
            return null;
        }
        StringBundler sb = new StringBundler(3);
        sb.append(jsPackage.getResolvedId());
        String packagePath = ModuleNameUtil.getPackagePath((String)moduleName);
        if (packagePath != null) {
            sb.append("/");
            sb.append(packagePath);
        }
        return sb.toString();
    }

    private Map<String, String> _loadPackageNamesMap(JSONObject packagesJSONObject) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            Iterator iterator = packagesJSONObject.keys();
            while (iterator.hasNext()) {
                String packageId = (String)iterator.next();
                JSONObject packageJSONObject = packagesJSONObject.getJSONObject(packageId);
                JSONObject srcJSONObject = packageJSONObject.getJSONObject("src");
                JSONObject destJSONObject = packageJSONObject.getJSONObject("dest");
                map.put(srcJSONObject.getString("name"), destJSONObject.getString("name"));
            }
            return map;
        }
        catch (IllegalStateException illegalStateException) {
            throw illegalStateException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private String _resolveJSPackageIdentifier(Bundle bundle, JSONObject packageJSONObject) {
        try {
            StringBundler sb = new StringBundler(5);
            sb.append(bundle.getBundleId());
            sb.append("/");
            String name = packageJSONObject.getString("name");
            sb.append(name);
            sb.append("@");
            String version = packageJSONObject.getString("version");
            sb.append(version);
            return sb.toString();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

