/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.npm;

import com.github.yuchi.semver.Range;
import com.github.yuchi.semver.Version;
import com.liferay.frontend.js.loader.modules.extender.internal.JSLoaderModulesTracker;
import com.liferay.frontend.js.loader.modules.extender.npm.JSBundle;
import com.liferay.frontend.js.loader.modules.extender.npm.JSBundleProcessor;
import com.liferay.frontend.js.loader.modules.extender.npm.JSBundleTracker;
import com.liferay.frontend.js.loader.modules.extender.npm.JSModule;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackageDependency;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMRegistry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyFactory;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(immediate=true, service={NPMRegistry.class})
public class NPMRegistryImpl
implements NPMRegistry {
    private static final JSPackage _NULL_JS_PACKAGE = (JSPackage)ProxyFactory.newDummyInstance(JSPackage.class);
    private static final Log _log = LogFactoryUtil.getLog(NPMRegistryImpl.class);
    private BundleContext _bundleContext;
    private BundleTracker<JSBundle> _bundleTracker;
    private final Map<String, JSPackage> _dependencyJSPackages = new ConcurrentHashMap<String, JSPackage>();
    private final Map<String, String> _globalAliases = new HashMap<String, String>();
    private final List<JSBundleProcessor> _jsBundleProcessors = new ArrayList<JSBundleProcessor>();
    private final Map<JSBundle, Bundle> _jsBundles = new ConcurrentHashMap<JSBundle, Bundle>();
    private final Set<JSBundleTracker> _jsBundleTrackers = new ConcurrentSkipListSet<JSBundleTracker>(Comparator.comparingInt(Object::hashCode));
    @Reference
    private JSLoaderModulesTracker _jsLoaderModulesTracker;
    private Map<String, JSModule> _jsModules = new HashMap<String, JSModule>();
    @Reference
    private JSONFactory _jsonFactory;
    private Map<String, JSPackage> _jsPackages = new HashMap<String, JSPackage>();
    private List<JSPackageVersion> _jsPackageVersions = new ArrayList<JSPackageVersion>();
    private Map<String, JSModule> _resolvedJSModules = new HashMap<String, JSModule>();
    private Map<String, JSPackage> _resolvedJSPackages = new HashMap<String, JSPackage>();

    public Map<String, String> getGlobalAliases() {
        return this._globalAliases;
    }

    public Collection<JSBundle> getJSBundles() {
        return this._jsBundles.keySet();
    }

    public JSModule getJSModule(String identifier) {
        return this._jsModules.get(identifier);
    }

    public JSPackage getJSPackage(String identifier) {
        return this._jsPackages.get(identifier);
    }

    public Collection<JSPackage> getJSPackages() {
        return this._jsPackages.values();
    }

    public JSModule getResolvedJSModule(String identifier) {
        return this._resolvedJSModules.get(identifier);
    }

    public Collection<JSModule> getResolvedJSModules() {
        return this._resolvedJSModules.values();
    }

    public Collection<JSPackage> getResolvedJSPackages() {
        return this._resolvedJSPackages.values();
    }

    public JSPackage resolveJSPackageDependency(JSPackageDependency jsPackageDependency) {
        String versionConstraints;
        String packageName = jsPackageDependency.getPackageName();
        String cacheKey = StringBundler.concat((String[])new String[]{packageName, "_", versionConstraints = jsPackageDependency.getVersionConstraints()});
        JSPackage jsPackage = this._dependencyJSPackages.get(cacheKey);
        if (jsPackage != null) {
            if (jsPackage == _NULL_JS_PACKAGE) {
                return null;
            }
            return jsPackage;
        }
        Range range = Range.from((Object)versionConstraints, (boolean)true);
        for (JSPackageVersion jsPackageVersion : this._jsPackageVersions) {
            JSPackage innerJSPackage = jsPackageVersion._jsPackage;
            Version version = jsPackageVersion._version;
            if (!packageName.equals(innerJSPackage.getName()) || !range.test(version)) continue;
            jsPackage = innerJSPackage;
            break;
        }
        if (jsPackage == null) {
            this._dependencyJSPackages.put(cacheKey, _NULL_JS_PACKAGE);
        } else {
            this._dependencyJSPackages.put(cacheKey, jsPackage);
        }
        return jsPackage;
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) throws Exception {
        if (this._bundleTracker != null) {
            this._bundleTracker.close();
        }
        this._bundleContext = bundleContext;
        this._bundleTracker = new BundleTracker(this._bundleContext, 32, (BundleTrackerCustomizer)new NPMRegistryBundleTrackerCustomizer());
        this._bundleTracker.open();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected synchronized void bindBundleProcessor(JSBundleProcessor jsBundleProcessor) {
        this._jsBundleProcessors.add(jsBundleProcessor);
        this._reopenBundleTracker();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindJSBundleTracker(JSBundleTracker jsBundleTracker) {
        this._jsBundleTrackers.add(jsBundleTracker);
        for (Map.Entry<JSBundle, Bundle> entry : this._jsBundles.entrySet()) {
            try {
                jsBundleTracker.addedJSBundle(entry.getKey(), entry.getValue(), (NPMRegistry)this);
            }
            catch (Exception e) {
                _log.error((Object)"Unable to add JS bundle", (Throwable)e);
            }
        }
    }

    @Deactivate
    protected synchronized void deactivate() {
        this._bundleTracker.close();
        this._bundleTracker = null;
    }

    protected synchronized void unbindBundleProcessor(JSBundleProcessor jsBundleProcessor) {
        this._jsBundleProcessors.remove(jsBundleProcessor);
        this._reopenBundleTracker();
    }

    protected void unbindJSBundleTracker(JSBundleTracker jsBundleTracker) {
        this._jsBundleTrackers.remove(jsBundleTracker);
    }

    private JSONObject _getPackageJSONObject(Bundle bundle) {
        try {
            String content;
            URL url = bundle.getResource("package.json");
            if (url == null) {
                return null;
            }
            try {
                content = StringUtil.read((InputStream)url.openStream());
            }
            catch (IOException ioe) {
                return null;
            }
            if (content == null) {
                return null;
            }
            return this._jsonFactory.createJSONObject(content);
        }
        catch (Exception e) {
            return null;
        }
    }

    private synchronized JSBundle _processBundle(Bundle bundle) {
        for (JSBundleProcessor jsBundleProcessor : this._jsBundleProcessors) {
            JSBundle jsBundle = jsBundleProcessor.process(bundle);
            if (jsBundle == null) continue;
            this._jsBundles.put(jsBundle, bundle);
            this._processLegacyBridges(bundle);
            this._refreshJSModuleCaches();
            if (jsBundle != null) {
                for (JSBundleTracker jsBundleTracker : this._jsBundleTrackers) {
                    try {
                        jsBundleTracker.addedJSBundle(jsBundle, bundle, (NPMRegistry)this);
                    }
                    catch (Exception e) {
                        _log.error((Object)"Unable to add JS bundle", (Throwable)e);
                    }
                }
            }
            return jsBundle;
        }
        return null;
    }

    private void _processLegacyBridges(Bundle bundle) {
        Dictionary headers = bundle.getHeaders("");
        String jsSubmodulesBridge = GetterUtil.getString((String)((String)headers.get("Liferay-JS-Submodules-Bridge")));
        if (Validator.isNotNull((String)jsSubmodulesBridge)) {
            String[] bridges = jsSubmodulesBridge.split(",");
            JSONObject packageJSONObject = this._getPackageJSONObject(bundle);
            for (String bridge : bridges) {
                bridge = bridge.trim();
                StringBundler sb = new StringBundler(5);
                sb.append(packageJSONObject.getString("name"));
                sb.append("@");
                sb.append(packageJSONObject.getString("version"));
                sb.append("/bridge/");
                sb.append(bridge);
                this._globalAliases.put(bridge, sb.toString());
            }
        }
    }

    private synchronized void _refreshJSModuleCaches() {
        this._dependencyJSPackages.clear();
        HashMap<String, JSModule> jsModules = new HashMap<String, JSModule>();
        HashMap<String, JSPackage> jsPackages = new HashMap<String, JSPackage>();
        ArrayList<JSPackageVersion> jsPackageVersions = new ArrayList<JSPackageVersion>();
        HashMap<String, JSModule> resolvedJSModules = new HashMap<String, JSModule>();
        HashMap<String, JSPackage> resolvedJSPackages = new HashMap<String, JSPackage>();
        for (JSBundle jsBundle : this._jsBundles.keySet()) {
            for (JSPackage jsPackage : jsBundle.getJSPackages()) {
                jsPackages.put(jsPackage.getId(), jsPackage);
                jsPackageVersions.add(new JSPackageVersion(jsPackage));
                resolvedJSPackages.put(jsPackage.getResolvedId(), jsPackage);
                for (JSModule jsModule : jsPackage.getJSModules()) {
                    jsModules.put(jsModule.getId(), jsModule);
                    resolvedJSModules.put(jsModule.getResolvedId(), jsModule);
                }
            }
        }
        Comparator<JSPackageVersion> comparator = Comparator.comparing(JSPackageVersion::getVersion);
        jsPackageVersions.sort(comparator.reversed());
        this._jsModules = jsModules;
        this._jsPackages = jsPackages;
        this._jsPackageVersions = jsPackageVersions;
        this._resolvedJSModules = resolvedJSModules;
        this._resolvedJSPackages = resolvedJSPackages;
        this._jsLoaderModulesTracker.updateLastModified();
    }

    private synchronized boolean _removeBundle(JSBundle jsBundle) {
        Bundle bundle = this._jsBundles.get(jsBundle);
        if (bundle == null) {
            return false;
        }
        this._jsBundles.remove(jsBundle);
        this._refreshJSModuleCaches();
        for (JSBundleTracker jsBundleTracker : this._jsBundleTrackers) {
            try {
                jsBundleTracker.removedJSBundle(jsBundle, bundle, (NPMRegistry)this);
            }
            catch (Exception e) {
                _log.error((Object)"Unable to remove JS bundle", (Throwable)e);
            }
        }
        return true;
    }

    private synchronized void _reopenBundleTracker() {
        if (this._bundleTracker != null) {
            this._bundleTracker.close();
            this._bundleTracker.open();
        }
    }

    private class NPMRegistryBundleTrackerCustomizer
    implements BundleTrackerCustomizer<JSBundle> {
        private NPMRegistryBundleTrackerCustomizer() {
        }

        public JSBundle addingBundle(Bundle bundle, BundleEvent bundleEvent) {
            return NPMRegistryImpl.this._processBundle(bundle);
        }

        public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, JSBundle jsBundle) {
        }

        public void removedBundle(Bundle bundle, BundleEvent bundleEvent, JSBundle jsBundle) {
            NPMRegistryImpl.this._removeBundle(jsBundle);
        }
    }

    private static class JSPackageVersion {
        private final JSPackage _jsPackage;
        private final Version _version;

        public Version getVersion() {
            return this._version;
        }

        private JSPackageVersion(JSPackage jsPackage) {
            this._jsPackage = jsPackage;
            this._version = Version.from((Object)jsPackage.getVersion(), (boolean)true);
        }
    }
}

