/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.config.generator;

import aQute.lib.converter.Converter;
import com.liferay.frontend.js.loader.modules.extender.internal.Details;
import com.liferay.frontend.js.loader.modules.extender.internal.config.generator.JSConfigGeneratorPackage;
import com.liferay.osgi.util.ServiceTrackerFactory;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(configurationPid={"com.liferay.frontend.js.loader.modules.extender.internal.Details"}, immediate=true, service={JSConfigGeneratorPackagesTracker.class})
public class JSConfigGeneratorPackagesTracker
implements ServiceTrackerCustomizer<ServletContext, ServiceReference<ServletContext>> {
    private volatile Details _details;
    private final Map<ServiceReference<ServletContext>, JSConfigGeneratorPackage> _jsConfigGeneratorPackages = new ConcurrentSkipListMap<ServiceReference<ServletContext>, JSConfigGeneratorPackage>();
    private volatile long _lastModified = System.currentTimeMillis();
    private ServiceTracker<ServletContext, ServiceReference<ServletContext>> _serviceTracker;

    @Activate
    @Modified
    public void activate(ComponentContext componentContext, Map<String, Object> properties) throws Exception {
        if (this._serviceTracker != null) {
            this._serviceTracker.close();
        }
        this.setDetails(Converter.cnv(Details.class, properties));
        this._jsConfigGeneratorPackages.clear();
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)componentContext.getBundleContext(), (String)("(&(objectClass=" + ServletContext.class.getName() + ")(osgi.web.contextpath=*))"), (ServiceTrackerCustomizer)this);
    }

    public ServiceReference<ServletContext> addingService(ServiceReference<ServletContext> serviceReference) {
        String contextPath = (String)serviceReference.getProperty("osgi.web.contextpath");
        Bundle bundle = serviceReference.getBundle();
        URL url = bundle.getEntry("META-INF/config.json");
        if (url == null) {
            return serviceReference;
        }
        JSConfigGeneratorPackage jsConfigGeneratorPackage = new JSConfigGeneratorPackage(this._details.applyVersioning(), serviceReference.getBundle(), contextPath);
        this._jsConfigGeneratorPackages.put(serviceReference, jsConfigGeneratorPackage);
        this._lastModified = System.currentTimeMillis();
        return serviceReference;
    }

    public Collection<JSConfigGeneratorPackage> getJSConfigGeneratorPackages() {
        return this._jsConfigGeneratorPackages.values();
    }

    public long getLastModified() {
        return this._lastModified;
    }

    public long getTrackingCount() {
        return this._serviceTracker.getTrackingCount();
    }

    public void modifiedService(ServiceReference<ServletContext> serviceReference, ServiceReference<ServletContext> trackedServiceReference) {
        this.removedService(serviceReference, trackedServiceReference);
        this.addingService(serviceReference);
    }

    public void removedService(ServiceReference<ServletContext> serviceReference, ServiceReference<ServletContext> trackedServiceReference) {
        this._jsConfigGeneratorPackages.remove(serviceReference);
        this._lastModified = System.currentTimeMillis();
    }

    public void setDetails(Details details) {
        this._details = details;
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
        this._serviceTracker = null;
    }
}

