/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal;

import com.liferay.frontend.js.loader.modules.extender.internal.Details;
import com.liferay.frontend.js.loader.modules.extender.internal.JSLoaderModule;
import com.liferay.frontend.js.loader.modules.extender.internal.JSLoaderModulesPortalWebResources;
import com.liferay.frontend.js.loader.modules.extender.internal.JSLoaderModulesTracker;
import com.liferay.frontend.js.loader.modules.extender.internal.Minifier;
import com.liferay.frontend.js.loader.modules.extender.npm.JSModule;
import com.liferay.frontend.js.loader.modules.extender.npm.JSModuleAlias;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackageDependency;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMRegistry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.frontend.js.loader.modules.extender.internal.Details"}, immediate=true, property={"osgi.http.whiteboard.servlet.name=com.liferay.frontend.js.loader.modules.extender.internal.JSLoaderModulesServlet", "osgi.http.whiteboard.servlet.pattern=/js_loader_modules", "service.ranking:Integer=2147482647"}, service={JSLoaderModulesServlet.class, Servlet.class})
public class JSLoaderModulesServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(JSLoaderModulesServlet.class);
    private ComponentContext _componentContext;
    private final Map<String, String> _dependencyAliases = new HashMap<String, String>();
    private volatile Details _details;
    private JSLoaderModulesTracker _jsLoaderModulesTracker;
    private volatile ObjectValuePair<Long, String> _lastServedContent = new ObjectValuePair((Object)0L, null);
    @Reference
    private Minifier _minifier;
    private NPMRegistry _npmRegistry;
    @Reference
    private Portal _portal;

    public JSLoaderModulesServlet() {
        this._dependencyAliases.put("exports", "E");
        this._dependencyAliases.put("module", "M");
        this._dependencyAliases.put("require", "R");
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this._componentContext.enableComponent(JSLoaderModulesPortalWebResources.class.getName());
    }

    @Activate
    @Modified
    protected void activate(ComponentContext componentContext, Map<String, Object> properties) throws Exception {
        this._details = (Details)ConfigurableUtil.createConfigurable(Details.class, properties);
        this._componentContext = componentContext;
    }

    protected JSLoaderModulesTracker getJSLoaderModulesTracker() {
        return this._jsLoaderModulesTracker;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String query = request.getParameter("query");
        if (Validator.isNotNull((String)query)) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            this._writeModules(printWriter, query, false);
            printWriter.close();
            this._writeResponse(response, stringWriter.toString());
            return;
        }
        if (!this._isLastServedContentStale()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Serving cached js_loader_modules");
            }
            this._writeResponse(response, (String)this._lastServedContent.getValue());
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Generating js_loader_modules");
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("(function() {");
        this._writePaths(printWriter);
        this._writeModules(printWriter);
        this._writeMaps(printWriter);
        printWriter.println("}());");
        printWriter.close();
        String content = this._minifier.minify("/o/js_loader_modules", stringWriter.toString());
        this._lastServedContent = new ObjectValuePair((Object)this._jsLoaderModulesTracker.getLastModified(), (Object)content);
        this._writeResponse(response, content);
    }

    protected void setDetails(Details details) {
        this._details = details;
    }

    @Reference(unbind="-")
    protected void setJSLoaderModulesTracker(JSLoaderModulesTracker jsLoaderModulesTracker) {
        this._jsLoaderModulesTracker = jsLoaderModulesTracker;
    }

    @Reference(unbind="-")
    protected void setNPMRegistry(NPMRegistry npmRegistry) {
        this._npmRegistry = npmRegistry;
    }

    private String _applyDependencyAliases(String dependency) {
        String dependencyAlias = this._dependencyAliases.get(dependency);
        if (dependencyAlias == null) {
            return "\"" + dependency + "\"";
        }
        return dependencyAlias;
    }

    private boolean _isLastServedContentStale() {
        return this._jsLoaderModulesTracker.getLastModified() > (Long)this._lastServedContent.getKey();
    }

    private void _writeMaps(PrintWriter printWriter) {
        printWriter.println("Liferay.MAPS = {");
        String delimiter = "";
        HashSet<String> processedNames = new HashSet<String>();
        for (JSLoaderModule jsLoaderModule : this._jsLoaderModulesTracker.getJSLoaderModules()) {
            if (processedNames.contains(jsLoaderModule.getName())) continue;
            processedNames.add(jsLoaderModule.getName());
            printWriter.write(delimiter);
            printWriter.write("\"");
            printWriter.write(jsLoaderModule.getName());
            printWriter.write("\": \"");
            printWriter.write(jsLoaderModule.getName());
            printWriter.write("@");
            printWriter.write(jsLoaderModule.getVersion());
            printWriter.write("\"");
            delimiter = ",\n";
            String unversionedMapsConfiguration = jsLoaderModule.getUnversionedMapsConfiguration();
            if (unversionedMapsConfiguration.equals("")) continue;
            printWriter.write(delimiter);
            printWriter.write(unversionedMapsConfiguration);
        }
        for (JSPackage jsPackage : this._npmRegistry.getResolvedJSPackages()) {
            printWriter.write(delimiter);
            printWriter.write("\"");
            printWriter.write(jsPackage.getResolvedId());
            printWriter.write("\": {exactMatch: true, value: \"");
            printWriter.write(jsPackage.getResolvedId());
            printWriter.write("/");
            printWriter.write(jsPackage.getMainModuleName());
            printWriter.write("\"}");
            delimiter = ",\n";
            for (JSModuleAlias jsModuleAlias : jsPackage.getJSModuleAliases()) {
                printWriter.write(delimiter);
                printWriter.write("\"");
                printWriter.write(jsPackage.getResolvedId());
                printWriter.write("/");
                printWriter.write(jsModuleAlias.getAlias());
                printWriter.write("\": {exactMatch: true, value: \"");
                printWriter.write(jsPackage.getResolvedId());
                printWriter.write("/");
                printWriter.write(jsModuleAlias.getModuleName());
                printWriter.write("\"}");
            }
        }
        Map globalAliases = this._npmRegistry.getGlobalAliases();
        for (Map.Entry alias : globalAliases.entrySet()) {
            printWriter.write(delimiter);
            printWriter.write("\"");
            printWriter.write((String)alias.getKey());
            printWriter.write("\"");
            printWriter.write(":");
            printWriter.write("\"");
            printWriter.write((String)alias.getValue());
            printWriter.write("\"");
            delimiter = ",\n";
        }
        printWriter.println("\n};");
    }

    private void _writeModules(PrintWriter printWriter) {
        String delimiter = "";
        printWriter.write("var ");
        for (Map.Entry<String, String> entry : this._dependencyAliases.entrySet()) {
            printWriter.write(delimiter);
            printWriter.write(entry.getValue());
            printWriter.write("=\"");
            printWriter.write(entry.getKey());
            printWriter.write("\"");
            delimiter = ",";
        }
        printWriter.write(";\n");
        printWriter.println("Liferay.MODULES = ");
        this._writeModules(printWriter, null, true);
        printWriter.println(";");
    }

    private void _writeModules(PrintWriter printWriter, String query, boolean applyDependencyAliases) {
        printWriter.println("{");
        HashSet<String> processedNames = new HashSet<String>();
        String delimiter = "";
        for (JSLoaderModule jsLoaderModule : this._jsLoaderModulesTracker.getJSLoaderModules()) {
            Object versionedConfiguration;
            String unversionedConfiguration;
            String name = jsLoaderModule.getName();
            if (query != null && (!name.startsWith(query) || !name.endsWith(".es")) || (unversionedConfiguration = jsLoaderModule.getUnversionedConfiguration()).length() == 0) continue;
            if (!processedNames.contains(name)) {
                processedNames.add(name);
                printWriter.write(delimiter);
                printWriter.write(unversionedConfiguration);
                delimiter = ",\n";
            }
            if (((String)(versionedConfiguration = jsLoaderModule.getVersionedConfiguration())).length() <= 0) continue;
            printWriter.write(delimiter);
            printWriter.write((String)versionedConfiguration);
            delimiter = ",\n";
        }
        String delimiter2 = "";
        for (JSModule resolvedJSModule : this._npmRegistry.getResolvedJSModules()) {
            String resolvedId = resolvedJSModule.getResolvedId();
            if (query != null && (!resolvedId.startsWith(query) || !resolvedId.endsWith(".es"))) continue;
            printWriter.write(delimiter);
            printWriter.write("\"");
            printWriter.write(resolvedId);
            printWriter.write("\": {\n");
            delimiter2 = "";
            printWriter.write("  \"dependencies\": [");
            for (String dependency : resolvedJSModule.getDependencies()) {
                printWriter.write(delimiter2);
                if (applyDependencyAliases) {
                    printWriter.write(this._applyDependencyAliases(dependency));
                } else {
                    printWriter.write("\"");
                    printWriter.write(dependency);
                    printWriter.write("\"");
                }
                delimiter2 = ", ";
            }
            printWriter.write("],\n");
            JSPackage jsPackage = resolvedJSModule.getJSPackage();
            delimiter2 = "";
            printWriter.write("  \"map\": {");
            for (String dependencyPackageName : resolvedJSModule.getDependencyPackageNames()) {
                if (dependencyPackageName == null) continue;
                printWriter.write(delimiter2);
                StringBundler aliasSB = new StringBundler(1);
                StringBundler aliasValueSB = new StringBundler();
                if (dependencyPackageName.equals(jsPackage.getName())) {
                    aliasSB.append(dependencyPackageName);
                    aliasValueSB.append(jsPackage.getResolvedId());
                } else {
                    JSPackageDependency jsPackageDependency = jsPackage.getJSPackageDependency(dependencyPackageName);
                    if (jsPackageDependency == null) {
                        aliasSB.append(dependencyPackageName);
                        aliasValueSB.append(":ERROR:Missing version constraints for ");
                        aliasValueSB.append(dependencyPackageName);
                        aliasValueSB.append(" in package.json of ");
                        aliasValueSB.append(jsPackage.getResolvedId());
                    } else {
                        JSPackage jsDependencyPackage = this._npmRegistry.resolveJSPackageDependency(jsPackageDependency);
                        if (jsDependencyPackage == null) {
                            aliasSB.append(dependencyPackageName);
                            aliasValueSB.append(":ERROR:Package ");
                            aliasValueSB.append(dependencyPackageName);
                            aliasValueSB.append(" which is a dependency of ");
                            aliasValueSB.append(jsPackage.getResolvedId());
                            aliasValueSB.append(" is not deployed in the server");
                        } else {
                            aliasSB.append(jsDependencyPackage.getName());
                            aliasValueSB.append(jsDependencyPackage.getResolvedId());
                        }
                    }
                }
                printWriter.write("\"");
                printWriter.write(aliasSB.toString());
                printWriter.write("\": \"");
                printWriter.write(aliasValueSB.toString());
                printWriter.write("\"");
                delimiter2 = ", ";
            }
            printWriter.write("}\n");
            printWriter.write("}");
            delimiter = ",\n";
        }
        printWriter.println("\n}");
    }

    private void _writePaths(PrintWriter printWriter) {
        printWriter.write("var O=\"");
        printWriter.write(this._portal.getPathModule());
        printWriter.write("/js/resolved-module/");
        printWriter.write("\";\n");
        printWriter.println("Liferay.PATHS = {");
        String delimiter = "";
        HashSet<String> processedNames = new HashSet<String>();
        for (JSLoaderModule jsLoaderModule : this._jsLoaderModulesTracker.getJSLoaderModules()) {
            printWriter.write(delimiter);
            printWriter.write("\"");
            printWriter.write(jsLoaderModule.getName());
            printWriter.write("@");
            printWriter.write(jsLoaderModule.getVersion());
            printWriter.write("\": \"");
            printWriter.write(this._portal.getPathProxy());
            printWriter.write(jsLoaderModule.getContextPath());
            printWriter.write("\"");
            if (!processedNames.contains(jsLoaderModule.getName())) {
                processedNames.add(jsLoaderModule.getName());
                printWriter.println(",");
                printWriter.write("\"");
                printWriter.write(jsLoaderModule.getName());
                printWriter.write("\": \"");
                printWriter.write(this._portal.getPathProxy());
                printWriter.write(jsLoaderModule.getContextPath());
                printWriter.write("\"");
            }
            delimiter = ",\n";
        }
        for (JSPackage resolvedJSPackage : this._npmRegistry.getResolvedJSPackages()) {
            printWriter.write(delimiter);
            printWriter.write("\"");
            printWriter.write(resolvedJSPackage.getResolvedId());
            printWriter.write("\":O+\"");
            printWriter.write(resolvedJSPackage.getResolvedId());
            printWriter.write("\"");
            delimiter = ",\n";
        }
        printWriter.println("\n};");
    }

    private void _writeResponse(HttpServletResponse response, String content) throws IOException {
        response.setContentType("text/javascript; charset=UTF-8");
        ServletOutputStream servletOutputStream = response.getOutputStream();
        PrintWriter printWriter = new PrintWriter((OutputStream)servletOutputStream, true);
        printWriter.write(content);
        printWriter.close();
    }
}

