/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.data.set.internal.serializer;

import com.liferay.client.extension.type.FDSCellRendererCET;
import com.liferay.client.extension.type.FDSFilterCET;
import com.liferay.client.extension.type.manager.CETManager;
import com.liferay.frontend.data.set.FDSEntryItemImportPolicy;
import com.liferay.frontend.data.set.action.util.FDSActionUtil;
import com.liferay.frontend.data.set.filter.FDSFilter;
import com.liferay.frontend.data.set.filter.FDSFilterRegistry;
import com.liferay.frontend.data.set.internal.serializer.BaseFDSSerializer;
import com.liferay.frontend.data.set.internal.url.FDSAPIURLBuilder;
import com.liferay.frontend.data.set.model.FDSActionDropdownItem;
import com.liferay.frontend.data.set.model.FDSSortItem;
import com.liferay.frontend.data.set.model.FDSSortItemBuilder;
import com.liferay.frontend.data.set.serializer.FDSSerializer;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItem;
import com.liferay.list.type.model.ListTypeDefinition;
import com.liferay.list.type.model.ListTypeEntry;
import com.liferay.list.type.service.ListTypeDefinitionLocalService;
import com.liferay.list.type.service.ListTypeEntryLocalService;
import com.liferay.object.entry.util.ObjectEntryThreadLocal;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.rest.dto.v1_0.ObjectEntry;
import com.liferay.object.rest.manager.v1_0.DefaultObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.DefaultObjectEntryManagerProvider;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManagerRegistry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"frontend.data.set.serializer.type=custom"}, service={FDSSerializer.class})
public class CustomFDSSerializer
extends BaseFDSSerializer
implements FDSSerializer {
    @Reference
    protected CETManager cetManager;
    @Reference
    protected FDSFilterRegistry fdsFilterRegistry;
    private static final Log _log = LogFactoryUtil.getLog(CustomFDSSerializer.class);
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private ListTypeDefinitionLocalService _listTypeDefinitionLocalService;
    @Reference
    private ListTypeEntryLocalService _listTypeEntryLocalService;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryManagerRegistry _objectEntryManagerRegistry;
    @Reference(target="(frontend.data.set.serializer.type=system)")
    private FDSSerializer _systemFDSSerializer;

    public boolean isAvailable(String fdsName, HttpServletRequest httpServletRequest) {
        ObjectEntry objectEntry = this._getObjectEntry(fdsName, this._getObjectDefinition(httpServletRequest));
        if (objectEntry == null) {
            return false;
        }
        Map properties = objectEntry.getProperties();
        if (properties.isEmpty()) {
            return false;
        }
        return this._isActive(objectEntry);
    }

    public String serializeAdditionalAPIURLParameters(String fdsName, HttpServletRequest httpServletRequest) {
        Map<String, Object> properties = this.getDataSetObjectEntryProperties(fdsName, httpServletRequest);
        return this.createFDSAPIURLBuilder(httpServletRequest, String.valueOf(properties.get("restApplication")), String.valueOf(properties.get("restEndpoint")), String.valueOf(properties.get("restSchema"))).addQueryString(String.valueOf(properties.get("additionalAPIURLParameters"))).buildQueryString();
    }

    public String serializeAPIURL(String fdsName, HttpServletRequest httpServletRequest) {
        Map<String, Object> properties = this.getDataSetObjectEntryProperties(fdsName, httpServletRequest);
        FDSAPIURLBuilder fdsAPIURLBuilder = this.createFDSAPIURLBuilder(httpServletRequest, String.valueOf(properties.get("restApplication")), String.valueOf(properties.get("restEndpoint")), String.valueOf(properties.get("restSchema")));
        List<ObjectEntry> objectEntries = this.getSortedRelatedObjectEntries(fdsName, httpServletRequest, null, "tableSectionsOrder", "dataSetToDataSetTableSections");
        if (objectEntries == null) {
            return fdsAPIURLBuilder.build();
        }
        String nestedFields = "";
        int nestedFieldsDepth = 1;
        for (ObjectEntry objectEntry : objectEntries) {
            Map objectEntryProperties = objectEntry.getProperties();
            String[] fieldNames = StringUtil.split((String)StringUtil.replace((String)String.valueOf(objectEntryProperties.get("fieldName")), (String)"[]", (String)"."), (char)'.');
            if (fieldNames.length <= 1) continue;
            for (int i = 0; i < fieldNames.length - 1; ++i) {
                nestedFields = StringUtil.add((String)nestedFields, (String)fieldNames[i]);
            }
            if (fieldNames.length <= nestedFieldsDepth) continue;
            nestedFieldsDepth = fieldNames.length - 1;
        }
        if (nestedFields.equals("")) {
            return fdsAPIURLBuilder.build();
        }
        fdsAPIURLBuilder.addParameter("nestedFields", StringUtil.replaceLast((String)nestedFields, (char)',', (String)""));
        if (nestedFieldsDepth > 1) {
            fdsAPIURLBuilder.addParameter("nestedFieldsDepth", String.valueOf(nestedFieldsDepth));
        }
        return fdsAPIURLBuilder.build();
    }

    public List<FDSActionDropdownItem> serializeBulkActions(String fdsName, HttpServletRequest httpServletRequest) {
        return Collections.emptyList();
    }

    public CreationMenu serializeCreationMenu(String fdsName, HttpServletRequest httpServletRequest) {
        CreationMenu creationMenu = new CreationMenu();
        CreationMenu systemCreationMenu = this._systemFDSSerializer.serializeCreationMenu(fdsName, httpServletRequest);
        List systemDropdownItems = (List)systemCreationMenu.get((Object)"primaryItems");
        List customDropdownItems = TransformUtil.transform(this.getSortedRelatedObjectEntries(fdsName, httpServletRequest, objectEntry -> Objects.equals(this._getType((ObjectEntry)objectEntry), "creation") && this._isActive((ObjectEntry)objectEntry) != false, "creationActionsOrder", "dataSetToDataSetActions"), objectEntry -> {
            Map properties = objectEntry.getProperties();
            FDSActionDropdownItem fdsActionDropdownItem = new FDSActionDropdownItem(String.valueOf(properties.get("url")), String.valueOf(properties.get("icon")), FDSActionUtil.getFDSCreationActionId((String)objectEntry.getExternalReferenceCode()), String.valueOf(properties.get("label")), null, String.valueOf(properties.get("permissionKey")), String.valueOf(properties.get("target")));
            fdsActionDropdownItem.putData("disableHeader", (Object)Validator.isNull(properties.get("title")));
            fdsActionDropdownItem.putData("size", properties.get("modalSize"));
            fdsActionDropdownItem.putData("title", properties.get("title"));
            return fdsActionDropdownItem;
        });
        block0: for (DropdownItem customDropdownItem : customDropdownItems) {
            if (Objects.equals(customDropdownItem.get((Object)"target"), FDSEntryItemImportPolicy.GROUP_PROXY.toString())) {
                for (DropdownItem systemDropdownItem : systemDropdownItems) {
                    creationMenu.addPrimaryDropdownItem(systemDropdownItem);
                }
                continue;
            }
            if (Objects.equals(customDropdownItem.get((Object)"target"), FDSEntryItemImportPolicy.ITEM_PROXY.toString())) {
                for (DropdownItem systemDropdownItem : systemDropdownItems) {
                    if (!systemDropdownItem.hasSameDataId((NavigationItem)customDropdownItem)) continue;
                    creationMenu.addPrimaryDropdownItem(systemDropdownItem);
                    continue block0;
                }
                continue;
            }
            creationMenu.addPrimaryDropdownItem(customDropdownItem);
        }
        return creationMenu;
    }

    public JSONArray serializeFilters(List<FDSFilter> fdsFilters, String fdsName, HttpServletRequest httpServletRequest) {
        return this.serializeFilters(fdsName, httpServletRequest);
    }

    public JSONArray serializeFilters(String fdsName, HttpServletRequest httpServletRequest) {
        try {
            return this._serializeFilters(fdsName, httpServletRequest);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to serialize filters", (Throwable)exception);
            return this._jsonFactory.createJSONArray();
        }
    }

    public List<FDSActionDropdownItem> serializeItemsActions(String fdsName, HttpServletRequest httpServletRequest) {
        ArrayList<FDSActionDropdownItem> fdsActionDropdownItems = new ArrayList<FDSActionDropdownItem>();
        List systemFDSActionDropdownItems = this._systemFDSSerializer.serializeItemsActions(fdsName, httpServletRequest);
        List customFDSActionDropdownItems = TransformUtil.transform(this.getSortedRelatedObjectEntries(fdsName, httpServletRequest, objectEntry -> Objects.equals(this._getType((ObjectEntry)objectEntry), "item") && this._isActive((ObjectEntry)objectEntry) != false, "itemActionsOrder", "dataSetToDataSetActions"), objectEntry -> {
            Map properties = objectEntry.getProperties();
            FDSActionDropdownItem fdsActionDropdownItem = new FDSActionDropdownItem(String.valueOf(properties.get("confirmationMessage")), String.valueOf(properties.get("url")), String.valueOf(properties.get("icon")), FDSActionUtil.getFDSItemActionId((String)objectEntry.getExternalReferenceCode()), String.valueOf(properties.get("label")), String.valueOf(properties.get("method")), String.valueOf(properties.get("permissionKey")), String.valueOf(properties.get("target")));
            fdsActionDropdownItem.putData("disableHeader", (Object)Validator.isNull(properties.get("title")));
            fdsActionDropdownItem.putData("errorMessage", properties.get("errorMessage"));
            fdsActionDropdownItem.putData("requestBody", properties.get("requestBody"));
            fdsActionDropdownItem.putData("size", properties.get("modalSize"));
            fdsActionDropdownItem.putData("status", properties.get("confirmationMessageType"));
            fdsActionDropdownItem.putData("successMessage", properties.get("successMessage"));
            fdsActionDropdownItem.putData("title", properties.get("title"));
            return fdsActionDropdownItem;
        });
        block0: for (FDSActionDropdownItem customFDSActionDropdownItem : customFDSActionDropdownItems) {
            if (Objects.equals(customFDSActionDropdownItem.get((Object)"target"), FDSEntryItemImportPolicy.GROUP_PROXY.toString())) {
                fdsActionDropdownItems.addAll(systemFDSActionDropdownItems);
                continue;
            }
            if (Objects.equals(customFDSActionDropdownItem.get((Object)"target"), FDSEntryItemImportPolicy.ITEM_PROXY.toString())) {
                for (FDSActionDropdownItem systemFDSActionDropdownItem : systemFDSActionDropdownItems) {
                    if (!systemFDSActionDropdownItem.hasSameDataId((NavigationItem)customFDSActionDropdownItem)) continue;
                    fdsActionDropdownItems.add(systemFDSActionDropdownItem);
                    continue block0;
                }
                continue;
            }
            fdsActionDropdownItems.add(customFDSActionDropdownItem);
        }
        return fdsActionDropdownItems;
    }

    public JSONObject serializePagination(String fdsName, HttpServletRequest httpServletRequest) {
        Map<String, Object> properties = this.getDataSetObjectEntryProperties(fdsName, httpServletRequest);
        return JSONUtil.put((String)"deltas", () -> {
            Object[] listOfItemsPerPage = StringUtil.split((String)String.valueOf(properties.get("listOfItemsPerPage")), (String)", ");
            if (ArrayUtil.isNotEmpty((Object[])listOfItemsPerPage)) {
                return JSONUtil.toJSONArray((Object[])listOfItemsPerPage, itemsPerPage -> {
                    if (GetterUtil.getInteger((String)itemsPerPage) < 1) {
                        return null;
                    }
                    return JSONUtil.put((String)"label", (Object)GetterUtil.getInteger((String)itemsPerPage));
                });
            }
            return JSONUtil.toJSONArray((Collection)ListUtil.fromArray((int[])PropsValues.SEARCH_CONTAINER_PAGE_DELTA_VALUES), itemsPerPage -> JSONUtil.put((String)"label", (Object)itemsPerPage));
        }).put("initialDelta", () -> {
            Integer defaultItemsPerPage = GetterUtil.getInteger((String)String.valueOf(properties.get("defaultItemsPerPage")));
            if (defaultItemsPerPage > 1) {
                return defaultItemsPerPage;
            }
            return PropsValues.SEARCH_CONTAINER_PAGE_DEFAULT_DELTA;
        });
    }

    public String serializePropsTransformer(String fdsName, HttpServletRequest httpServletRequest) {
        Map<String, Object> properties = this.getDataSetObjectEntryProperties(fdsName, httpServletRequest);
        return String.valueOf(properties.get("propsTransformer"));
    }

    public List<FDSSortItem> serializeSorts(String fdsName, HttpServletRequest httpServletRequest) {
        ArrayList<FDSSortItem> fdsSortItems = new ArrayList<FDSSortItem>();
        List systemFDSSortItems = this._systemFDSSerializer.serializeSorts(fdsName, httpServletRequest);
        List customFDSSortItems = TransformUtil.transform(this.getSortedRelatedObjectEntries(fdsName, httpServletRequest, objectEntry -> this._isActive((ObjectEntry)objectEntry), "sortsOrder", "dataSetToDataSetSorts"), objectEntry -> {
            Map properties = objectEntry.getProperties();
            String label = (String)properties.get("label");
            if (Validator.isNull((String)label)) {
                Map labelI18n = (Map)properties.get("label_i18n");
                label = (String)labelI18n.get(LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault()));
            }
            return FDSSortItemBuilder.setActive((Boolean)Boolean.valueOf(String.valueOf(properties.get("default")))).setDirection(String.valueOf(properties.get("orderType"))).setKey(String.valueOf(properties.get("fieldName"))).setLabel(label).build();
        });
        block0: for (FDSSortItem customFDSSortItem : customFDSSortItems) {
            if (Objects.equals(customFDSSortItem.get((Object)"direction"), FDSEntryItemImportPolicy.GROUP_PROXY.toString())) {
                fdsSortItems.addAll(this._systemFDSSerializer.serializeSorts(fdsName, httpServletRequest));
                continue;
            }
            if (Objects.equals(customFDSSortItem.get((Object)"direction"), FDSEntryItemImportPolicy.ITEM_PROXY.toString())) {
                for (FDSSortItem systemFDSSortItem : systemFDSSortItems) {
                    if (!Objects.equals(systemFDSSortItem.get((Object)"key"), customFDSSortItem.get((Object)"key"))) continue;
                    fdsSortItems.add(systemFDSSortItem);
                    continue block0;
                }
                continue;
            }
            fdsSortItems.add(customFDSSortItem);
        }
        return fdsSortItems;
    }

    public JSONArray serializeViews(String fdsName, HttpServletRequest httpServletRequest) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        Map<String, Object> dataSetObjectEntryProperties = this.getDataSetObjectEntryProperties(fdsName, httpServletRequest);
        String defaultVisualizationMode = String.valueOf(dataSetObjectEntryProperties.get("defaultVisualizationMode"));
        jsonArray.put(() -> {
            List<ObjectEntry> objectEntries = this.getRelatedObjectEntries(fdsName, httpServletRequest, null, "dataSetToDataSetCardsSections");
            if (objectEntries.isEmpty()) {
                return null;
            }
            return JSONUtil.put((String)"contentRenderer", (Object)"cards").put("default", defaultVisualizationMode.equals("cards")).put("label", LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)"cards")).put("name", "cards").put("schema", this._serializeViewSchema(objectEntries)).put("thumbnail", "cards2");
        }).put(() -> {
            List<ObjectEntry> objectEntries = this.getRelatedObjectEntries(fdsName, httpServletRequest, null, "dataSetToDataSetListSections");
            if (objectEntries.isEmpty()) {
                return null;
            }
            return JSONUtil.put((String)"contentRenderer", (Object)"list").put("default", defaultVisualizationMode.equals("list")).put("label", LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)"list")).put("name", "list").put("schema", this._serializeViewSchema(objectEntries)).put("thumbnail", "list");
        }).put(() -> {
            List<ObjectEntry> objectEntries = this.getSortedRelatedObjectEntries(fdsName, httpServletRequest, null, "tableSectionsOrder", "dataSetToDataSetTableSections");
            if (objectEntries.isEmpty()) {
                return null;
            }
            JSONArray fieldsJSONArray = JSONUtil.toJSONArray(objectEntries, objectEntry -> {
                Map properties = objectEntry.getProperties();
                JSONObject jsonObject = JSONUtil.put((String)"contentRenderer", (Object)String.valueOf(properties.get("renderer"))).put("fieldName", String.valueOf(properties.get("fieldName"))).put("label", MapUtil.getWithFallbackKey((Map)properties, (Object)"label", (Object)"fieldName")).put("sortable", ((Boolean)properties.get("sortable")).booleanValue());
                String rendererType = String.valueOf(properties.get("rendererType"));
                if (!Objects.equals(rendererType, "clientExtension")) {
                    return jsonObject;
                }
                String externalReferenceCode = String.valueOf(properties.get("renderer"));
                FDSCellRendererCET fdsCellRendererCET = (FDSCellRendererCET)this.cetManager.getCET(PortalUtil.getCompanyId((HttpServletRequest)httpServletRequest), externalReferenceCode);
                if (fdsCellRendererCET == null) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("No frontend data set cell renderer client extension type found for " + externalReferenceCode));
                    }
                    return jsonObject.put("contentRenderer", "default").put("contentRendererClientExtension", false);
                }
                return jsonObject.put("contentRendererClientExtension", true).put("contentRendererModuleURL", "default from " + fdsCellRendererCET.getURL());
            });
            return JSONUtil.put((String)"contentRenderer", (Object)"table").put("default", defaultVisualizationMode.equals("table")).put("label", LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)"table")).put("name", "table").put("schema", JSONUtil.put((String)"fields", (Object)fieldsJSONArray)).put("thumbnail", "table");
        });
        return jsonArray;
    }

    protected Map<String, Object> getDataSetObjectEntryProperties(String externalReferenceCode, HttpServletRequest httpServletRequest) {
        ObjectEntry objectEntry = this._getObjectEntry(externalReferenceCode, this._getObjectDefinition(httpServletRequest));
        if (objectEntry != null) {
            return objectEntry.getProperties();
        }
        return Collections.emptyMap();
    }

    protected List<ObjectEntry> getRelatedObjectEntries(String externalReferenceCode, HttpServletRequest httpServletRequest, Predicate<ObjectEntry> predicate, String ... relationshipNames) {
        ArrayList<ObjectEntry> objectEntries = new ArrayList<ObjectEntry>();
        ObjectDefinition objectDefinition = this._getObjectDefinition(httpServletRequest);
        ObjectEntry objectEntry = this._getObjectEntry(externalReferenceCode, objectDefinition);
        for (String relationshipName : relationshipNames) {
            objectEntries.addAll(this._getRelatedObjectEntries(objectDefinition, objectEntry, predicate, relationshipName));
        }
        return objectEntries;
    }

    protected List<ObjectEntry> getSortedRelatedObjectEntries(String externalReferenceCode, HttpServletRequest httpServletRequest, Predicate<ObjectEntry> predicate, String propertyKey, String ... relationshipNames) {
        ObjectEntry objectEntry = this._getObjectEntry(externalReferenceCode, this._getObjectDefinition(httpServletRequest));
        List<ObjectEntry> objectEntries = this.getRelatedObjectEntries(externalReferenceCode, httpServletRequest, predicate, relationshipNames);
        objectEntries.sort(new ObjectEntryComparator(ListUtil.toList((List)ListUtil.fromString((String)MapUtil.getString((Map)objectEntry.getProperties(), (Object)propertyKey), (String)","), GetterUtil::getLong)));
        return objectEntries;
    }

    private JSONObject _getDateJSONObject(Object object) {
        if (object == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(Date.from(Instant.parse(String.valueOf(object))));
        return JSONUtil.put((String)"day", (Object)calendar.get(5)).put("month", calendar.get(2) + 1).put("year", calendar.get(1));
    }

    private ObjectDefinition _getObjectDefinition(HttpServletRequest httpServletRequest) {
        return this._objectDefinitionLocalService.fetchObjectDefinition(PortalUtil.getCompanyId((HttpServletRequest)httpServletRequest), "DataSet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectEntry _getObjectEntry(String externalReferenceCode, ObjectDefinition objectDefinition) {
        ObjectEntry objectEntry = null;
        DefaultDTOConverterContext dtoConverterContext = new DefaultDTOConverterContext(false, null, null, null, null, LocaleUtil.getMostRelevantLocale(), null, null);
        DefaultObjectEntryManager defaultObjectEntryManager = DefaultObjectEntryManagerProvider.provide((ObjectEntryManager)this._objectEntryManagerRegistry.getObjectEntryManager(objectDefinition.getStorageType()));
        ObjectEntryThreadLocal.setSkipObjectEntryResourcePermission((boolean)true);
        try {
            objectEntry = defaultObjectEntryManager.getObjectEntry(objectDefinition.getCompanyId(), (DTOConverterContext)dtoConverterContext, externalReferenceCode, objectDefinition, null);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get data set object entry with external reference code " + externalReferenceCode), (Throwable)exception);
            }
        }
        finally {
            ObjectEntryThreadLocal.setSkipObjectEntryResourcePermission((boolean)false);
        }
        return objectEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ObjectEntry> _getRelatedObjectEntries(ObjectDefinition objectDefinition, ObjectEntry objectEntry, Predicate<ObjectEntry> predicate, String relationshipName) {
        Collection objectEntries = null;
        DefaultObjectEntryManager defaultObjectEntryManager = DefaultObjectEntryManagerProvider.provide((ObjectEntryManager)this._objectEntryManagerRegistry.getObjectEntryManager(objectDefinition.getStorageType()));
        ObjectEntryThreadLocal.setSkipObjectEntryResourcePermission((boolean)true);
        try {
            Page relatedObjectEntriesPage = defaultObjectEntryManager.getObjectEntryRelatedObjectEntries((DTOConverterContext)new DefaultDTOConverterContext(false, null, null, null, null, LocaleUtil.getMostRelevantLocale(), null, null), objectDefinition, objectEntry.getId(), relationshipName, Pagination.of((int)-1, (int)-1));
            objectEntries = relatedObjectEntriesPage.getItems();
            if (predicate != null) {
                objectEntries.removeIf(predicateObjectEntry -> !predicate.test((ObjectEntry)predicateObjectEntry));
            }
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get related object entries for " + relationshipName), (Throwable)exception);
            }
        }
        finally {
            ObjectEntryThreadLocal.setSkipObjectEntryResourcePermission((boolean)false);
        }
        return objectEntries;
    }

    private String _getType(ObjectEntry objectEntry) {
        Map properties = objectEntry.getProperties();
        return GetterUtil.getString(properties.get("type"));
    }

    private Boolean _isActive(ObjectEntry objectEntry) {
        Map properties = objectEntry.getProperties();
        return (Boolean)properties.get("active");
    }

    private Boolean _isCollection(String fieldName, String sourceType) {
        return fieldName.contains("[") && Objects.equals(sourceType, "OBJECT_PICKLIST");
    }

    private JSONObject _serializeFilter(HttpServletRequest httpServletRequest, ObjectEntry objectEntry) throws Exception {
        Map properties = objectEntry.getProperties();
        String fieldName = String.valueOf(properties.get("fieldName"));
        fieldName = fieldName.replaceAll("(\\[\\]|\\.)", "/");
        String clientExtensionEntryERC = MapUtil.getString((Map)properties, (Object)"clientExtensionEntryERC");
        if (Validator.isNotNull((String)clientExtensionEntryERC)) {
            return this._serializeFilterClientExtension(clientExtensionEntryERC, fieldName, httpServletRequest, properties);
        }
        String type = MapUtil.getString((Map)properties, (Object)"type");
        if (Objects.equals(type, "date") || Objects.equals(type, "date-time")) {
            return this._serializeFilterDateOrDateTime(fieldName, properties, type);
        }
        String sourceType = MapUtil.getString((Map)properties, (Object)"sourceType");
        if (Validator.isNotNull((String)sourceType)) {
            return this._serializeFilterSelection(fieldName, httpServletRequest, properties, sourceType);
        }
        return null;
    }

    private JSONObject _serializeFilterClientExtension(String clientExtensionEntryERC, String fieldName, HttpServletRequest httpServletRequest, Map<String, Object> properties) {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        FDSFilterCET fdsFilterCET = (FDSFilterCET)this.cetManager.getCET(themeDisplay.getCompanyId(), clientExtensionEntryERC);
        if (fdsFilterCET == null) {
            _log.error((Object)("No frontend data set filter client extension exists with the external reference code " + clientExtensionEntryERC));
            return null;
        }
        return JSONUtil.put((String)"clientExtensionFilterURL", (Object)fdsFilterCET.getURL()).put("entityFieldType", "string").put("id", fieldName).put("label", MapUtil.getWithFallbackKey(properties, (Object)"label", (Object)"fieldName")).put("type", "clientExtension");
    }

    private JSONObject _serializeFilterDateOrDateTime(String fieldName, Map<String, Object> properties, String type) throws Exception {
        JSONObject fromJSONObject = this._getDateJSONObject(properties.get("from"));
        JSONObject toJSONObject = this._getDateJSONObject(properties.get("to"));
        boolean active = fromJSONObject != null || toJSONObject != null;
        return JSONUtil.put((String)"active", (Object)active).put("entityFieldType", Objects.equals(type, "date") ? "date" : "date-time").put("id", fieldName).put("label", MapUtil.getWithFallbackKey(properties, (Object)"label", (Object)"fieldName")).put("preloadedData", () -> {
            if (!active) {
                return null;
            }
            return JSONUtil.put((String)"from", (Object)fromJSONObject).put("to", toJSONObject);
        }).put("type", "dateRange");
    }

    private JSONArray _serializeFilters(String fdsName, HttpServletRequest httpServletRequest) throws Exception {
        return JSONUtil.toJSONArray(this.getSortedRelatedObjectEntries(fdsName, httpServletRequest, objectEntry -> this._isActive((ObjectEntry)objectEntry), "filtersOrder", "dataSetToDataSetClientExtensionFilters", "dataSetToDataSetDateFilters", "dataSetToDataSetSelectionFilters"), objectEntry -> this._serializeFilter(httpServletRequest, (ObjectEntry)objectEntry));
    }

    private JSONObject _serializeFilterSelection(String fieldName, HttpServletRequest httpServletRequest, Map<String, Object> properties, String sourceType) throws Exception {
        if (Objects.equals(sourceType, FDSEntryItemImportPolicy.ITEM_PROXY.toString())) {
            JSONArray jsonArray = this._systemFDSSerializer.serializeFilters(MapUtil.getString(properties, (Object)"r_dataSetToDataSetSelectionFilters_l_dataSetERC"), httpServletRequest);
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                if (!Objects.equals(fieldName, jsonObject.getString("id"))) continue;
                return jsonObject;
            }
        }
        JSONObject jsonObject = JSONUtil.put((String)"autocompleteEnabled", (Object)true).put("entityFieldType", () -> {
            if (this._isCollection(String.valueOf(properties.get("fieldName")), sourceType).booleanValue()) {
                return "collection";
            }
            return "string";
        }).put("id", () -> {
            if (!Objects.equals(sourceType, "OBJECT_PICKLIST")) {
                return fieldName;
            }
            int index = fieldName.lastIndexOf("/");
            if (index <= 0) {
                return fieldName;
            }
            return fieldName.substring(0, index);
        }).put("label", MapUtil.getWithFallbackKey(properties, (Object)"label", (Object)"fieldName")).put("multiple", properties.get("multiple")).put("type", "selection");
        String source = MapUtil.getString(properties, (Object)"source");
        if (Objects.equals(sourceType, "API_REST_APPLICATION")) {
            return jsonObject.put("apiURL", source).put("itemKey", properties.get("itemKey")).put("itemLabel", properties.get("itemLabel")).put("preloadedData", () -> {
                JSONArray selectedItemsJSONArray = this._jsonFactory.createJSONArray(MapUtil.getString((Map)properties, (Object)"preselectedValues"));
                if (JSONUtil.isEmpty((JSONArray)selectedItemsJSONArray)) {
                    return null;
                }
                return JSONUtil.put((String)"exclude", () -> Boolean.FALSE.equals((Boolean)properties.get("include"))).put("selectedItems", selectedItemsJSONArray);
            });
        }
        if (!Objects.equals(sourceType, "OBJECT_PICKLIST")) {
            return null;
        }
        ListTypeDefinition listTypeDefinition = this._listTypeDefinitionLocalService.getListTypeDefinitionByExternalReferenceCode(source, PortalUtil.getCompanyId((HttpServletRequest)httpServletRequest));
        List listTypeEntries = this._listTypeEntryLocalService.getListTypeEntries(listTypeDefinition.getListTypeDefinitionId());
        return jsonObject.put("items", JSONUtil.toJSONArray((Collection)listTypeEntries, listTypeEntry -> JSONUtil.put((String)"key", (Object)listTypeEntry.getKey()).put("label", listTypeEntry.getName(PortalUtil.getLocale((HttpServletRequest)httpServletRequest))).put("value", listTypeEntry.getKey()))).put("preloadedData", () -> {
            JSONArray selectedItemsJSONArray = this._jsonFactory.createJSONArray();
            JSONArray preselectedValuesJSONArray = this._jsonFactory.createJSONArray(MapUtil.getString((Map)properties, (Object)"preselectedValues"));
            for (int i = 0; i < preselectedValuesJSONArray.length(); ++i) {
                JSONObject preselectedValueJSONObject = preselectedValuesJSONArray.getJSONObject(i);
                for (ListTypeEntry listTypeEntry : listTypeEntries) {
                    if (!Objects.equals(listTypeEntry.getExternalReferenceCode(), preselectedValueJSONObject.getString("value"))) continue;
                    selectedItemsJSONArray.put(JSONUtil.put((String)"label", (Object)listTypeEntry.getName(PortalUtil.getLocale((HttpServletRequest)httpServletRequest))).put("value", listTypeEntry.getKey()));
                }
            }
            if (JSONUtil.isEmpty((JSONArray)selectedItemsJSONArray)) {
                return null;
            }
            return JSONUtil.put((String)"exclude", () -> Boolean.FALSE.equals((Boolean)properties.get("include"))).put("selectedItems", selectedItemsJSONArray);
        });
    }

    private JSONObject _serializeViewSchema(Collection<ObjectEntry> objectEntries) throws Exception {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        for (ObjectEntry objectEntry : objectEntries) {
            Map properties = objectEntry.getProperties();
            jsonObject.put(String.valueOf(properties.get("name")), String.valueOf(properties.get("fieldName")));
        }
        return jsonObject;
    }

    private static class ObjectEntryComparator
    implements Comparator<ObjectEntry> {
        private final List<Long> _ids;

        public ObjectEntryComparator(List<Long> ids) {
            this._ids = ids;
        }

        @Override
        public int compare(ObjectEntry dataSetObjectEntry1, ObjectEntry dataSetObjectEntry2) {
            long id1 = dataSetObjectEntry1.getId();
            long id2 = dataSetObjectEntry2.getId();
            int index1 = this._ids.indexOf(id1);
            int index2 = this._ids.indexOf(id2);
            if (index1 == -1 && index2 == -1) {
                Date date = dataSetObjectEntry1.getDateCreated();
                return date.compareTo(dataSetObjectEntry2.getDateCreated());
            }
            if (index1 == -1) {
                return 1;
            }
            if (index2 == -1) {
                return -1;
            }
            return Long.compare(index1, index2);
        }
    }
}

