/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.data.set.internal.filter;

import com.liferay.frontend.data.set.filter.FDSFilter;
import com.liferay.frontend.data.set.filter.FDSFilterRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={FDSFilterRegistry.class})
public class FDSFilterRegistryImpl
implements FDSFilterRegistry {
    private static final Log _log = LogFactoryUtil.getLog(FDSFilterRegistryImpl.class);
    private ServiceTrackerMap<String, List<ServiceTrackerCustomizerFactory.ServiceWrapper<FDSFilter>>> _serviceTrackerMap;

    public FDSFilterRegistryImpl() {
    }

    public FDSFilterRegistryImpl(ServiceTrackerMap<String, List<ServiceTrackerCustomizerFactory.ServiceWrapper<FDSFilter>>> serviceTrackerMap) {
        this._serviceTrackerMap = serviceTrackerMap;
    }

    public List<FDSFilter> getFDSFilters(String fdsName) {
        List fdsFilterServiceWrappers = (List)this._serviceTrackerMap.getService((Object)fdsName);
        if (fdsFilterServiceWrappers == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No frontend data set filter is associated with " + fdsName));
            }
            return Collections.emptyList();
        }
        return TransformUtil.transform((Collection)fdsFilterServiceWrappers, fdsFilterServiceWrapper -> (FDSFilter)fdsFilterServiceWrapper.getService());
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, FDSFilter.class, (String)"frontend.data.set.name", (ServiceTrackerCustomizer)ServiceTrackerCustomizerFactory.serviceWrapper((BundleContext)bundleContext));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

