/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.data.set.internal.view;

import com.liferay.frontend.data.set.view.FDSView;
import com.liferay.frontend.data.set.view.FDSViewRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={FDSViewRegistry.class})
public class FDSViewRegistryImpl
implements FDSViewRegistry {
    private static final Log _log = LogFactoryUtil.getLog(FDSViewRegistryImpl.class);
    private ServiceTrackerMap<String, List<ServiceTrackerCustomizerFactory.ServiceWrapper<FDSView>>> _serviceTrackerMap;

    public FDSViewRegistryImpl() {
    }

    public FDSViewRegistryImpl(ServiceTrackerMap<String, List<ServiceTrackerCustomizerFactory.ServiceWrapper<FDSView>>> serviceTrackerMap) {
        this._serviceTrackerMap = serviceTrackerMap;
    }

    public List<FDSView> getFDSViews(String fdsName) {
        List fdsViewServiceWrappers = (List)this._serviceTrackerMap.getService((Object)fdsName);
        if (fdsViewServiceWrappers == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No frontend data set view is associated with " + fdsName));
            }
            return Collections.emptyList();
        }
        return TransformUtil.transform((Collection)fdsViewServiceWrappers, fdsViewServiceWrapper -> (FDSView)fdsViewServiceWrapper.getService());
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, FDSView.class, (String)"frontend.data.set.name", (ServiceTrackerCustomizer)ServiceTrackerCustomizerFactory.serviceWrapper((BundleContext)bundleContext));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

