/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.data.set.internal.url;

import com.liferay.frontend.data.set.url.FDSAPIURLResolver;
import com.liferay.frontend.data.set.url.FDSAPIURLResolverRegistry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class FDSAPIURLBuilder {
    private static final Log _log = LogFactoryUtil.getLog(FDSAPIURLBuilder.class);
    private final FDSAPIURLResolverRegistry _fdsAPIURLResolverRegistry;
    private final HttpServletRequest _httpServletRequest;
    private final List<String> _queryStringItems = new LinkedList<String>();
    private final String _restApplication;
    private final String _restEndpoint;
    private final String _restSchema;

    public FDSAPIURLBuilder(FDSAPIURLResolverRegistry fdsAPIURLResolverRegistry, HttpServletRequest httpServletRequest, String restApplication, String restEndpoint, String restSchema) {
        this._fdsAPIURLResolverRegistry = fdsAPIURLResolverRegistry;
        this._httpServletRequest = httpServletRequest;
        this._restApplication = restApplication;
        this._restEndpoint = restEndpoint;
        this._restSchema = restSchema;
    }

    public FDSAPIURLBuilder addParameter(String name, String value) {
        if (Validator.isNotNull((String)name) && Validator.isNotNull((String)value)) {
            this._queryStringItems.add(name + "=" + value);
        }
        return this;
    }

    public String build() {
        StringBundler sb = new StringBundler(3 + this._queryStringItems.size() * 2);
        sb.append("/o");
        sb.append(StringUtil.replaceLast((String)this._restApplication, (String)"/v1.0", (String)""));
        sb.append(this._restEndpoint);
        this._appendParameters(sb);
        return this._interpolate(this._resolveParameters(sb.toString()));
    }

    private void _appendParameters(StringBundler sb) {
        if (this._queryStringItems.isEmpty()) {
            return;
        }
        sb.append('?');
        int count = 0;
        for (String parameter : this._queryStringItems) {
            sb.append(parameter);
            if (++count >= this._queryStringItems.size()) continue;
            sb.append('&');
        }
    }

    private String _interpolate(String apiURL) {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        apiURL = StringUtil.replace((String)apiURL, (String)"{siteId}", (String)String.valueOf(themeDisplay.getScopeGroupId()));
        apiURL = StringUtil.replace((String)apiURL, (String)"{scopeKey}", (String)String.valueOf(themeDisplay.getScopeGroupId()));
        if (StringUtil.contains((String)(apiURL = StringUtil.replace((String)apiURL, (String)"{userId}", (String)String.valueOf(themeDisplay.getUserId()))), (String)"{") && _log.isWarnEnabled()) {
            _log.warn((Object)("Unsupported parameter in API URL: " + apiURL));
        }
        return apiURL;
    }

    private String _resolveParameters(String apiURL) {
        FDSAPIURLResolver fdsAPIURLResolver = this._fdsAPIURLResolverRegistry.getFDSAPIURLResolver(this._restApplication, this._restSchema);
        if (fdsAPIURLResolver == null) {
            return apiURL;
        }
        try {
            return fdsAPIURLResolver.resolve(apiURL, this._httpServletRequest);
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return apiURL;
        }
    }
}

