/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.data.set.internal.serializer;

import com.liferay.frontend.data.set.SystemFDSEntry;
import com.liferay.frontend.data.set.SystemFDSEntryRegistry;
import com.liferay.frontend.data.set.action.FDSBulkActions;
import com.liferay.frontend.data.set.action.FDSBulkActionsRegistry;
import com.liferay.frontend.data.set.action.FDSCreationMenu;
import com.liferay.frontend.data.set.action.FDSCreationMenuRegistry;
import com.liferay.frontend.data.set.action.FDSItemsActions;
import com.liferay.frontend.data.set.action.FDSItemsActionsRegistry;
import com.liferay.frontend.data.set.filter.FDSFilter;
import com.liferay.frontend.data.set.filter.FDSFilterContextContributor;
import com.liferay.frontend.data.set.filter.FDSFilterContextContributorRegistry;
import com.liferay.frontend.data.set.filter.FDSFilterRegistry;
import com.liferay.frontend.data.set.internal.serializer.BaseFDSSerializer;
import com.liferay.frontend.data.set.model.FDSActionDropdownItem;
import com.liferay.frontend.data.set.model.FDSSortItem;
import com.liferay.frontend.data.set.serializer.FDSSerializer;
import com.liferay.frontend.data.set.sort.FDSSorts;
import com.liferay.frontend.data.set.sort.FDSSortsRegistry;
import com.liferay.frontend.data.set.view.FDSView;
import com.liferay.frontend.data.set.view.FDSViewContextContributor;
import com.liferay.frontend.data.set.view.FDSViewContextContributorRegistry;
import com.liferay.frontend.data.set.view.FDSViewRegistry;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"frontend.data.set.serializer.type=system"}, service={FDSSerializer.class})
public class SystemFDSSerializer
extends BaseFDSSerializer
implements FDSSerializer {
    @Reference
    protected FDSBulkActionsRegistry fdsBulkActionsRegistry;
    @Reference
    protected FDSCreationMenuRegistry fdsCreationMenuRegistry;
    @Reference
    protected FDSFilterContextContributorRegistry fdsFilterContextContributorRegistry;
    @Reference
    protected FDSFilterRegistry fdsFilterRegistry;
    @Reference
    protected FDSItemsActionsRegistry fdsItemsActionsRegistry;
    @Reference
    protected FDSSortsRegistry fdsSortsRegistry;
    @Reference
    protected FDSViewContextContributorRegistry fdsViewContextContributorRegistry;
    @Reference
    protected FDSViewRegistry fdsViewRegistry;
    @Reference
    protected SystemFDSEntryRegistry systemFDSEntryRegistry;
    private static final SystemFDSEntry _systemFDSEntry = new SystemFDSEntry(){

        public int getDefaultItemsPerPage() {
            return super.getDefaultItemsPerPage();
        }

        public String getDescription() {
            return "";
        }

        public int[] getListOfItemsPerPage() {
            return super.getListOfItemsPerPage();
        }

        public String getName() {
            return "";
        }

        public String getRESTApplication() {
            return "";
        }

        public String getRESTEndpoint() {
            return "";
        }

        public String getRESTSchema() {
            return "";
        }

        public String getTitle() {
            return "";
        }
    };

    public boolean isAvailable(String fdsName, HttpServletRequest httpServletRequest) {
        return this.fdsViewRegistry.getFDSViews(fdsName) != null || this.systemFDSEntryRegistry.getSystemFDSEntry(fdsName) != null;
    }

    public String serializeAdditionalAPIURLParameters(String fdsName, HttpServletRequest httpServletRequest) {
        SystemFDSEntry systemFDSEntry = this.systemFDSEntryRegistry.getSystemFDSEntry(fdsName);
        if (systemFDSEntry == null) {
            return null;
        }
        return systemFDSEntry.getAdditionalAPIURLParameters();
    }

    public String serializeAPIURL(String fdsName, HttpServletRequest httpServletRequest) {
        SystemFDSEntry systemFDSEntry = this.systemFDSEntryRegistry.getSystemFDSEntry(fdsName);
        if (systemFDSEntry == null) {
            return null;
        }
        return this.createFDSAPIURLBuilder(httpServletRequest, systemFDSEntry.getRESTApplication(), systemFDSEntry.getRESTEndpoint(), systemFDSEntry.getRESTSchema()).build();
    }

    public List<FDSActionDropdownItem> serializeBulkActions(String fdsName, HttpServletRequest httpServletRequest) {
        FDSBulkActions fdsBulkActions = this.fdsBulkActionsRegistry.getFDSBulkActions(fdsName);
        if (fdsBulkActions == null) {
            return Collections.emptyList();
        }
        return fdsBulkActions.getFDSActionDropdownItems(httpServletRequest);
    }

    public CreationMenu serializeCreationMenu(String fdsName, HttpServletRequest httpServletRequest) {
        FDSCreationMenu fdsCreationMenu = this.fdsCreationMenuRegistry.getFDSCreationMenu(fdsName);
        if (fdsCreationMenu == null) {
            return new CreationMenu();
        }
        return fdsCreationMenu.getCreationMenu(httpServletRequest);
    }

    public JSONArray serializeFilters(List<FDSFilter> fdsFilters, String fdsName, HttpServletRequest httpServletRequest) {
        JSONArray jsonArray = JSONUtil.putAll((Object[])new Object[0]);
        Locale locale = PortalUtil.getLocale((HttpServletRequest)httpServletRequest);
        this._serializeFilters(fdsFilters, jsonArray, locale);
        this._serializeFilters(this.fdsFilterRegistry.getFDSFilters(fdsName), jsonArray, locale);
        return jsonArray;
    }

    public JSONArray serializeFilters(String fdsName, HttpServletRequest httpServletRequest) {
        return this.serializeFilters(Collections.emptyList(), fdsName, httpServletRequest);
    }

    public List<FDSActionDropdownItem> serializeItemsActions(String fdsName, HttpServletRequest httpServletRequest) {
        FDSItemsActions fdsItemsActions = this.fdsItemsActionsRegistry.getFDSItemsActions(fdsName);
        if (fdsItemsActions == null) {
            return Collections.emptyList();
        }
        return fdsItemsActions.getFDSActionDropdownItems(httpServletRequest);
    }

    public JSONObject serializePagination(String fdsName, HttpServletRequest httpServletRequest) {
        SystemFDSEntry systemFDSEntry = this.systemFDSEntryRegistry.getSystemFDSEntry(fdsName);
        if (systemFDSEntry == null) {
            return null;
        }
        return JSONUtil.put((String)"deltas", () -> {
            int[] listOfItemsPerPage = systemFDSEntry.getListOfItemsPerPage();
            if (ArrayUtil.isEmpty((int[])listOfItemsPerPage)) {
                listOfItemsPerPage = _systemFDSEntry.getListOfItemsPerPage();
            }
            return JSONUtil.toJSONArray((Collection)ListUtil.fromArray((int[])listOfItemsPerPage), itemsPerPage -> {
                if (itemsPerPage > 0) {
                    return JSONUtil.put((String)"label", (Object)itemsPerPage);
                }
                return null;
            });
        }).put("initialDelta", () -> {
            if (systemFDSEntry.getDefaultItemsPerPage() > 0) {
                return systemFDSEntry.getDefaultItemsPerPage();
            }
            return _systemFDSEntry.getDefaultItemsPerPage();
        });
    }

    public String serializePropsTransformer(String fdsName, HttpServletRequest httpServletRequest) {
        SystemFDSEntry systemFDSEntry = this.systemFDSEntryRegistry.getSystemFDSEntry(fdsName);
        if (systemFDSEntry == null) {
            return null;
        }
        return systemFDSEntry.getPropsTransformer();
    }

    public List<FDSSortItem> serializeSorts(String fdsName, HttpServletRequest httpServletRequest) {
        FDSSorts fdsSorts = this.fdsSortsRegistry.getFDSSorts(fdsName);
        if (fdsSorts == null) {
            return Collections.emptyList();
        }
        return fdsSorts.getFDSSortItems(httpServletRequest);
    }

    public JSONArray serializeViews(String fdsName, HttpServletRequest httpServletRequest) {
        JSONArray jsonArray = JSONUtil.putAll((Object[])new Object[0]);
        for (FDSView fdsView : this.fdsViewRegistry.getFDSViews(fdsName)) {
            JSONObject jsonObject = JSONUtil.put((String)"contentRenderer", (Object)fdsView.getContentRenderer()).put("contentRendererModuleURL", fdsView.getContentRendererModuleURL()).put("default", fdsView.isDefault()).put("label", LanguageUtil.get((ResourceBundle)ResourceBundleUtil.getBundle((String)"content.Language", (Locale)PortalUtil.getLocale((HttpServletRequest)httpServletRequest), this.getClass()), (String)fdsView.getLabel())).put("name", fdsView.getName()).put("thumbnail", fdsView.getThumbnail());
            List fdsViewContextContributors = this.fdsViewContextContributorRegistry.getFDSViewContextContributors(fdsView.getContentRenderer());
            for (FDSViewContextContributor fdsViewContextContributor : fdsViewContextContributors) {
                Map fdsViewContext = fdsViewContextContributor.getFDSViewContext(fdsView, PortalUtil.getLocale((HttpServletRequest)httpServletRequest));
                if (fdsViewContext == null) continue;
                for (Map.Entry entry : fdsViewContext.entrySet()) {
                    jsonObject.put((String)entry.getKey(), entry.getValue());
                }
            }
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    private void _serializeFilters(List<FDSFilter> fdsFilters, JSONArray jsonArray, Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        for (FDSFilter fdsFilter : fdsFilters) {
            if (!fdsFilter.isEnabled()) continue;
            JSONObject jsonObject = JSONUtil.put((String)"entityFieldType", (Object)fdsFilter.getEntityFieldType()).put("id", fdsFilter.getId()).put("label", LanguageUtil.get((ResourceBundle)resourceBundle, (String)fdsFilter.getLabel())).put("preloadedData", (Object)fdsFilter.getPreloadedData()).put("type", fdsFilter.getType());
            List fdsFilterContextContributors = this.fdsFilterContextContributorRegistry.getFDSFilterContextContributors(fdsFilter.getType());
            for (FDSFilterContextContributor fdsFilterContextContributor : fdsFilterContextContributors) {
                Map fdsFilterContext = fdsFilterContextContributor.getFDSFilterContext(fdsFilter, locale);
                if (fdsFilterContext == null) continue;
                for (Map.Entry entry : fdsFilterContext.entrySet()) {
                    jsonObject.put((String)entry.getKey(), entry.getValue());
                }
            }
            jsonArray.put(jsonObject);
        }
    }
}

