/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.data.set.internal.renderer;

import com.liferay.frontend.data.set.renderer.FDSRenderer;
import com.liferay.frontend.data.set.serializer.FDSSerializer;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.template.react.renderer.ComponentDescriptor;
import com.liferay.portal.template.react.renderer.ReactRenderer;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FDSRenderer.class})
public class FDSRendererImpl
implements FDSRenderer {
    private static final Log _log = LogFactoryUtil.getLog(FDSRendererImpl.class);
    private BundleContext _bundleContext;
    @Reference
    private Portal _portal;
    @Reference
    private ReactRenderer _reactRenderer;
    private ServiceTrackerMap<String, FDSSerializer> _serviceTrackerMap;

    public void render(Map<String, Object> baseProps, String componentId, String fdsName, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean inline, String propsTransformer, Writer writer) {
        FDSSerializer fdsSerializer;
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (baseProps != null) {
            props.putAll(baseProps);
        }
        if ((fdsSerializer = this._getFDSSerializer(fdsName, httpServletRequest)) == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No frontend data set serializer is associated with " + fdsName));
            }
        } else {
            props.putAll(HashMapBuilder.put((Object)"additionalAPIURLParameters", () -> {
                String additionalAPIURLParameters = fdsSerializer.serializeAdditionalAPIURLParameters(fdsName, httpServletRequest);
                if (Validator.isNull((String)additionalAPIURLParameters)) {
                    return null;
                }
                return additionalAPIURLParameters;
            }).put((Object)"apiURL", () -> {
                String apiURL = fdsSerializer.serializeAPIURL(fdsName, httpServletRequest);
                if (Validator.isNull((String)apiURL)) {
                    return null;
                }
                return apiURL;
            }).put((Object)"bulkActions", () -> {
                List fdsActionDropdownItems = fdsSerializer.serializeBulkActions(fdsName, httpServletRequest);
                if (ListUtil.isEmpty((List)fdsActionDropdownItems)) {
                    return null;
                }
                return fdsActionDropdownItems;
            }).put((Object)"creationMenu", () -> {
                CreationMenu creationMenu = fdsSerializer.serializeCreationMenu(fdsName, httpServletRequest);
                if (creationMenu == null || creationMenu.isEmpty()) {
                    return null;
                }
                return creationMenu;
            }).put((Object)"currentURL", (Object)this._portal.getCurrentURL(httpServletRequest)).put((Object)"filters", () -> {
                JSONArray filtersJSONArray = fdsSerializer.serializeFilters(fdsName, httpServletRequest);
                if (JSONUtil.isEmpty((JSONArray)filtersJSONArray)) {
                    return null;
                }
                return filtersJSONArray;
            }).put((Object)"itemsActions", () -> {
                List fdsActionDropdownItems = fdsSerializer.serializeItemsActions(fdsName, httpServletRequest);
                if (ListUtil.isEmpty((List)fdsActionDropdownItems)) {
                    return null;
                }
                return fdsActionDropdownItems;
            }).put((Object)"pagination", () -> {
                JSONObject paginationJSONObject = fdsSerializer.serializePagination(fdsName, httpServletRequest);
                if (JSONUtil.isEmpty((JSONObject)paginationJSONObject)) {
                    return null;
                }
                return paginationJSONObject;
            }).put((Object)"sorts", () -> {
                List fdsSortItems = fdsSerializer.serializeSorts(fdsName, httpServletRequest);
                if (ListUtil.isEmpty((List)fdsSortItems)) {
                    return null;
                }
                return fdsSortItems;
            }).put((Object)"views", () -> {
                JSONArray viewsJSONArray = fdsSerializer.serializeViews(fdsName, httpServletRequest);
                if (JSONUtil.isEmpty((JSONArray)viewsJSONArray)) {
                    return null;
                }
                return viewsJSONArray;
            }).build());
            String tempPropsTransformer = fdsSerializer.serializePropsTransformer(fdsName, httpServletRequest);
            if (Validator.isNotNull((String)tempPropsTransformer)) {
                propsTransformer = tempPropsTransformer;
            }
        }
        try {
            this._reactRenderer.renderReact(new ComponentDescriptor("{FrontendDataSet} from frontend-data-set-web", componentId, null, inline, propsTransformer), props, httpServletRequest, writer);
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to render frontend data set " + fdsName), (Throwable)exception);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, FDSSerializer.class, (String)"frontend.data.set.serializer.type");
    }

    private FDSSerializer _getFDSSerializer(String fdsName, HttpServletRequest httpServletRequest) {
        for (String type : FDSSerializer.FDS_TYPES) {
            FDSSerializer fdsSerializer = (FDSSerializer)this._serviceTrackerMap.getService((Object)type);
            if (fdsSerializer == null || !fdsSerializer.isAvailable(fdsName, httpServletRequest)) continue;
            return fdsSerializer;
        }
        return null;
    }
}

