/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.data.set.internal;

import com.liferay.frontend.data.set.SystemFDSEntry;
import com.liferay.frontend.data.set.SystemFDSEntryRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={SystemFDSEntryRegistry.class})
public class SystemFDSEntryRegistryImpl
implements SystemFDSEntryRegistry {
    private BundleContext _bundleContext;
    private ServiceTrackerMap<String, SystemFDSEntry> _serviceTrackerMap;

    public SystemFDSEntryRegistryImpl() {
    }

    public SystemFDSEntryRegistryImpl(ServiceTrackerMap<String, SystemFDSEntry> serviceTrackerMap) {
        this._serviceTrackerMap = serviceTrackerMap;
    }

    public SystemFDSEntry getSystemFDSEntry(String fdsName) {
        return (SystemFDSEntry)this._serviceTrackerMap.getService((Object)fdsName);
    }

    public Set<String> getSystemFDSNames() {
        return Collections.unmodifiableSet(new TreeSet(this._serviceTrackerMap.keySet()));
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, SystemFDSEntry.class, (String)"frontend.data.set.name");
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

