/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.frontend.data.set.internal.provider;

import com.liferay.frontend.data.set.provider.FDSDataProvider;
import com.liferay.frontend.data.set.provider.FDSDataProviderRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory.ServiceWrapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

/**
 * @author Marco Leo
 */
@Component(service = FDSDataProviderRegistry.class)
public class FDSDataProviderRegistryImpl implements FDSDataProviderRegistry {

	@Override
	public FDSDataProvider getFDSDataProvider(String fdsDataProviderKey) {
		ServiceWrapper<FDSDataProvider> fdsDataProviderServiceWrapper =
			_serviceTrackerMap.getService(fdsDataProviderKey);

		if (fdsDataProviderServiceWrapper == null) {
			if (_log.isDebugEnabled()) {
				_log.debug(
					"No frontend data set data provider is associated with " +
						fdsDataProviderKey);
			}

			return null;
		}

		return fdsDataProviderServiceWrapper.getService();
	}

	@Override
	public List<FDSDataProvider> getFDSDataProviders() {
		List<FDSDataProvider> fdsDataProviders = new ArrayList<>();

		List<ServiceWrapper<FDSDataProvider>> fdsDataProviderServiceWrappers =
			ListUtil.fromCollection(_serviceTrackerMap.values());

		for (ServiceWrapper<FDSDataProvider> fdsDataProviderServiceWrapper :
				fdsDataProviderServiceWrappers) {

			fdsDataProviders.add(fdsDataProviderServiceWrapper.getService());
		}

		return Collections.unmodifiableList(fdsDataProviders);
	}

	@Activate
	protected void activate(BundleContext bundleContext) {
		_serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap(
			bundleContext, FDSDataProvider.class, "fds.data.provider.key",
			ServiceTrackerCustomizerFactory.<FDSDataProvider>serviceWrapper(
				bundleContext));
	}

	@Deactivate
	protected void deactivate() {
		_serviceTrackerMap.close();
	}

	private static final Log _log = LogFactoryUtil.getLog(
		FDSDataProviderRegistryImpl.class);

	private ServiceTrackerMap<String, ServiceWrapper<FDSDataProvider>>
		_serviceTrackerMap;

}