/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.data.set.internal.url;

import com.liferay.frontend.data.set.url.FDSAPIURLResolver;
import com.liferay.frontend.data.set.url.FDSAPIURLResolverRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={FDSAPIURLResolverRegistry.class})
public class FDSAPIURLResolverRegistryImpl
implements FDSAPIURLResolverRegistry {
    private static final Log _log = LogFactoryUtil.getLog(FDSAPIURLResolverRegistryImpl.class);
    private ServiceTrackerMap<String, ServiceTrackerCustomizerFactory.ServiceWrapper<FDSAPIURLResolver>> _serviceTrackerMap;

    public FDSAPIURLResolverRegistryImpl() {
    }

    public FDSAPIURLResolverRegistryImpl(ServiceTrackerMap<String, ServiceTrackerCustomizerFactory.ServiceWrapper<FDSAPIURLResolver>> serviceTrackerMap) {
        this._serviceTrackerMap = serviceTrackerMap;
    }

    public FDSAPIURLResolver getFDSAPIURLResolver(String restApplication, String restSchema) {
        String key = StringBundler.concat((String[])new String[]{restApplication, "/", restSchema});
        ServiceTrackerCustomizerFactory.ServiceWrapper serviceWrapper = (ServiceTrackerCustomizerFactory.ServiceWrapper)this._serviceTrackerMap.getService((Object)key);
        if (serviceWrapper == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No REST application found for " + key));
            }
            return null;
        }
        return (FDSAPIURLResolver)serviceWrapper.getService();
    }

    public List<FDSAPIURLResolver> getFDSAPIURLResolvers() {
        ArrayList<FDSAPIURLResolver> fdsAPIURLResolvers = new ArrayList<FDSAPIURLResolver>();
        for (ServiceTrackerCustomizerFactory.ServiceWrapper serviceWrapper : this._serviceTrackerMap.values()) {
            fdsAPIURLResolvers.add((FDSAPIURLResolver)serviceWrapper.getService());
        }
        return Collections.unmodifiableList(fdsAPIURLResolvers);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, FDSAPIURLResolver.class, (String)"fds.rest.application.key", (ServiceTrackerCustomizer)ServiceTrackerCustomizerFactory.serviceWrapper((BundleContext)bundleContext));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

