/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.data.set.internal.provider;

import com.liferay.frontend.data.set.provider.FDSDataProvider;
import com.liferay.frontend.data.set.provider.FDSDataProviderRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={FDSDataProviderRegistry.class})
public class FDSDataProviderRegistryImpl
implements FDSDataProviderRegistry {
    private static final Log _log = LogFactoryUtil.getLog(FDSDataProviderRegistryImpl.class);
    private ServiceTrackerMap<String, ServiceTrackerCustomizerFactory.ServiceWrapper<FDSDataProvider>> _serviceTrackerMap;

    public FDSDataProvider getFDSDataProvider(String fdsDataProviderKey) {
        ServiceTrackerCustomizerFactory.ServiceWrapper fdsDataProviderServiceWrapper = (ServiceTrackerCustomizerFactory.ServiceWrapper)this._serviceTrackerMap.getService((Object)fdsDataProviderKey);
        if (fdsDataProviderServiceWrapper == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No frontend data set data provider is associated with " + fdsDataProviderKey));
            }
            return null;
        }
        return (FDSDataProvider)fdsDataProviderServiceWrapper.getService();
    }

    public List<FDSDataProvider> getFDSDataProviders() {
        ArrayList<FDSDataProvider> fdsDataProviders = new ArrayList<FDSDataProvider>();
        List fdsDataProviderServiceWrappers = ListUtil.fromCollection((Collection)this._serviceTrackerMap.values());
        for (ServiceTrackerCustomizerFactory.ServiceWrapper fdsDataProviderServiceWrapper : fdsDataProviderServiceWrappers) {
            fdsDataProviders.add((FDSDataProvider)fdsDataProviderServiceWrapper.getService());
        }
        return Collections.unmodifiableList(fdsDataProviders);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, FDSDataProvider.class, (String)"fds.data.provider.key", (ServiceTrackerCustomizer)ServiceTrackerCustomizerFactory.serviceWrapper((BundleContext)bundleContext));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

