/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.friendly.url.internal.exportimport.data.handler;

import com.liferay.asset.entry.rel.model.AssetEntryAssetCategoryRel;
import com.liferay.asset.entry.rel.service.AssetEntryAssetCategoryRelLocalService;
import com.liferay.asset.entry.rel.util.comparator.AssetEntryAssetCategoryRelAssetEntryAssetCategoryRelIdComparator;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.xml.Element;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StagedModelDataHandler.class})
public class FriendlyURLEntryStagedModelDataHandler
extends BaseStagedModelDataHandler<FriendlyURLEntry> {
    public static final String[] CLASS_NAMES = new String[]{FriendlyURLEntry.class.getName()};
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetEntryAssetCategoryRelLocalService _assetEntryAssetCategoryRelLocalService;
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private FriendlyURLEntryLocalService _friendlyURLEntryLocalService;
    @Reference
    private Portal _portal;
    @Reference(target="(model.class.name=com.liferay.friendly.url.model.FriendlyURLEntry)")
    private StagedModelRepository<FriendlyURLEntry> _stagedModelRepository;

    public FriendlyURLEntry fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return (FriendlyURLEntry)this._stagedModelRepository.fetchStagedModelByUuidAndGroupId(uuid, groupId);
    }

    public List<FriendlyURLEntry> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._stagedModelRepository.fetchStagedModelsByUuidAndCompanyId(uuid, companyId);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, FriendlyURLEntry friendlyURLEntry) throws Exception {
        Element friendlyURLEntryElement = portletDataContext.getExportDataElement((ClassedModel)friendlyURLEntry);
        this._exportAssetCategories(portletDataContext, friendlyURLEntry);
        friendlyURLEntryElement.addAttribute("resource-class-name", friendlyURLEntry.getClassName());
        portletDataContext.addZipEntry(ExportImportPathUtil.getModelPath((StagedModel)friendlyURLEntry, (String)friendlyURLEntry.getUuid()), friendlyURLEntry.getUrlTitleMapAsXML());
        FriendlyURLEntry mainFriendlyURLEntry = this._friendlyURLEntryLocalService.fetchMainFriendlyURLEntry(friendlyURLEntry.getClassNameId(), friendlyURLEntry.getClassPK());
        if (mainFriendlyURLEntry == null) {
            this._friendlyURLEntryLocalService.setMainFriendlyURLEntry(friendlyURLEntry);
        }
        if (friendlyURLEntry.isMain()) {
            friendlyURLEntryElement.addAttribute("mainEntry", Boolean.TRUE.toString());
        }
        portletDataContext.addClassedModel(friendlyURLEntryElement, ExportImportPathUtil.getModelPath((StagedModel)friendlyURLEntry), (ClassedModel)friendlyURLEntry);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, FriendlyURLEntry friendlyURLEntry) throws Exception {
        Element friendlyURLEntryElement = portletDataContext.getImportDataStagedModelElement((StagedModel)friendlyURLEntry);
        String className = friendlyURLEntryElement.attributeValue("resource-class-name");
        long classNameId = this._classNameLocalService.getClassNameId(className);
        Map newPrimaryKeysMap = portletDataContext.getNewPrimaryKeysMap(className);
        if (!newPrimaryKeysMap.containsKey(friendlyURLEntry.getClassPK())) {
            portletDataContext.removePrimaryKey(ExportImportPathUtil.getModelPath((StagedModel)friendlyURLEntry));
            return;
        }
        FriendlyURLEntry existingFriendlyURLEntry = this.fetchStagedModelByUuidAndGroupId(friendlyURLEntry.getUuid(), portletDataContext.getScopeGroupId());
        FriendlyURLEntry importedFriendlyURLEntry = (FriendlyURLEntry)friendlyURLEntry.clone();
        importedFriendlyURLEntry.setGroupId(portletDataContext.getScopeGroupId());
        importedFriendlyURLEntry.setCompanyId(portletDataContext.getCompanyId());
        importedFriendlyURLEntry.setClassNameId(classNameId);
        importedFriendlyURLEntry.setClassPK(MapUtil.getLong((Map)newPrimaryKeysMap, (long)friendlyURLEntry.getClassPK(), (long)friendlyURLEntry.getClassPK()));
        if (existingFriendlyURLEntry == null || !portletDataContext.isDataStrategyMirror()) {
            importedFriendlyURLEntry = (FriendlyURLEntry)this._stagedModelRepository.addStagedModel(portletDataContext, (StagedModel)importedFriendlyURLEntry);
            boolean mainEntry = GetterUtil.getBoolean((String)friendlyURLEntryElement.attributeValue("mainEntry"));
            if (mainEntry) {
                this._friendlyURLEntryLocalService.setMainFriendlyURLEntry(importedFriendlyURLEntry);
            }
        } else {
            importedFriendlyURLEntry = (FriendlyURLEntry)this._stagedModelRepository.updateStagedModel(portletDataContext, (StagedModel)importedFriendlyURLEntry);
            boolean mainEntry = GetterUtil.getBoolean((String)friendlyURLEntryElement.attributeValue("mainEntry"));
            if (mainEntry) {
                this._friendlyURLEntryLocalService.setMainFriendlyURLEntry(existingFriendlyURLEntry);
            }
        }
        this._importAssetCategories(portletDataContext, friendlyURLEntry, importedFriendlyURLEntry);
        portletDataContext.importClassedModel((ClassedModel)friendlyURLEntry, (ClassedModel)importedFriendlyURLEntry);
    }

    protected StagedModelRepository<FriendlyURLEntry> getStagedModelRepository() {
        return this._stagedModelRepository;
    }

    private void _exportAssetCategories(PortletDataContext portletDataContext, FriendlyURLEntry friendlyURLEntry) throws Exception {
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(FriendlyURLEntry.class.getName(), friendlyURLEntry.getFriendlyURLEntryId());
        if (assetEntry == null) {
            return;
        }
        List assetEntryAssetCategoryRels = this._assetEntryAssetCategoryRelLocalService.getAssetEntryAssetCategoryRelsByAssetEntryId(assetEntry.getEntryId(), -1, -1, (OrderByComparator)AssetEntryAssetCategoryRelAssetEntryAssetCategoryRelIdComparator.getInstance((boolean)true));
        for (AssetEntryAssetCategoryRel assetEntryAssetCategoryRel : assetEntryAssetCategoryRels) {
            AssetCategory assetCategory = this._assetCategoryLocalService.fetchCategory(assetEntryAssetCategoryRel.getAssetCategoryId());
            if (assetCategory == null) continue;
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)friendlyURLEntry, (StagedModel)assetCategory, (String)"dependency");
        }
    }

    private void _importAssetCategories(PortletDataContext portletDataContext, FriendlyURLEntry friendlyURLEntry, FriendlyURLEntry importedFriendlyURL) throws Exception {
        if (friendlyURLEntry.getClassNameId() == this._portal.getClassNameId(AssetCategory.class.getName())) {
            return;
        }
        List assetCategoryElements = portletDataContext.getReferenceDataElements((StagedModel)friendlyURLEntry, AssetCategory.class);
        if (ListUtil.isEmpty((List)assetCategoryElements)) {
            return;
        }
        ArrayList<Long> assetCategoryIds = new ArrayList<Long>();
        for (Element assetCategoryElement : assetCategoryElements) {
            String assetCategoryPath = assetCategoryElement.attributeValue("path");
            AssetCategory assetCategory = (AssetCategory)portletDataContext.getZipEntryAsObject(assetCategoryPath);
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)assetCategory);
            Map assetCategoryNewPrimaryKeys = portletDataContext.getNewPrimaryKeysMap(AssetCategory.class);
            assetCategoryIds.add(MapUtil.getLong((Map)assetCategoryNewPrimaryKeys, (long)assetCategory.getCategoryId(), (long)assetCategory.getCategoryId()));
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        this._assetEntryLocalService.updateEntry(serviceContext.getUserId(), importedFriendlyURL.getGroupId(), importedFriendlyURL.getCreateDate(), importedFriendlyURL.getModifiedDate(), FriendlyURLEntry.class.getName(), importedFriendlyURL.getFriendlyURLEntryId(), importedFriendlyURL.getUuid(), 0L, ArrayUtil.toLongArray(assetCategoryIds), new String[0], true, false, null, null, null, null, "text/plain", null, null, null, null, null, 0, 0, Double.valueOf(serviceContext.getAssetPriority()));
    }
}

