/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.friendly.url.service.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.friendly.url.exception.DuplicateFriendlyURLEntryException;
import com.liferay.friendly.url.exception.FriendlyURLCategoryException;
import com.liferay.friendly.url.exception.FriendlyURLLengthException;
import com.liferay.friendly.url.exception.FriendlyURLLocalizationUrlTitleException;
import com.liferay.friendly.url.exception.NoSuchFriendlyURLEntryLocalizationException;
import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.model.FriendlyURLEntryLocalization;
import com.liferay.friendly.url.model.FriendlyURLEntryMapping;
import com.liferay.friendly.url.service.base.FriendlyURLEntryLocalServiceBaseImpl;
import com.liferay.friendly.url.service.persistence.FriendlyURLEntryMappingPersistence;
import com.liferay.friendly.url.util.comparator.FriendlyURLEntryCreateDateComparator;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizer;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.friendly.url.model.FriendlyURLEntry"}, service={AopService.class})
public class FriendlyURLEntryLocalServiceImpl
extends FriendlyURLEntryLocalServiceBaseImpl {
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private FriendlyURLEntryMappingPersistence _friendlyURLEntryMappingPersistence;
    @Reference
    private FriendlyURLNormalizer _friendlyURLNormalizer;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Language _language;

    public FriendlyURLEntry addFriendlyURLEntry(long groupId, Class<?> clazz, long classPK, String urlTitle, ServiceContext serviceContext) throws PortalException {
        return this.addFriendlyURLEntry(groupId, this._classNameLocalService.getClassNameId(clazz), classPK, urlTitle, serviceContext);
    }

    public FriendlyURLEntry addFriendlyURLEntry(long groupId, long classNameId, long classPK, Map<String, String> urlTitleMap, ServiceContext serviceContext) throws PortalException {
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
        return this.addFriendlyURLEntry(groupId, classNameId, classPK, defaultLanguageId, urlTitleMap, serviceContext);
    }

    public FriendlyURLEntry addFriendlyURLEntry(long groupId, long classNameId, long classPK, String defaultLanguageId, Map<String, String> urlTitleMap, ServiceContext serviceContext) throws PortalException {
        this.validate(groupId, classNameId, classPK, urlTitleMap);
        this._validateAssetCategories(urlTitleMap, serviceContext);
        FriendlyURLEntryMapping friendlyURLEntryMapping = this._friendlyURLEntryMappingPersistence.fetchByC_C(classNameId, classPK);
        if (friendlyURLEntryMapping == null) {
            long friendlyURLMappingId = this.counterLocalService.increment();
            friendlyURLEntryMapping = this._friendlyURLEntryMappingPersistence.create(friendlyURLMappingId);
            friendlyURLEntryMapping.setClassNameId(classNameId);
            friendlyURLEntryMapping.setClassPK(classPK);
        }
        Map<String, String> existingUrlTitleMap = this._getURLTitleMap(friendlyURLEntryMapping);
        FriendlyURLEntry friendlyURLEntry = this.friendlyURLEntryPersistence.fetchByPrimaryKey(friendlyURLEntryMapping.getFriendlyURLEntryId());
        if (friendlyURLEntry != null && this._containsAllURLTitles(existingUrlTitleMap, urlTitleMap)) {
            this._updateAssetEntry(friendlyURLEntry, serviceContext);
            return friendlyURLEntry;
        }
        Group group = this._groupLocalService.getGroup(groupId);
        long friendlyURLEntryId = this.counterLocalService.increment();
        friendlyURLEntry = this.friendlyURLEntryPersistence.create(friendlyURLEntryId);
        friendlyURLEntry.setUuid(serviceContext.getUuid());
        friendlyURLEntry.setDefaultLanguageId(defaultLanguageId);
        friendlyURLEntry.setGroupId(groupId);
        friendlyURLEntry.setCompanyId(group.getCompanyId());
        friendlyURLEntry.setClassNameId(classNameId);
        friendlyURLEntry.setClassPK(classPK);
        if (!ExportImportThreadLocal.isImportInProcess()) {
            friendlyURLEntryMapping.setFriendlyURLEntryId(friendlyURLEntryId);
            this._friendlyURLEntryMappingPersistence.update((BaseModel)friendlyURLEntryMapping);
        }
        friendlyURLEntry = (FriendlyURLEntry)this.friendlyURLEntryPersistence.update((BaseModel)friendlyURLEntry);
        this._updateFriendlyURLEntryLocalizations(friendlyURLEntry, classNameId, this._merge(urlTitleMap, existingUrlTitleMap));
        this._updateAssetEntry(friendlyURLEntry, serviceContext);
        return friendlyURLEntry;
    }

    public FriendlyURLEntry addFriendlyURLEntry(long groupId, long classNameId, long classPK, String urlTitle, ServiceContext serviceContext) throws PortalException {
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
        return this.addFriendlyURLEntry(groupId, classNameId, classPK, defaultLanguageId, Collections.singletonMap(defaultLanguageId, urlTitle), serviceContext);
    }

    public void deleteCompanyFriendlyURLEntries(long companyId, long classNameId) {
        for (FriendlyURLEntry friendlyURLEntry : this.friendlyURLEntryPersistence.findByC_C(companyId, classNameId)) {
            this._deleteFriendlyURLEntry(friendlyURLEntry);
        }
    }

    @Override
    public FriendlyURLEntry deleteFriendlyURLEntry(FriendlyURLEntry friendlyURLEntry) {
        FriendlyURLEntry deletedFriendlyURLEntry = (FriendlyURLEntry)this.friendlyURLEntryPersistence.remove((BaseModel)friendlyURLEntry);
        FriendlyURLEntryMapping friendlyURLEntryMapping = this._friendlyURLEntryMappingPersistence.fetchByC_C(friendlyURLEntry.getClassNameId(), friendlyURLEntry.getClassPK());
        if (friendlyURLEntryMapping != null && friendlyURLEntryMapping.getFriendlyURLEntryId() == friendlyURLEntry.getFriendlyURLEntryId()) {
            if ((friendlyURLEntry = this.friendlyURLEntryPersistence.fetchByG_C_C_Last(friendlyURLEntry.getGroupId(), friendlyURLEntry.getClassNameId(), friendlyURLEntry.getClassPK(), (OrderByComparator)FriendlyURLEntryCreateDateComparator.getInstance((boolean)true))) == null) {
                this._friendlyURLEntryMappingPersistence.remove((BaseModel)friendlyURLEntryMapping);
            } else {
                friendlyURLEntryMapping.setFriendlyURLEntryId(friendlyURLEntry.getFriendlyURLEntryId());
                this._friendlyURLEntryMappingPersistence.update((BaseModel)friendlyURLEntryMapping);
            }
        }
        this._deleteAssetEntry(FriendlyURLEntry.class.getName(), deletedFriendlyURLEntry.getFriendlyURLEntryId());
        return deletedFriendlyURLEntry;
    }

    @Override
    public FriendlyURLEntry deleteFriendlyURLEntry(long friendlyURLEntryId) throws PortalException {
        return this.deleteFriendlyURLEntry(this.friendlyURLEntryPersistence.findByPrimaryKey(friendlyURLEntryId));
    }

    public void deleteFriendlyURLEntry(long groupId, Class<?> clazz, long classPK) {
        this.deleteFriendlyURLEntry(groupId, this._classNameLocalService.getClassNameId(clazz), classPK);
    }

    public void deleteFriendlyURLEntry(long groupId, long classNameId, long classPK) {
        FriendlyURLEntryMapping friendlyURLEntryMapping = this._friendlyURLEntryMappingPersistence.fetchByC_C(classNameId, classPK);
        if (friendlyURLEntryMapping == null) {
            return;
        }
        List friendlyURLEntries = this.friendlyURLEntryPersistence.findByG_C_C(groupId, classNameId, classPK);
        for (FriendlyURLEntry friendlyURLEntry : friendlyURLEntries) {
            this.friendlyURLEntryPersistence.remove((BaseModel)friendlyURLEntry);
            this._deleteAssetEntry(FriendlyURLEntry.class.getName(), friendlyURLEntry.getFriendlyURLEntryId());
        }
        this._friendlyURLEntryMappingPersistence.remove((BaseModel)friendlyURLEntryMapping);
    }

    public void deleteFriendlyURLLocalizationEntry(long friendlyURLEntryId, String languageId) throws PortalException {
        this.friendlyURLEntryLocalizationPersistence.removeByFriendlyURLEntryId_LanguageId(friendlyURLEntryId, languageId);
        int count = this.friendlyURLEntryLocalizationPersistence.countByFriendlyURLEntryId(friendlyURLEntryId);
        if (count == 0) {
            FriendlyURLEntry friendlyURLEntry = this.friendlyURLEntryLocalService.fetchFriendlyURLEntry(friendlyURLEntryId);
            if (friendlyURLEntry == null) {
                return;
            }
            this.friendlyURLEntryLocalService.deleteFriendlyURLEntry(friendlyURLEntryId);
        }
        this._deleteAssetEntry(FriendlyURLEntry.class.getName(), friendlyURLEntryId);
    }

    public void deleteGroupFriendlyURLEntries(long groupId, long classNameId) {
        for (FriendlyURLEntry friendlyURLEntry : this.friendlyURLEntryPersistence.findByG_C(groupId, classNameId)) {
            this._deleteFriendlyURLEntry(friendlyURLEntry);
        }
    }

    public FriendlyURLEntry fetchFriendlyURLEntry(long groupId, Class<?> clazz, String urlTitle) {
        return this.fetchFriendlyURLEntry(groupId, this._classNameLocalService.getClassNameId(clazz), urlTitle);
    }

    public FriendlyURLEntry fetchFriendlyURLEntry(long groupId, long classNameId, String urlTitle) {
        FriendlyURLEntryLocalization friendlyURLEntryLocalization = this.friendlyURLEntryLocalizationPersistence.fetchByG_C_U_First(groupId, classNameId, this._friendlyURLNormalizer.normalizeWithEncoding(urlTitle), null);
        if (friendlyURLEntryLocalization == null) {
            return null;
        }
        return this.friendlyURLEntryPersistence.fetchByPrimaryKey(friendlyURLEntryLocalization.getFriendlyURLEntryId());
    }

    public FriendlyURLEntryLocalization fetchFriendlyURLEntryLocalization(long groupId, long classNameId, String urlTitle) {
        return this.friendlyURLEntryLocalizationPersistence.fetchByG_C_L_U(groupId, classNameId, LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault()), this._friendlyURLNormalizer.normalizeWithEncoding(urlTitle));
    }

    public FriendlyURLEntryLocalization fetchFriendlyURLEntryLocalization(long groupId, long classNameId, String languageId, String urlTitle) {
        return this.friendlyURLEntryLocalizationPersistence.fetchByG_C_L_U(groupId, classNameId, languageId, this._friendlyURLNormalizer.normalizeWithEncoding(urlTitle));
    }

    public FriendlyURLEntry fetchMainFriendlyURLEntry(long classNameId, long classPK) {
        FriendlyURLEntryMapping friendlyURLEntryMapping = this._friendlyURLEntryMappingPersistence.fetchByC_C(classNameId, classPK);
        if (friendlyURLEntryMapping == null) {
            return null;
        }
        return this.friendlyURLEntryPersistence.fetchByPrimaryKey(friendlyURLEntryMapping.getFriendlyURLEntryId());
    }

    public List<FriendlyURLEntry> getFriendlyURLEntries(long groupId, long classNameId, long classPK) {
        return this.friendlyURLEntryPersistence.findByG_C_C(groupId, classNameId, classPK);
    }

    public FriendlyURLEntryLocalization getFriendlyURLEntryLocalization(long groupId, long classNameId, String urlTitle) throws NoSuchFriendlyURLEntryLocalizationException {
        return this.friendlyURLEntryLocalizationPersistence.findByG_C_L_U(groupId, classNameId, LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault()), this._friendlyURLNormalizer.normalizeWithEncoding(urlTitle));
    }

    public FriendlyURLEntryLocalization getFriendlyURLEntryLocalization(long groupId, long classNameId, String languageId, String urlTitle) throws NoSuchFriendlyURLEntryLocalizationException {
        return this.friendlyURLEntryLocalizationPersistence.findByG_C_L_U(groupId, classNameId, languageId, this._friendlyURLNormalizer.normalizeWithEncoding(urlTitle));
    }

    public List<FriendlyURLEntryLocalization> getFriendlyURLEntryLocalizations(long groupId, long classNameId, long classPK, String languageId, int start, int end, OrderByComparator<FriendlyURLEntryLocalization> orderByComparator) {
        return this.friendlyURLEntryLocalizationPersistence.findByG_C_C_L(groupId, classNameId, classPK, languageId, start, end, orderByComparator);
    }

    public FriendlyURLEntry getMainFriendlyURLEntry(Class<?> clazz, long classPK) throws PortalException {
        return this.getMainFriendlyURLEntry(this._classNameLocalService.getClassNameId(clazz), classPK);
    }

    public FriendlyURLEntry getMainFriendlyURLEntry(long classNameId, long classPK) throws PortalException {
        FriendlyURLEntryMapping friendlyURLEntryMapping = this._friendlyURLEntryMappingPersistence.findByC_C(classNameId, classPK);
        return this.friendlyURLEntryPersistence.findByPrimaryKey(friendlyURLEntryMapping.getFriendlyURLEntryId());
    }

    public String getUniqueUrlTitle(long groupId, long classNameId, long classPK, String urlTitle, String languageId) {
        String curUrlTitle;
        if (urlTitle.startsWith("/")) {
            urlTitle = urlTitle.replaceAll("^/+", "/");
        }
        String normalizedUrlTitle = this._friendlyURLNormalizer.normalizeWithEncoding(urlTitle);
        int maxLength = ModelHintsUtil.getMaxLength((String)FriendlyURLEntryLocalization.class.getName(), (String)"urlTitle");
        String prefix = curUrlTitle = this._getURLEncodedSubstring(urlTitle, normalizedUrlTitle, maxLength);
        if (Validator.isNull((String)languageId)) {
            languageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
        }
        int i = 1;
        while (this._hasFriendlyURLEntryWithUrlTitle(groupId, classNameId, classPK, curUrlTitle, languageId)) {
            String suffix = "-" + i;
            prefix = this._getURLEncodedSubstring(urlTitle, prefix, maxLength - suffix.length());
            curUrlTitle = this._friendlyURLNormalizer.normalizeWithEncoding(prefix + suffix);
            ++i;
        }
        return curUrlTitle;
    }

    public void setMainFriendlyURLEntry(FriendlyURLEntry friendlyURLEntry) {
        FriendlyURLEntryMapping friendlyURLEntryMapping = this._friendlyURLEntryMappingPersistence.fetchByC_C(friendlyURLEntry.getClassNameId(), friendlyURLEntry.getClassPK());
        if (friendlyURLEntryMapping == null) {
            long friendlyURLEntryMappingId = this.counterLocalService.increment();
            friendlyURLEntryMapping = this._friendlyURLEntryMappingPersistence.create(friendlyURLEntryMappingId);
            friendlyURLEntryMapping.setClassNameId(friendlyURLEntry.getClassNameId());
            friendlyURLEntryMapping.setClassPK(friendlyURLEntry.getClassPK());
        }
        friendlyURLEntryMapping.setFriendlyURLEntryId(friendlyURLEntry.getFriendlyURLEntryId());
        this._friendlyURLEntryMappingPersistence.update((BaseModel)friendlyURLEntryMapping);
    }

    public FriendlyURLEntry updateFriendlyURLEntry(long friendlyURLEntryId, long classNameId, long classPK, String defaultLanguageId, Map<String, String> urlTitleMap) throws PortalException {
        return this.updateFriendlyURLEntry(friendlyURLEntryId, classNameId, classPK, defaultLanguageId, urlTitleMap, null);
    }

    public FriendlyURLEntry updateFriendlyURLEntry(long friendlyURLEntryId, long classNameId, long classPK, String defaultLanguageId, Map<String, String> urlTitleMap, ServiceContext serviceContext) throws PortalException {
        FriendlyURLEntry friendlyURLEntry = this.friendlyURLEntryPersistence.findByPrimaryKey(friendlyURLEntryId);
        this.validate(friendlyURLEntry.getGroupId(), classNameId, classPK, urlTitleMap);
        this._validateAssetCategories(urlTitleMap, serviceContext);
        friendlyURLEntry.setDefaultLanguageId(defaultLanguageId);
        friendlyURLEntry.setClassNameId(classNameId);
        friendlyURLEntry.setClassPK(classPK);
        friendlyURLEntry = (FriendlyURLEntry)this.friendlyURLEntryPersistence.update((BaseModel)friendlyURLEntry);
        this._updateFriendlyURLEntryLocalizations(friendlyURLEntry, classNameId, urlTitleMap);
        this._updateAssetEntry(friendlyURLEntry, serviceContext);
        return friendlyURLEntry;
    }

    public FriendlyURLEntryLocalization updateFriendlyURLLocalization(FriendlyURLEntryLocalization friendlyURLEntryLocalization) {
        return (FriendlyURLEntryLocalization)this.friendlyURLEntryLocalizationPersistence.update((BaseModel)friendlyURLEntryLocalization);
    }

    public FriendlyURLEntryLocalization updateFriendlyURLLocalization(long friendlyURLLocalizationId, String urlTitle) throws PortalException {
        FriendlyURLEntryLocalization friendlyURLEntryLocalization = this.friendlyURLEntryLocalizationPersistence.fetchByPrimaryKey(friendlyURLLocalizationId);
        if (friendlyURLEntryLocalization == null) {
            return null;
        }
        friendlyURLEntryLocalization.setUrlTitle(urlTitle);
        return (FriendlyURLEntryLocalization)this.friendlyURLEntryLocalizationPersistence.update((BaseModel)friendlyURLEntryLocalization);
    }

    public void validate(long groupId, long classNameId, long classPK, Map<String, String> urlTitleMap) throws PortalException {
        for (Map.Entry<String, String> entry : urlTitleMap.entrySet()) {
            this.validate(groupId, classNameId, classPK, entry.getKey(), entry.getValue());
        }
    }

    public void validate(long groupId, long classNameId, long classPK, String urlTitle) throws PortalException {
        this.validate(groupId, classNameId, classPK, LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault()), urlTitle);
    }

    public void validate(long groupId, long classNameId, long classPK, String languageId, String urlTitle) throws PortalException {
        if (urlTitle.endsWith("/")) {
            throw new FriendlyURLLocalizationUrlTitleException.MustNotHaveTrailingSlash();
        }
        int maxLength = ModelHintsUtil.getMaxLength((String)FriendlyURLEntryLocalization.class.getName(), (String)"urlTitle");
        String normalizedUrlTitle = this._friendlyURLNormalizer.normalizeWithEncoding(urlTitle);
        if (normalizedUrlTitle.length() > maxLength) {
            throw new FriendlyURLLengthException(urlTitle + " is longer than " + maxLength);
        }
        FriendlyURLEntryLocalization existingFriendlyURLEntryLocalization = this.friendlyURLEntryLocalizationPersistence.fetchByG_C_L_U(groupId, classNameId, languageId, normalizedUrlTitle);
        if (existingFriendlyURLEntryLocalization != null && existingFriendlyURLEntryLocalization.getClassPK() != classPK) {
            throw new DuplicateFriendlyURLEntryException(existingFriendlyURLEntryLocalization.toString());
        }
    }

    public void validate(long groupId, long classNameId, String urlTitle) throws PortalException {
        this.validate(groupId, classNameId, 0L, LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault()), urlTitle);
    }

    private boolean _containsAllURLTitles(Map<String, String> existingUrlTitleMap, Map<String, String> urlTitleMap) {
        for (Map.Entry<String, String> entry : urlTitleMap.entrySet()) {
            String urlTitle = this._friendlyURLNormalizer.normalizeWithEncoding(entry.getValue());
            if (urlTitle.equals(existingUrlTitleMap.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private void _deleteAssetEntry(String className, long classPK) {
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(className, classPK);
        if (assetEntry == null) {
            return;
        }
        try {
            this._assetEntryLocalService.deleteEntry(assetEntry.getEntryId());
        }
        catch (PortalException portalException) {
            ReflectionUtil.throwException((Throwable)portalException);
        }
    }

    private void _deleteFriendlyURLEntry(FriendlyURLEntry friendlyURLEntry) {
        this.friendlyURLEntryLocalizationPersistence.removeByFriendlyURLEntryId(friendlyURLEntry.getFriendlyURLEntryId());
        this.friendlyURLEntryPersistence.remove((BaseModel)friendlyURLEntry);
        FriendlyURLEntryMapping friendlyURLEntryMapping = this._friendlyURLEntryMappingPersistence.fetchByC_C(friendlyURLEntry.getClassNameId(), friendlyURLEntry.getClassPK());
        if (friendlyURLEntryMapping != null && friendlyURLEntryMapping.getFriendlyURLEntryId() == friendlyURLEntry.getFriendlyURLEntryId()) {
            this._friendlyURLEntryMappingPersistence.remove((BaseModel)friendlyURLEntryMapping);
        }
        this._deleteAssetEntry(FriendlyURLEntry.class.getName(), friendlyURLEntry.getFriendlyURLEntryId());
    }

    private String _getURLEncodedSubstring(String decodedString, String encodedString, int maxLength) {
        int endPos = decodedString.length();
        while (encodedString.length() > maxLength) {
            if (--endPos > 0 && Character.isHighSurrogate(decodedString.charAt(endPos - 1))) {
                --endPos;
            }
            encodedString = this._friendlyURLNormalizer.normalizeWithEncoding(decodedString.substring(0, endPos));
        }
        return encodedString;
    }

    private Map<String, String> _getURLTitleMap(FriendlyURLEntryMapping friendlyURLEntryMapping) {
        HashMap<String, String> urlTitleMap = new HashMap<String, String>();
        for (FriendlyURLEntryLocalization friendlyURLEntryLocalization : this.friendlyURLEntryLocalizationPersistence.findByFriendlyURLEntryId(friendlyURLEntryMapping.getFriendlyURLEntryId())) {
            urlTitleMap.put(friendlyURLEntryLocalization.getLanguageId(), friendlyURLEntryLocalization.getUrlTitle());
        }
        return urlTitleMap;
    }

    private boolean _hasFriendlyURLEntryWithUrlTitle(long groupId, long classNameId, long notClassPK, String urlTitle, String languageId) {
        FriendlyURLEntryLocalization friendlyURLEntryLocalization = this.friendlyURLEntryLocalizationPersistence.fetchByG_C_L_U(groupId, classNameId, languageId, urlTitle);
        if (friendlyURLEntryLocalization != null && friendlyURLEntryLocalization.getClassPK() != notClassPK) {
            return true;
        }
        friendlyURLEntryLocalization = this.friendlyURLEntryLocalizationPersistence.fetchByG_C_NotL_U_First(groupId, classNameId, languageId, urlTitle, null);
        return friendlyURLEntryLocalization != null && friendlyURLEntryLocalization.getClassPK() != notClassPK;
    }

    private Map<String, String> _merge(Map<String, String> masterMap, Map<String, String> copyMap) {
        HashMap<String, String> map = new HashMap<String, String>(copyMap);
        MapUtil.merge(masterMap, map);
        return map;
    }

    private Map<String, String> _sortUrlTitleMap(long groupId, Map<String, String> urlTitleMap) {
        LinkedHashMap<String, String> sortedUrlTitleMap = new LinkedHashMap<String, String>();
        for (Locale locale : this._language.getAvailableLocales(groupId)) {
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            String value = urlTitleMap.get(languageId);
            if (value == null) continue;
            sortedUrlTitleMap.put(languageId, value);
        }
        return sortedUrlTitleMap;
    }

    private void _updateAssetEntry(FriendlyURLEntry friendlyURLEntry, ServiceContext serviceContext) throws PortalException {
        if (serviceContext == null) {
            return;
        }
        Map attributes = serviceContext.getAttributes();
        if (attributes.containsKey("friendlyURLAssetCategoryIds")) {
            this._assetEntryLocalService.updateEntry(serviceContext.getUserId(), friendlyURLEntry.getGroupId(), friendlyURLEntry.getCreateDate(), friendlyURLEntry.getModifiedDate(), FriendlyURLEntry.class.getName(), friendlyURLEntry.getFriendlyURLEntryId(), friendlyURLEntry.getUuid(), 0L, GetterUtil.getLongValues((Object)serviceContext.getAttribute("friendlyURLAssetCategoryIds")), new String[0], true, false, null, null, null, null, "text/plain", null, null, null, null, null, 0, 0, Double.valueOf(serviceContext.getAssetPriority()));
        }
    }

    private void _updateFriendlyURLEntryLocalizations(FriendlyURLEntry friendlyURLEntry, long classNameId, Map<String, String> urlTitleMap) throws PortalException {
        urlTitleMap = this._sortUrlTitleMap(friendlyURLEntry.getGroupId(), urlTitleMap);
        for (Map.Entry<String, String> entry : urlTitleMap.entrySet()) {
            FriendlyURLEntryLocalization friendlyURLEntryLocalization;
            String defaultLanguageId;
            String oldURLTitle = entry.getValue();
            String normalizedUrlTitle = this._friendlyURLNormalizer.normalizeWithEncoding(oldURLTitle);
            if (Validator.isNotNull((String)normalizedUrlTitle)) {
                FriendlyURLEntryLocalization existingFriendlyURLEntryLocalization = this.friendlyURLEntryLocalizationPersistence.fetchByG_C_L_U(friendlyURLEntry.getGroupId(), classNameId, entry.getKey(), normalizedUrlTitle);
                if (existingFriendlyURLEntryLocalization != null) {
                    String existingUrlTitle = existingFriendlyURLEntryLocalization.getUrlTitle();
                    if (!existingUrlTitle.equals(oldURLTitle)) continue;
                    existingFriendlyURLEntryLocalization.setFriendlyURLEntryId(friendlyURLEntry.getFriendlyURLEntryId());
                    this.updateFriendlyURLLocalization(existingFriendlyURLEntryLocalization);
                    continue;
                }
                this.updateFriendlyURLEntryLocalization(friendlyURLEntry, entry.getKey(), normalizedUrlTitle);
                continue;
            }
            if (normalizedUrlTitle == null || !normalizedUrlTitle.equals("") || (defaultLanguageId = friendlyURLEntry.getDefaultLanguageId()).equals(entry.getKey()) || (friendlyURLEntryLocalization = this.friendlyURLEntryLocalizationPersistence.fetchByFriendlyURLEntryId_LanguageId(friendlyURLEntry.getFriendlyURLEntryId(), entry.getKey())) == null) continue;
            this.deleteFriendlyURLLocalizationEntry(friendlyURLEntry.getFriendlyURLEntryId(), entry.getKey());
        }
    }

    private void _validateAssetCategories(Map<String, String> urlTitleMap, ServiceContext serviceContext) throws PortalException {
        if (serviceContext == null) {
            return;
        }
        long[] friendlyURLAssetCategoryIds = GetterUtil.getLongValues((Object)serviceContext.getAttribute("friendlyURLAssetCategoryIds"));
        if (ArrayUtil.isEmpty((long[])friendlyURLAssetCategoryIds)) {
            return;
        }
        for (Map.Entry<String, String> entry : urlTitleMap.entrySet()) {
            String value = entry.getValue();
            if (!value.contains("/")) continue;
            throw new FriendlyURLCategoryException();
        }
    }
}

