/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.friendly.url.internal.exportimport.data.handler;

import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class FriendlyURLEntryStagedModelDataHandler
extends BaseStagedModelDataHandler<FriendlyURLEntry> {
    public static final String[] CLASS_NAMES = new String[]{FriendlyURLEntry.class.getName()};
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private FriendlyURLEntryLocalService _friendlyURLEntryLocalService;
    @Reference(target="(model.class.name=com.liferay.friendly.url.model.FriendlyURLEntry)")
    private StagedModelRepository<FriendlyURLEntry> _stagedModelRepository;

    public FriendlyURLEntry fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return (FriendlyURLEntry)this._stagedModelRepository.fetchStagedModelByUuidAndGroupId(uuid, groupId);
    }

    public List<FriendlyURLEntry> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._stagedModelRepository.fetchStagedModelsByUuidAndCompanyId(uuid, companyId);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, FriendlyURLEntry friendlyURLEntry) throws Exception {
        Element friendlyURLEntryElement = portletDataContext.getExportDataElement((ClassedModel)friendlyURLEntry);
        friendlyURLEntryElement.addAttribute("resource-class-name", friendlyURLEntry.getClassName());
        String modelPath = ExportImportPathUtil.getModelPath((StagedModel)friendlyURLEntry, (String)friendlyURLEntry.getUuid());
        portletDataContext.addZipEntry(modelPath, friendlyURLEntry.getUrlTitleMapAsXML());
        if (friendlyURLEntry.isMain()) {
            friendlyURLEntryElement.addAttribute("mainEntry", Boolean.TRUE.toString());
        }
        portletDataContext.addClassedModel(friendlyURLEntryElement, ExportImportPathUtil.getModelPath((StagedModel)friendlyURLEntry), (ClassedModel)friendlyURLEntry);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, FriendlyURLEntry friendlyURLEntry) throws Exception {
        Element friendlyURLEntryElement = portletDataContext.getImportDataStagedModelElement((StagedModel)friendlyURLEntry);
        String className = friendlyURLEntryElement.attributeValue("resource-class-name");
        long classNameId = this._classNameLocalService.getClassNameId(className);
        Map newPrimaryKeysMap = portletDataContext.getNewPrimaryKeysMap(className);
        FriendlyURLEntry existingFriendlyURLEntry = this.fetchStagedModelByUuidAndGroupId(friendlyURLEntry.getUuid(), portletDataContext.getScopeGroupId());
        FriendlyURLEntry importedFriendlyURLEntry = null;
        if (existingFriendlyURLEntry == null || !portletDataContext.isDataStrategyMirror()) {
            importedFriendlyURLEntry = (FriendlyURLEntry)friendlyURLEntry.clone();
            importedFriendlyURLEntry.setGroupId(portletDataContext.getScopeGroupId());
            importedFriendlyURLEntry.setCompanyId(portletDataContext.getCompanyId());
            importedFriendlyURLEntry.setClassNameId(classNameId);
            long classPK = MapUtil.getLong((Map)newPrimaryKeysMap, (long)friendlyURLEntry.getClassPK(), (long)friendlyURLEntry.getClassPK());
            importedFriendlyURLEntry.setClassPK(classPK);
            importedFriendlyURLEntry.setDefaultLanguageId(friendlyURLEntry.getDefaultLanguageId());
            importedFriendlyURLEntry = (FriendlyURLEntry)this._stagedModelRepository.addStagedModel(portletDataContext, (StagedModel)importedFriendlyURLEntry);
        } else {
            importedFriendlyURLEntry = (FriendlyURLEntry)this._stagedModelRepository.updateStagedModel(portletDataContext, (StagedModel)existingFriendlyURLEntry);
            boolean mainEntry = GetterUtil.getBoolean((String)friendlyURLEntryElement.attributeValue("mainEntry"));
            if (mainEntry) {
                this._friendlyURLEntryLocalService.setMainFriendlyURLEntry(existingFriendlyURLEntry);
            }
        }
        portletDataContext.importClassedModel((ClassedModel)friendlyURLEntry, (ClassedModel)importedFriendlyURLEntry);
    }

    protected StagedModelRepository<FriendlyURLEntry> getStagedModelRepository() {
        return this._stagedModelRepository;
    }
}

