/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.friendly.url.internal.exportimport.staged.model.repository;

import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.exportimport.staged.model.repository.StagedModelRepositoryHelper;
import com.liferay.friendly.url.internal.exportimport.lar.FriendlyURLExportImportPathUtil;
import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.model.FriendlyURLEntryLocalization;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.friendly.url.model.FriendlyURLEntry"}, service={StagedModelRepository.class})
public class FriendlyURLEntryStagedModelRepository
implements StagedModelRepository<FriendlyURLEntry> {
    @Reference
    private FriendlyURLEntryLocalService _friendlyURLEntryLocalService;
    @Reference
    private Language _language;
    @Reference
    private StagedModelRepositoryHelper _stagedModelRepositoryHelper;

    public FriendlyURLEntry addStagedModel(PortletDataContext portletDataContext, FriendlyURLEntry friendlyURLEntry) throws PortalException {
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)friendlyURLEntry);
        if (portletDataContext.isDataStrategyMirror()) {
            serviceContext.setUuid(friendlyURLEntry.getUuid());
        }
        return this._friendlyURLEntryLocalService.addFriendlyURLEntry(friendlyURLEntry.getGroupId(), friendlyURLEntry.getClassNameId(), friendlyURLEntry.getClassPK(), this._getLocalizationMap(portletDataContext, friendlyURLEntry), serviceContext);
    }

    public void deleteStagedModel(FriendlyURLEntry friendlyURLEntry) {
        this._friendlyURLEntryLocalService.deleteFriendlyURLEntry(friendlyURLEntry);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) {
        FriendlyURLEntry friendlyURLEntry = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (friendlyURLEntry != null) {
            this.deleteStagedModel(friendlyURLEntry);
        }
    }

    public void deleteStagedModels(PortletDataContext portletDataContext) {
        Map parameterMap = portletDataContext.getParameterMap();
        long classNameId = MapUtil.getLong((Map)parameterMap, (String)"parentStagedModelClassNameId");
        this._friendlyURLEntryLocalService.deleteGroupFriendlyURLEntries(portletDataContext.getGroupId(), classNameId);
    }

    public FriendlyURLEntry fetchMissingReference(String uuid, long groupId) {
        return (FriendlyURLEntry)this._stagedModelRepositoryHelper.fetchMissingReference(uuid, groupId, (StagedModelRepository)this);
    }

    public FriendlyURLEntry fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._friendlyURLEntryLocalService.fetchFriendlyURLEntryByUuidAndGroupId(uuid, groupId);
    }

    public List<FriendlyURLEntry> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._friendlyURLEntryLocalService.getFriendlyURLEntriesByUuidAndCompanyId(uuid, companyId);
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(PortletDataContext portletDataContext) {
        return this._friendlyURLEntryLocalService.getExportActionableDynamicQuery(portletDataContext);
    }

    public FriendlyURLEntry getStagedModel(long friendlyURLEntryId) throws PortalException {
        return this._friendlyURLEntryLocalService.getFriendlyURLEntry(friendlyURLEntryId);
    }

    public void restoreStagedModel(PortletDataContext portletDataContext, FriendlyURLEntry stagedModel) {
    }

    public FriendlyURLEntry saveStagedModel(FriendlyURLEntry friendlyURLEntry) {
        List friendlyURLEntryLocalizations = this._friendlyURLEntryLocalService.getFriendlyURLEntryLocalizations(friendlyURLEntry.getFriendlyURLEntryId());
        for (FriendlyURLEntryLocalization friendlyURLEntryLocalization : friendlyURLEntryLocalizations) {
            friendlyURLEntryLocalization.setUrlTitle(this._friendlyURLEntryLocalService.getUniqueUrlTitle(friendlyURLEntry.getGroupId(), friendlyURLEntry.getClassNameId(), friendlyURLEntry.getClassPK(), friendlyURLEntryLocalization.getUrlTitle()));
            this._friendlyURLEntryLocalService.updateFriendlyURLLocalization(friendlyURLEntryLocalization);
        }
        return this._friendlyURLEntryLocalService.updateFriendlyURLEntry(friendlyURLEntry);
    }

    public FriendlyURLEntry updateStagedModel(PortletDataContext portletDataContext, FriendlyURLEntry friendlyURLEntry) throws PortalException {
        return this._friendlyURLEntryLocalService.updateFriendlyURLEntry(friendlyURLEntry.getFriendlyURLEntryId(), friendlyURLEntry.getClassNameId(), friendlyURLEntry.getClassPK(), friendlyURLEntry.getDefaultLanguageId(), this._getLocalizationMap(portletDataContext, friendlyURLEntry));
    }

    private Map<String, String> _getLocalizationMap(PortletDataContext portletDataContext, FriendlyURLEntry friendlyURLEntry) {
        String modelPath = FriendlyURLExportImportPathUtil.getModelPath(portletDataContext, friendlyURLEntry);
        Map localeLocalizationMap = LocalizationUtil.getLocalizationMap((String)portletDataContext.getZipEntryAsString(modelPath));
        HashMap<String, String> languageIdLocalizationMap = new HashMap<String, String>(localeLocalizationMap.size());
        for (Map.Entry entry : localeLocalizationMap.entrySet()) {
            String urlTitle = (String)entry.getValue();
            FriendlyURLEntry existingFriendlyURLEntry = this._friendlyURLEntryLocalService.fetchFriendlyURLEntry(friendlyURLEntry.getGroupId(), friendlyURLEntry.getClassNameId(), urlTitle);
            if (existingFriendlyURLEntry != null) {
                urlTitle = this._friendlyURLEntryLocalService.getUniqueUrlTitle(friendlyURLEntry.getGroupId(), friendlyURLEntry.getClassNameId(), friendlyURLEntry.getClassPK(), urlTitle);
            }
            languageIdLocalizationMap.put(this._language.getLanguageId((Locale)entry.getKey()), urlTitle);
        }
        return languageIdLocalizationMap;
    }
}

