/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.editable.internal.parser;

import com.liferay.fragment.entry.processor.editable.internal.parser.BaseEditableElementParser;
import com.liferay.fragment.entry.processor.editable.parser.EditableElementParser;
import com.liferay.fragment.exception.FragmentEntryContentException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Objects;
import java.util.ResourceBundle;
import org.jsoup.nodes.Element;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"type=action"}, service={EditableElementParser.class})
public class ActionEditableElementParser
extends BaseEditableElementParser {
    @Reference
    private Language _language;

    public String getValue(Element element) {
        String html = element.html();
        if (Validator.isNull((String)html.trim())) {
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
            return this._language.get(resourceBundle, "example-action");
        }
        return html;
    }

    public void replace(Element element, String value) {
        element.html(value);
    }

    @Override
    public void validate(Element element) throws FragmentEntryContentException {
        if (!Objects.equals(element.tagName(), "button")) {
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
            throw new FragmentEntryContentException(this._language.format(resourceBundle, "an-editable-of-type-x-can-only-be-used-in-a-tag-of-type-x", new Object[]{"action", "button"}, false));
        }
        super.validate(element);
    }
}

