/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.staging.permission;

import com.liferay.exportimport.kernel.staging.permission.StagingPermission;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.PropsValues;
import com.liferay.portal.kernel.util.Validator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StagingPermission.class})
public class StagingPermissionImpl
implements StagingPermission {
    private static final Log _log = LogFactoryUtil.getLog(StagingPermissionImpl.class);
    @Reference
    private GroupLocalService _groupLocalService;

    public Boolean hasPermission(PermissionChecker permissionChecker, Group group, String className, long classPK, String portletId, String actionId) {
        try {
            return this._hasPermission(group, portletId, actionId);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return null;
        }
    }

    public Boolean hasPermission(PermissionChecker permissionChecker, long groupId, String className, long classPK, String portletId, String actionId) {
        try {
            return this._hasPermission(this._groupLocalService.getGroup(groupId), portletId, actionId);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return null;
        }
    }

    private Boolean _hasPermission(Group group, String portletId, String actionId) throws Exception {
        if (!PropsValues.STAGING_LIVE_GROUP_LOCKING_ENABLED) {
            return null;
        }
        if (!(actionId.equals("ACCESS") || actionId.equals("ACCESS_IN_CONTROL_PANEL") || actionId.equals("ADD_DISCUSSION") || actionId.equals("ADD_TO_PAGE") || actionId.equals("ASSIGN_MEMBERS") || actionId.equals("CONFIGURATION") || actionId.equals("CUSTOMIZE") || actionId.equals("DELETE") || actionId.equals("DELETE_DISCUSSION") || actionId.equals("DOWNLOAD") || actionId.equals("UPDATE_DISCUSSION") || actionId.equals("VIEW") || !group.hasLocalOrRemoteStagingGroup() || !Validator.isNull((String)portletId) && !group.isStagedPortlet(portletId))) {
            return false;
        }
        return null;
    }
}

