/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.data.handler;

import com.liferay.exportimport.internal.data.handler.BatchEnginePortletDataHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BatchEnginePortletDataHandlerRegistryUtil {
    private static final Map<String, BatchEnginePortletDataHandler> _batchEnginePortletDataHandlers = new ConcurrentHashMap<String, BatchEnginePortletDataHandler>();

    public static BatchEnginePortletDataHandler getByClassName(String className) {
        String portletId = BatchEnginePortletDataHandlerRegistryUtil._getPortletId(className);
        if (portletId == null) {
            return null;
        }
        return _batchEnginePortletDataHandlers.get(portletId);
    }

    public static BatchEnginePortletDataHandler getByPortletId(String portletId) {
        return _batchEnginePortletDataHandlers.get(portletId);
    }

    public static boolean hasByClassName(String className) {
        return BatchEnginePortletDataHandlerRegistryUtil._getPortletId(className) != null;
    }

    protected static void put(String portletId, BatchEnginePortletDataHandler batchEnginePortletDataHandler) {
        _batchEnginePortletDataHandlers.put(portletId, batchEnginePortletDataHandler);
    }

    protected static void remove(String portletId) {
        _batchEnginePortletDataHandlers.remove(portletId);
    }

    private static String _getPortletId(String className) {
        for (Map.Entry<String, BatchEnginePortletDataHandler> entry : _batchEnginePortletDataHandlers.entrySet()) {
            String[] classNames;
            BatchEnginePortletDataHandler batchEnginePortletDataHandler = entry.getValue();
            for (String currentClassName : classNames = batchEnginePortletDataHandler.getClassNames()) {
                if (!currentClassName.equals(className)) continue;
                return entry.getKey();
            }
        }
        return null;
    }
}

