/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.background.task;

import com.liferay.exportimport.internal.background.task.BaseStagingBackgroundTaskExecutor;
import com.liferay.exportimport.internal.background.task.PortletStagingBackgroundTaskStatusMessageTranslator;
import com.liferay.exportimport.internal.background.task.display.PortletExportImportBackgroundTaskDisplay;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleManagerUtil;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportLocalService;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.backgroundtask.display.BackgroundTaskDisplay;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.Callable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"background.task.executor.class.name=com.liferay.exportimport.internal.background.task.PortletStagingBackgroundTaskExecutor"}, service={BackgroundTaskExecutor.class})
public class PortletStagingBackgroundTaskExecutor
extends BaseStagingBackgroundTaskExecutor {
    @Reference
    private ExportImportLocalService _exportImportLocalService;

    public PortletStagingBackgroundTaskExecutor() {
        this.setBackgroundTaskStatusMessageTranslator(new PortletStagingBackgroundTaskStatusMessageTranslator());
    }

    public BackgroundTaskExecutor clone() {
        return this;
    }

    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        MissingReferences missingReferences;
        ExportImportConfiguration exportImportConfiguration = this.getExportImportConfiguration(backgroundTask);
        File file = null;
        try {
            ExportImportThreadLocal.setPortletStagingInProcess((boolean)true);
            ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent((int)21, (int)36, (String)String.valueOf(exportImportConfiguration.getExportImportConfigurationId()), (Serializable[])new Serializable[]{exportImportConfiguration});
            file = this._exportImportLocalService.exportPortletInfoAsFile(exportImportConfiguration);
            this.markBackgroundTask(backgroundTask.getBackgroundTaskId(), "exported");
            missingReferences = (MissingReferences)TransactionInvokerUtil.invoke((TransactionConfig)transactionConfig, (Callable)new PortletStagingCallable(backgroundTask.getBackgroundTaskId(), exportImportConfiguration, file));
            this.deleteExportedChangesetEntries();
            ExportImportThreadLocal.setPortletStagingInProcess((boolean)false);
            ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent((int)20, (int)36, (String)String.valueOf(exportImportConfiguration.getExportImportConfigurationId()), (Serializable[])new Serializable[]{exportImportConfiguration});
        }
        catch (Throwable throwable) {
            ExportImportThreadLocal.setPortletStagingInProcess((boolean)false);
            ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent((int)19, (int)36, (String)String.valueOf(exportImportConfiguration.getExportImportConfigurationId()), (Serializable[])new Serializable[]{exportImportConfiguration});
            this.deleteTempLarOnFailure(file);
            throw new SystemException(throwable);
        }
        this.deleteTempLarOnSuccess(file);
        return this.processMissingReferences(backgroundTask.getBackgroundTaskId(), missingReferences);
    }

    @Override
    public BackgroundTaskDisplay getBackgroundTaskDisplay(BackgroundTask backgroundTask) {
        return new PortletExportImportBackgroundTaskDisplay(backgroundTask);
    }

    private class PortletStagingCallable
    implements Callable<MissingReferences> {
        private final long _backgroundTaskId;
        private final ExportImportConfiguration _exportImportConfiguration;
        private final File _file;

        public PortletStagingCallable(long backgroundTaskId, ExportImportConfiguration exportImportConfiguration, File file) {
            this._backgroundTaskId = backgroundTaskId;
            this._exportImportConfiguration = exportImportConfiguration;
            this._file = file;
        }

        @Override
        public MissingReferences call() throws PortalException {
            PortletStagingBackgroundTaskExecutor.this._exportImportLocalService.importPortletDataDeletions(this._exportImportConfiguration, this._file);
            MissingReferences missingReferences = PortletStagingBackgroundTaskExecutor.this._exportImportLocalService.validateImportPortletInfo(this._exportImportConfiguration, this._file);
            PortletStagingBackgroundTaskExecutor.this.markBackgroundTask(this._backgroundTaskId, "validated");
            PortletStagingBackgroundTaskExecutor.this._exportImportLocalService.importPortletInfo(this._exportImportConfiguration, this._file);
            return missingReferences;
        }
    }
}

