/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.portlet.data.handler.provider;

import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.portlet.data.handler.provider.PortletDataHandlerProvider;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.util.Validator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PortletDataHandlerProvider.class})
public class PortletDataHandlerProviderImpl
implements PortletDataHandlerProvider {
    private static final Log _log = LogFactoryUtil.getLog(PortletDataHandlerProviderImpl.class);
    @Reference
    private PortletLocalService _portletLocalService;

    public PortletDataHandler provide(long companyId, String portletId) {
        if (companyId <= 0L || Validator.isNull((String)portletId)) {
            return null;
        }
        Portlet portlet = this._portletLocalService.getPortletById(companyId, portletId);
        return this._provide(portlet);
    }

    public PortletDataHandler provide(Portlet portlet) {
        return this._provide(portlet);
    }

    public PortletDataHandler provide(String portletId) {
        if (Validator.isNull((String)portletId)) {
            return null;
        }
        Portlet portlet = this._portletLocalService.getPortletById(portletId);
        return this._provide(portlet);
    }

    private PortletDataHandler _provide(Portlet portlet) {
        if (portlet == null || !portlet.isActive() || portlet.isUndeployedPortlet()) {
            return null;
        }
        try {
            return portlet.getPortletDataHandlerInstance();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return null;
        }
    }
}

