/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.attachment;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.exportimport.attachment.ExportImportAttachmentManager;
import com.liferay.exportimport.internal.lar.PortletDataContextThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.osgi.service.component.annotations.Component;

@Component(service={ExportImportAttachmentManager.class})
public class ExportImportAttachmentManagerImpl
implements ExportImportAttachmentManager {
    private static final String _PROTOCOL = "lar";

    public String getFileURL(DLFileEntry dlFileEntry) throws Exception {
        PortletDataContext portletDataContext = PortletDataContextThreadLocal.getPortletDataContext();
        if (portletDataContext == null || portletDataContext.getZipWriter() == null) {
            return null;
        }
        try (InputStream inputStream = dlFileEntry.getContentStream();){
            String fileKey = String.valueOf(dlFileEntry.getFileEntryId());
            portletDataContext.addZipEntry(this._getZipPath(fileKey), inputStream);
            String string = "lar:" + fileKey;
            return string;
        }
    }

    public URL getURL(String url) throws MalformedURLException {
        final PortletDataContext portletDataContext = PortletDataContextThreadLocal.getPortletDataContext();
        if (!url.startsWith("lar:") || portletDataContext == null) {
            return new URL(url);
        }
        return new URL(null, url, new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL url) {
                return new URLConnection(url){

                    @Override
                    public void connect() {
                    }

                    @Override
                    public InputStream getInputStream() {
                        return portletDataContext.getZipEntryAsInputStream(ExportImportAttachmentManagerImpl.this._getZipPath(this.url.getPath()));
                    }
                };
            }
        });
    }

    private String _getZipPath(String key) {
        return "batch-binaries/" + key;
    }
}

