/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.background.task;

import com.liferay.exportimport.internal.background.task.BaseExportImportBackgroundTaskExecutor;
import com.liferay.exportimport.internal.background.task.LayoutExportImportBackgroundTaskStatusMessageTranslator;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportLocalService;
import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.layout.set.prototype.configuration.LayoutSetPrototypeConfiguration;
import com.liferay.layout.set.prototype.configuration.LayoutSetPrototypeSystemConfiguration;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManager;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalService;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.layout.set.prototype.configuration.LayoutSetPrototypeSystemConfiguration"}, property={"background.task.executor.class.name=com.liferay.exportimport.internal.background.task.LayoutSetPrototypeImportBackgroundTaskExecutor"}, service={BackgroundTaskExecutor.class})
public class LayoutSetPrototypeImportBackgroundTaskExecutor
extends BaseExportImportBackgroundTaskExecutor {
    private static final Log _log = LogFactoryUtil.getLog(LayoutSetPrototypeImportBackgroundTaskExecutor.class);
    @Reference
    private BackgroundTaskManager _backgroundTaskManager;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private ExportImportLocalService _exportImportLocalService;
    @Reference
    private com.liferay.portal.kernel.util.File _file;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;
    @Reference
    private LayoutSetPrototypeLocalService _layoutSetPrototypeLocalService;

    public BackgroundTaskExecutor clone() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        ExportImportThreadLocal.setLayoutImportInProcess((boolean)true);
        try {
            if (this.isCancelPropagationImportTask()) {
                List newBackgroundTasks = this._backgroundTaskManager.getBackgroundTasks(backgroundTask.getGroupId(), LayoutSetPrototypeImportBackgroundTaskExecutor.class.getName(), 0);
                List queuedBackgroundTasks = this._backgroundTaskManager.getBackgroundTasks(backgroundTask.getGroupId(), LayoutSetPrototypeImportBackgroundTaskExecutor.class.getName(), 4);
                if (!newBackgroundTasks.isEmpty() || !queuedBackgroundTasks.isEmpty()) {
                    StringBundler sb;
                    if (_log.isDebugEnabled()) {
                        sb = new StringBundler(7);
                        sb.append("Cancelling background task ");
                        sb.append(backgroundTask.getBackgroundTaskId());
                        sb.append(", found ");
                        sb.append(newBackgroundTasks.size());
                        sb.append(" new and ");
                        sb.append(queuedBackgroundTasks.size());
                        sb.append(" queued tasks");
                        _log.debug((Object)sb.toString());
                    }
                    sb = new BackgroundTaskResult(5);
                    return sb;
                }
            }
            ExportImportConfiguration exportImportConfiguration = this.getExportImportConfiguration(backgroundTask);
            List attachmentsFileEntries = backgroundTask.getAttachmentsFileEntries();
            File file = null;
            for (FileEntry attachmentsFileEntry : attachmentsFileEntries) {
                try {
                    file = this._file.createTempFile("lar");
                    this._file.write(file, attachmentsFileEntry.getContentStream());
                    TransactionInvokerUtil.invoke((TransactionConfig)transactionConfig, (Callable)new LayoutImportCallable(exportImportConfiguration, file));
                }
                catch (Throwable throwable) {
                    Map settingsMap = exportImportConfiguration.getSettingsMap();
                    Map parameterMap = (Map)settingsMap.get("parameterMap");
                    long layoutSetPrototypeId = MapUtil.getLong((Map)parameterMap, (String)"layoutSetPrototypeId");
                    LayoutSetPrototype layoutSetPrototype = this._layoutSetPrototypeLocalService.getLayoutSetPrototype(layoutSetPrototypeId);
                    LayoutSet layoutSetPrototypeLayoutSet = layoutSetPrototype.getLayoutSet();
                    UnicodeProperties layoutSetPrototypeSettingsUnicodeProperties = layoutSetPrototypeLayoutSet.getSettingsProperties();
                    int mergeFailCount = GetterUtil.getInteger((String)layoutSetPrototypeSettingsUnicodeProperties.getProperty("merge-fail-count"));
                    layoutSetPrototypeSettingsUnicodeProperties.setProperty("merge-fail-count", String.valueOf(++mergeFailCount));
                    this._layoutSetLocalService.updateLayoutSet(layoutSetPrototypeLayoutSet);
                    _log.error((Object)StringBundler.concat((Object[])new Object[]{"Merge fail count increased to ", mergeFailCount, " for layout set prototype ", layoutSetPrototype.getLayoutSetPrototypeId()}), throwable);
                    throw new SystemException(throwable);
                }
                finally {
                    MergeLayoutPrototypesThreadLocal.setInProgress((boolean)false);
                    this._file.delete(file);
                }
            }
            BackgroundTaskResult backgroundTaskResult = BackgroundTaskResult.SUCCESS;
            return backgroundTaskResult;
        }
        finally {
            ExportImportThreadLocal.setLayoutValidationInProcess((boolean)false);
        }
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.setBackgroundTaskStatusMessageTranslator(new LayoutExportImportBackgroundTaskStatusMessageTranslator());
        LayoutSetPrototypeSystemConfiguration layoutSetPrototypeSystemConfiguration = (LayoutSetPrototypeSystemConfiguration)ConfigurableUtil.createConfigurable(LayoutSetPrototypeSystemConfiguration.class, properties);
        String importTaskIsolation = layoutSetPrototypeSystemConfiguration.importTaskIsolation();
        if (Validator.isNotNull((String)importTaskIsolation) && importTaskIsolation.equals("company")) {
            this.setIsolationLevel(2);
        } else {
            this.setIsolationLevel(3);
        }
    }

    protected boolean isCancelPropagationImportTask() {
        try {
            LayoutSetPrototypeConfiguration layoutSetPrototypeConfiguration = this._getLayoutSetPrototypeConfiguration();
            return layoutSetPrototypeConfiguration != null && layoutSetPrototypeConfiguration.cancelPropagationImportTask();
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return false;
        }
    }

    private LayoutSetPrototypeConfiguration _getLayoutSetPrototypeConfiguration() {
        try {
            return (LayoutSetPrototypeConfiguration)this._configurationProvider.getCompanyConfiguration(LayoutSetPrototypeConfiguration.class, CompanyThreadLocal.getCompanyId().longValue());
        }
        catch (ConfigurationException configurationException) {
            _log.error((Object)"Unable to load layout set configuration", (Throwable)configurationException);
            return null;
        }
    }

    private class LayoutImportCallable
    implements Callable<Void> {
        private final ExportImportConfiguration _exportImportConfiguration;
        private final File _file;

        public LayoutImportCallable(ExportImportConfiguration exportImportConfiguration, File file) {
            this._exportImportConfiguration = exportImportConfiguration;
            this._file = file;
        }

        @Override
        public Void call() throws PortalException {
            try {
                this._cleanUpPreviousBackgroundTasks();
                MergeLayoutPrototypesThreadLocal.setInProgress((boolean)true);
                LayoutSetPrototypeImportBackgroundTaskExecutor.this._exportImportLocalService.importLayoutsDataDeletions(this._exportImportConfiguration, this._file);
                LayoutSetPrototypeImportBackgroundTaskExecutor.this._exportImportLocalService.importLayouts(this._exportImportConfiguration, this._file);
                Void void_ = null;
                return void_;
            }
            finally {
                MergeLayoutPrototypesThreadLocal.setInProgress((boolean)false);
            }
        }

        private void _cleanUpPreviousBackgroundTasks() {
            block3: {
                try {
                    List backgroundTasks = LayoutSetPrototypeImportBackgroundTaskExecutor.this._backgroundTaskManager.getBackgroundTasks(this._exportImportConfiguration.getGroupId(), "com.liferay.exportimport.internal.background.task.LayoutSetPrototypeImportBackgroundTaskExecutor");
                    for (BackgroundTask backgroundTask : backgroundTasks) {
                        int status = backgroundTask.getStatus();
                        if (status == 1 || status == 0 || status == 4) continue;
                        LayoutSetPrototypeImportBackgroundTaskExecutor.this._backgroundTaskManager.deleteBackgroundTask(backgroundTask.getBackgroundTaskId());
                    }
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Object)"Unable to clean up previous background tasks", (Throwable)portalException);
                }
            }
        }
    }
}

